//----------------------------------------------------------------
// Konfiguration Version Universal Platine
//----------------------------------------------------------------

// #define UNI_2X  // Universal Platine Version 2.x // am Zeilenanfang entfernen



/****************************************************************/
// Sensorkonfiguration
// 1. Sensor für die Abfrage durch den Sketch aktivieren
// 2. aktive Sensoren für Temperatur/Feuchte in der Sensormatrix zuordnen
/****************************************************************/
#define Anzahl_Sensoren_DHT     1 // Mögliche Anzahl: '0','1','2'  --- Nr 1,2 ---  (Temperatur + Luftfeuchte)
uint8_t DHTTYPE[2] = {22, 22};    // DHT-Typ // DHT 22  (AM2302), AM2321  // DHT 21 (AM2301)


#define Anzahl_Sensoren_Si7021  1 // Mögliche Anzahl: '0','1'      --- Nr 3 -----  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_SHT31   0 // Mögliche Anzahl: '0','1','2'  --- Nr 4,5 ---  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_BME280  0 // Mögliche Anzahl: '0','1','2'  --- Nr 6,7 ---  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_DS18B20 1 // Mögliche Anzahl: '0','1','2'  --- Nr 8,9 ---  (Nur Temperatur)
//                                   Mögliche Anzahl:     '3','4'  --- Nr 10,11 --- ( Messwert bei Single/DUO als "Luftfeuchte" bei 8,9)
//                                   Mögliche Anzahl:     '5'      --- Nr 0 --- 


// 2. Sensormatrix, hier kann die Zuordnung der Sensoren geändert werden
// Nr 1 - 9 aus Liste oben auswählen, wenn kein Sensor gewünscht ist einfach "0" angeben
// wenn kein Sensor für die Aussentemperatur gesetzt ist, wird automatisch der Temperatursensor der RTC verwendet
#define Aussenwerte                               3    // 0 oder Nr. 1 - 11; bei Single:  0 oder Nr. 1 - 8; bei DUO: 0 oder Nr. 1 - 9
// Sensor Beute 1
#define             Beute1                        8    // 0 oder Nr. 1 - 11; bei Single:  0 oder Nr. 1 - 8; bei DUO: 0 oder Nr. 1 - 9
// Sensor Beute 2
#define             Beute2                        0    // 0 oder Nr. 1 - 11; bei DUO: 0 oder Nr. 1 - 9
// mit drei Waagen
#define             Beute3                        0    // 0 oder Nr. 1 - 11
// mit vier Waagen
#define             Beute4                        0    // 0 oder Nr. 1 - 11

// Temperatur Wägezelle (nur Duo, Tripple, Quad usw.)
// Sensor, der die Temperatur der Wägezelle erfasst;  vorbelegt der erste DS18B20
// für Systeme mit einer Waage identisch zum Sensor Aussenwerte eintragen
#define             Temp_Zelle                    8    // Nr. 0 - 11

//----------------------------------------------------------------
// erweiterte Sensoren
//----------------------------------------------------------------
// Luftdruck von BME280
#define Korrektur_Luftdruck     0.0 // Korrekturwert um Abweichungen zu offiziellen Wetterstationen bei Bedarf auszugleichen 

#define Anzahl_Sensor_Regen       0 // Mögliche Anzahl: '0','1'  --- Aux 2 ---- (Regenmesser, erfordert Umbau des beelogger und beelogger_addon.INO)

#define Anzahl_Sensoren_Licht     0 // Mögliche Anzahl: '0','1'      

#define Anzahl_Sensoren_Licht     0 // Mögliche Werte: '0','1'      

//----------------------------------------------------------------
// Konfiguration Waage(n)
//----------------------------------------------------------------

#define Anzahl_Sensoren_Gewicht 1 // Mögliche Werte: '0','1','2','3','4'

// Anschluss / Konfiguration Wägezellen-------------------------------------------------------
// mit Anzahl_Sensoren_Gewicht 1
//   HX711(1) Kanal A = Wägeelement(e) Waage1;
// mit Anzahl_Sensoren_Gewicht 2 zusätzlich:
//   HX711(1) Kanal B = Wägeelement(e) Waage2;
// mit Anzahl_Sensoren_Gewicht 3 zusätzlich:
//   HX711(2) Kanal A = Wägeelement(e) Waage3;
// mit Anzahl_Sensoren_Gewicht 4 zusätzlich:
//   HX711(2) Kanal B = Wägeelement(e) Waage4;

//--------------------------------------------------------------------------------------------
// Kalibrierwerte für die Wägezellen
const long Taragewicht[4] = { 10 , 10 , 10 , 10 , }; // Hier ist der Wert aus der Kalibrierung einzutragen
const float Skalierung[4] = { 1.0 , 1.0 , 1.00 , 1.00 , }; // Hier ist der Wert aus der Kalibrierung einzutragen

const float Kalibriertemperatur[4] = { 1.0, 1.0, 1.0, 1.0 };    // Temperatur zum Zeitpunkt der Kalibrierung
const float KorrekturwertGrammproGrad[4] = { 0.0, 0.0, 1.0, 1.0 };   // Korrekturwert zur Temperaturkompensation - '0' für Deaktivierung

//--------------------------------------------------------------------------------------------
// Kalibrierwerte für die Spannungsmessung Akku
const long Kalib_Spannung =  6180;    // Hier muss der Wert aus der Kalibrierung eingetragen werden, sonst funktioniert der Programmcode nicht
const long Kalib_Bitwert  =  1610;    // Hier muss der Wert aus der Kalibrierung eingetragen werden, sonst funktioniert der Programmcode nicht
//----------------------------------------------------------------


//----------------------------------------------------------------
// Allgemeine Konfiguration
//----------------------------------------------------------------

//----------------------------------------------------------------
// Konfiguration Datentransfer via Serial / FTDI / USB
//----------------------------------------------------------------
#define Serial_DATA  1     // mit oder ohne USB-Datentransfer
//----------------------------------------------------------------

//----------------------------------------------------------------
// Konfiguration Datentransfer via SoftwareSerial Bluetooth z.B. HC-05 Modul
//----------------------------------------------------------------
#define Bluetooth   1      // mit oder ohne Bluetooth
//----------------------------------------------------------------

//----------------------------------------------------------------
#define ID_ID "xyID"       // SystemID für den Datentransfer,
// minimal zwei Zeichen; diese werden in PC-Dateiname übernommen
//----------------------------------------------------------------

//Weckintervallsteuerung
#define WeckIntervall_aktiv  1   // Manuelle Intervallsteuerung 0 = inaktiv, 1 = aktiv

#define WeckIntervall_Tag 10
#define WeckIntervall_Nacht 30
#define WeckIntervall_Nacht_Anfang 22
#define WeckIntervall_Nacht_Ende 6

//Weckintervallsteuerung  Alternativ- / Winter- Intervall
#define WeckIntervall_Winter_aktiv  1   // Intervall Winter 0 = inaktiv, 1 = aktiv
#define WeckIntervall_Winter       60   // Intervall in Minuten
#define WeckIntervall_Winter_Anfang 9   // Monat Winterintervall Start
#define WeckIntervall_Winter_Ende   4   // Monat Winterintervall Ende
// 
#define AlternativIntervallMinuten  120  // Weckinterval, wenn VAlternativ erreicht


//Konfiguration Spannungsversorgung
// Li-Ion Akku beelogger-Solar
//const float VAlternativ = 3.8;       // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum    = 3.75;      // Minimale Spannung ab der ab der keine Messungen und auch kein Versand von Daten erfolgt

// 6V PB-Akku beelogger-Universal
const float VAlternativ = 5.9;       // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
const float VMinimum    = 5.7;       // Minimale Spannung ab der ab der keine Messungen und auch kein Versand von Daten erfolgt

// 2x LiIon-Akku beelogger-Universal
//const float VAlternativ = 7.6;     // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum = 7.5;        // Minimale Spannung ab der keine Messungen und auch kein Versand von Daten erfolgt

// 12V PB-Akku beelogger-Universal
//const float VAlternativ = 11.9;     // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum = 11.5;        // Minimale Spannung ab der keine Messungen und auch kein Versand von Daten erfolgt
//----------------------------------------------------------------
