/*
   (C) 2024  R.Schick / Thorsten Gurzan - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de
// Version 2023.02.18
// 01.04.2023 Universal Platine 2.x
// 15.04.2023 beelogger BME280, DHT - Lib
// 26.01.2026 DS18B20 byte/float Wandlung


#include "Multi_SD_config.h"     // Konfiguration und Kalibrierung eintragen
#include "beelogger_config_SD.h"


//----------------------------------------------------------------
// Parameter SD-Kartenmodul
//----------------------------------------------------------------
#include <SPI.h>
#include <SdFat.h>
#include <EEPROM.h>        // Dateiname ablegen

char DatenString[96];
char File_Name[15] = "xy_test.csv";
//----------------------------------------------------------------


//----------------------------------------------------------------
// Variablen
//----------------------------------------------------------------
const float No_Val  =  99.9;  // Vorbelegung, Wert nicht gemessen
const float No_Value = -1.0;   // Vorbelegung, Wert nicht gemessen


//                              DHT1,   DHT2,   Si7021, SHT31a, SHT31b, BMEa,   BMEb,  DS18B20a,DS18B20b
float SensorTemp[10] = {No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val};

//                                  DHT1,      DHT2,     Si7021,   SHT31a,   SHT31b,   BMEa,     BMEb    , leer    , leer
float SensorFeuchte[10] = {No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value};

//              RTC_Temp, Luftdruck, ZählerRegen
float Aux[3] = {No_Value, No_Value, No_Value};

float Licht = No_Value;
float DS_Temp = No_Val;

float Gewicht[4] = {No_Value, No_Value, No_Value, No_Value};
float LetztesGewicht[4] = {No_Value, No_Value, No_Value, No_Value};

float Batteriespannung = No_Value;
float Solarspannung = No_Value;

float Service = 0.0;
uint32_t time_on;

DateTime aktuell;

uint8_t User_Action  = 0;
volatile bool ok_sleep = true;
//----------------------------------------------------------------



//----------------------------------------------------------------
//----------------------------------------------------------------
void setup() {

  //----------------------------------------------------------------
  //  System on
  //----------------------------------------------------------------
  digitalWrite(Power_Pin, HIGH);
  pinMode(Power_Pin, OUTPUT);
  delay(5);
  hx711_SCK_High();
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  //  Setup RTC
  //----------------------------------------------------------------
  rtc.begin();
  rtc.clearINTStatus();
  delay(5);

  DateTime pc_tim = DateTime(__DATE__, __TIME__);
  uint32_t l_pczeit = pc_tim.get();
  aktuell = rtc.now();
  uint32_t l_zeit = aktuell.get();
  if (l_pczeit > l_zeit)  rtc.setDateTime(l_pczeit); // RS
  time_on = l_zeit;
  //----------------------------------------------------------------


  //----------------------------------------------------------------
  //  Sleep Mode Interrupt
  //----------------------------------------------------------------
  pinMode(DS3231_Interrupt_Pin, INPUT_PULLUP);
  delay(5);
  //----------------------------------------------------------------


  //----------------------------------------------------------------
  // Setup SD-Kartenmodul
  //----------------------------------------------------------------
  digitalWrite(SD_LED, LOW);
  pinMode(SD_LED, OUTPUT);

  uint8_t ee_val = EEPROM.read(0);             // Dateiname in EE-Prom
  if ((ee_val >= '0') && (ee_val <= '9')) { // Pruefe erstes Zeichen
    EEPROM.get(0, File_Name);               // Hole aktuellen Dateiname aus EE-Prom
  }
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  //  USB Serieller Datentransfer
  //----------------------------------------------------------------
  Seriell_data();         // Datenabfrage via FTDI(USB)
}
//----------------------------------------------------------------


//##################################################################
void loop() {

  if (User_Action == 1) {
    BlueTooth_data();       // Bluetooth(SoftSerial)
    User_Action = 0;
  }
  else {
    debugbegin(57600);
    debugprintln(ID_ID);
    debugflush();

    Spannungen_messen();
    if (Batteriespannung > VMinimum) {
      Sensor_Temp_Zelle(0);
      Sensor_DS18B20();
      Sensor_DHT();
      Sensor_Si7021();
      Sensor_SHT31();
      Sensor_BME280();
      Sensor_Temp_Zelle(1);
      Sensor_Licht();
      Sensor_Gewicht(false);
      if (DS_Temp == No_Val) DS_Temp = Aux[0];    // force rtc temp.
      for (int i = 0; i < Anzahl_Sensoren_Gewicht; i++) {
        Gewicht[i] = Gewicht[i] - ((DS_Temp - Kalibriertemperatur[i]) * KorrekturwertGrammproGrad[i]);
      }
      Daten_auf_SD_speichern();
    }
    Alarm_konfigurieren();
    debugflush();
    debugend();
    Serial_rxtx_off();
    SleepNow();
  }
}
//##################################################################
