// 15.11.2024 Datensatz Sekunde auf 0

//----------------------------------------------------------------
// Funktion Seriell_data();         // Datenabfrage via FTDI(USB)
//----------------------------------------------------------------
void Seriell_data() // Sende Daten an PC
{
#if Serial_DATA

  SdFat SD;
  File dataFile;
  long l_time;
  int  i;
  unsigned int  j;
  char c_data;

  // das öffnen des Comport am PC löst einen Reset des Arduino aus
  // das Zeichen vom PC startet die gewaehlte Aktion
  // = ?  Daten holen
  // = #  aktuelle Daten lesen
  // = Z  setze Zeit
  // = *  neuen Namen für Datendatei
  //
  Serial.begin(57600, SERIAL_8N1); // fuer Datenabfrage Serial starten
  delay(10);

  Serial.println("*");         // Sende an PC fertig für Empfang
  debugprintln("turn Debug off for downloading correct csv-format datafiles via serial");
  Serial.flush();
  for (i = 0; i < 30; i++) {        // warte auf Kommando vom PC
    delay(100);                     // alle 100ms abfragen
    if (Serial.available() > 0) {   // Daten ?
      char inChar = (char)Serial.read();   // get the new char:
      
      if (inChar == '?') {                 // if the incoming character is a ?
        //while ((char)Serial.read() != -1 ) {}; // Input leer ?
        sprintf(DatenString, "%s", ID_ID);
        sprintf(DatenString + 2, "%s", File_Name);
        Serial.println(DatenString);  // Waagekennung für PC
        Serial.flush();
        if (SD.begin(SD_CS, SPI_HALF_SPEED)) {
          if ( dataFile = SD.open(File_Name, FILE_READ)) {
            j = 0;
            while (dataFile.available()) { // Zeichen für Zeichen
              c_data = dataFile.read();
              if ((c_data == '\r') || (c_data == '\n')) { // Zeilenende
                DatenString[j - 1] = 0;
                Serial.println(DatenString); // mit NL
                Serial.flush();
                delay(10); // damit seriell fertig wird
                j = 0;     // buffer von vorne fuellen
              }
              else if (j < sizeof(DatenString)) { // grenze buffer
                DatenString[j] = c_data;
                j++;
              }
            }
            dataFile.close();         // close the file
            delay(5000);              // force PC-Software timeout
          } // file open
        }   // SD begin
        break;  // end for
      }
      else if (inChar == 'Z') {       //Setze Zeit in RTC
        j = 0;
        while ((c_data = Serial.read()) != -1 ) { // Input lesen
          DatenString[j] = c_data;
          j++;
          if (j > 16) break;
        }
        DatenString[j] = 0;
        l_time = atol(DatenString);
        l_time = l_time - 946684800;  // EPOCH_TIME_OFF = Korrektur DS3231
        rtc.setDateTime(l_time);
        aktuell = rtc.now();          // neue Zeit
        break;  // end for
      }
      else if (inChar == '*') {       // neuer Name fuer Datei auf SD
        sprintf(File_Name, "%d", aktuell.year());  // 20xy
        sprintf(File_Name + 4, "%2.2d", aktuell.month()); // Monat
        sprintf(File_Name + 6, "%2.2d", aktuell.date());  // Tag
        File_Name[8] = '.';
        File_Name[9] = 'c';
        File_Name[10] = 's';
        File_Name[11] = 'v';
        File_Name[12] = 0;
        EEPROM.put(0, File_Name);
        Serial.println(File_Name);    // mit NL
        break;  // end for
      }
      else if (inChar == '#') {       // aktuelle Werte
        Spannungen_messen();
        DS_Temp = No_Val;
        Sensor_DS18B20();
        Sensor_DHT();
        if ((DS_Temp == No_Val)) DS_Temp = rtc.getTemperature();
        Sensor_Licht();
        Sensor_Gewicht(true);
        DatenString_erstellen();          // CSV-Datenstring
        Serial.println(DatenString);  // mit NL
        Serial.println(File_Name);
        Serial.println(ID_ID);          break;  // end for
      }
    } // serial available
  }  // for i
  delay(50); // damit seriell fertig wird
#if (myDEBUG == 0)
  Serial.end();        // Serial aus
  delay(50);
  digitalWrite(USB_RX, LOW);   // Port aus
  pinMode(USB_TX, INPUT);
  digitalWrite(USB_TX, LOW);   // Port aus
#endif
#endif
}
//----------------------------------------------------------------

//----------------------------------------------------------------
//  Funktion  BlueTooth_data();       // Bluetooth(SoftSerial)
//----------------------------------------------------------------
void BlueTooth_data() {

#if Bluetooth  // nur wenn konfiguriert

  SdFat SD;
  File dataFile;
  unsigned int  j;
  char c_data;

  // = ?  Daten holen
  // = #  aktuelle Daten lesen
  // = *  neuer Dateiname

  // Bluetooth via HC-05 Modul
  // beelogger braucht Ein-Schalter für Modul und externen Reset-Taster
  // Das Signal "eingeschaltet" wird auf Pin Blue_on gelegt.
  // Mit Interrupt wird der SoftwareSerial gestartet und wartet auf Eingaben.
  // Beenden mit Aus-Schalten der Bluetoooth-Modul Versorgung.

  if (digitalRead(Blue_On)) {
    SoftwareSerial blueSerial(Blue_RX, Blue_TX); //RX,TX
    blueSerial.begin(Blue_Baurate);
    delay(200);
    
    debugbegin(57600);
    debugprintln("BT on");

    while (digitalRead(Blue_On)) {
      delay(100);                     // alle 100ms abfragen
      if (blueSerial.available() > 0) {   // Daten ?
        char inChar = (char)blueSerial.read();      // get the new char:

        debugprint("BT in: ");
        debugprintln(inChar);

        while (blueSerial.read() != -1 ) {}; // Input leer ?
        if (inChar == '?') {                 // if the incoming character is a ?
          if (SD.begin(SD_CS, SPI_HALF_SPEED)) {
            debugprint("SD: ");
            if ( dataFile = SD.open(File_Name, FILE_READ)) {
              debugprint(" open!");
              debugprintln(File_Name);

              j = 0;
              while (dataFile.available()) { // Zeichen für Zeichen
                c_data = dataFile.read();
                debugprint(c_data);
                debugflush();

                if ((c_data == '\r') || (c_data == '\n')) { // Zeilenende
                  DatenString[j] = c_data;
                  DatenString[j + 1] = 0;
                  blueSerial.print(DatenString); // mit NL
                  delay(50); // damit seriell fertig wird
                  j = 0;     // buffer von vorne fuellen
                }
                else if (j < sizeof(DatenString)) {
                  DatenString[j] = c_data;
                  j++;
                }
              }
              dataFile.close();       // close the file
            }// file open
          }
        }
        else if (inChar == '*') {       // neuer Name fuer Datei auf SD
          sprintf(File_Name, "%d", aktuell.year());  // 20xy
          sprintf(File_Name + 4, "%2.2d", aktuell.month()); // Monat
          sprintf(File_Name + 6, "%2.2d", aktuell.date());  // Tag
          File_Name[8] = '.';
          File_Name[9] = 'c';
          File_Name[10] = 's';
          File_Name[11] = 'v';
          File_Name[12] = 0;
          EEPROM.put(0, File_Name);
          blueSerial.println(File_Name);
          debugprintln(File_Name);    // mit NL
          break;  // end for
        }
        else if (inChar == '#') {    // # = aktuelle Werte
          blueSerial.println(File_Name);
          Spannungen_messen();
          DS_Temp = No_Val;
          Sensor_DS18B20();
          if ((DS_Temp == No_Val)) DS_Temp = rtc.getTemperature();
          Sensor_Licht();
          Sensor_Gewicht(true);
          DatenString_erstellen();          // CSV-Datenstring
          debugprintln(DatenString);
          debugflush();
          blueSerial.println(DatenString); // mit NL
          delay(50); // damit seriell fertig wird
        }
        else {
          //     break;  // ungültiges Zeichen, Ende while
        }
      } // serial available
    }  // while blue on
    delay(50);
    blueSerial.end();
    debugend();
    delay(10);

    digitalWrite (Blue_TX, LOW);       //  TX aus
    pinMode( Blue_TX, INPUT);
    digitalWrite (Blue_RX, LOW);
  }
#endif // Bluetooth
}
//----------------------------------------------------------------

//----------------------------------------------------------------
// Funktion SD-Kartenmodul - Daten auf SD speichern
//----------------------------------------------------------------
void Daten_auf_SD_speichern() {

  SdFat SD;
  File dataFile;

  if (SD.begin(SD_CS, SPI_HALF_SPEED)) {
    DatenString_erstellen();
    debugprint("to SD ");
    dataFile = SD.open(File_Name, FILE_WRITE);
    if (dataFile) {
      dataFile.println(DatenString);
      dataFile.close();
      debugprint("written: ");
      debugprintln(DatenString);
      debugflush();
      if (LED_ON == 1) {
        digitalWrite(SD_LED, HIGH);
        delay(150);
        digitalWrite(SD_LED, LOW);
        LED_ON = 0;
      }
    }
  }
  if (LED_ON == 1) {
    digitalWrite(SD_LED, HIGH);
    LowPower.powerStandby(SLEEP_2S, ADC_OFF, BOD_OFF);
    digitalWrite(SD_LED, LOW);
  }
  delay(100);
  SPI.end();
  LED_ON = 0;
}
//----------------------------------------------------------------



//----------------------------------------------------------------
// Funktion Datenstring erstellen
//----------------------------------------------------------------
void DatenString_erstellen() {

  int count = 0;
  aktuell = rtc.now();
  count = sprintf(DatenString, "%d/", aktuell.year());
  count += sprintf(DatenString + count, "%2.2d/", aktuell.month());
  count += sprintf(DatenString + count, "%2.2d ", aktuell.date());
  count += sprintf(DatenString + count, "%2.2d:", aktuell.hour());
  count += sprintf(DatenString + count, "%2.2d:00", aktuell.minute());
//  count += sprintf(DatenString + count, "%2.2d", aktuell.second());

  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, DS_Temp, 1, No_Val);             // Wägezellentemperatur
  }
  count = Wert_hinzufuegen(count, SensorTemp[Beute1], 1, No_Val);    // Stocktemperatur 1
  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute2], 1, No_Val);  // Stocktemperatur 2
  }
  if (Anzahl_Sensoren_Gewicht > 2) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute3], 1, No_Val);  // Stocktemperatur 3
  }
  if (Anzahl_Sensoren_Gewicht > 3) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute4], 1, No_Val);  // Stocktemperatur 4
  }
  float AussenTemp = SensorTemp[Aussenwerte];
  if (AussenTemp == No_Val) AussenTemp = DS_Temp;  // Temp aus RTC
  count = Wert_hinzufuegen(count, AussenTemp, 1, No_Val);            // Außentemperatur

  count = Wert_hinzufuegen(count, SensorFeuchte[Beute1], 1, No_Value);     // Stockluftfeuchte 1
  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute2], 1, No_Value);   // Stockluftfeuchte 2
  }
  if (Anzahl_Sensoren_Gewicht > 2) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute3], 1, No_Value);   // Stockluftfeuchte 3
  }
  if (Anzahl_Sensoren_Gewicht > 3) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute4], 1, No_Value);   // Stockluftfeuchte 4
  }
  count = Wert_hinzufuegen(count, SensorFeuchte[Aussenwerte], 1, No_Value);  // Außenluftfeuchte
  count = Wert_hinzufuegen(count, Licht, 1, No_Value);                 // Licht
  count = Wert_hinzufuegen(count, Gewicht[0], 2, No_Value);            // Gewicht 1
  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, Gewicht[1], 2, No_Value);          // Gewicht 2
  }
  if (Anzahl_Sensoren_Gewicht > 2) {
    count = Wert_hinzufuegen(count, Gewicht[2], 2, No_Value);          // Gewicht 3
  }
  if (Anzahl_Sensoren_Gewicht > 3) {
    count = Wert_hinzufuegen(count, Gewicht[3], 2, No_Value);          // Gewicht 4
  }
  count = Wert_hinzufuegen(count, Batteriespannung, 2, No_Value); // Akkuspannung
  count = Wert_hinzufuegen(count, Solarspannung, 2, No_Value);    // Solarspannung
  count = Wert_hinzufuegen(count, Service, 2, No_Value);    // Service
  count = Wert_hinzufuegen(count, Aux[1], 1, No_Value);  // Aux 1 Luftdruck
  count = Wert_hinzufuegen(count, Aux[2], 2, No_Value);  // Aux 2 Regen
  count = Wert_hinzufuegen(count, Aux[0], 2, No_Value);  // Aux 0 RTC-Temp
  count = Wert_hinzufuegen(count, No_Value, 2, No_Value);  // dummy
  count = Wert_hinzufuegen(count, No_Value, 2, No_Value);  // dummy
  DatenString[count] = 0;
}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion Wert hinzufügen
//----------------------------------------------------------------
int Wert_hinzufuegen(int count, float Wert, byte Nachkommastellen, float Fehler) {
  char Konvertierung[16];
  int count_neu = count;

  if (Wert == Fehler) {
    count_neu += sprintf(DatenString + count, ",%s", "");
  } else {
    dtostrf(Wert, 1, Nachkommastellen, Konvertierung);
    count_neu += sprintf(DatenString + count, ",%s", Konvertierung);
  }
  return count_neu;
}
//----------------------------------------------------------------
