  /*
   (C) 2018 R.Schick - beelogger.de

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de

// Sketch für die Konfiguration des Bluetooth Modul HC-05
//
// Hier wird die neue Serial-Baudrate, für den beelogger "38400" 
// Name und Pairing-Passwort (vierstellig, nur Zahlen)angegeben
char BLUETOOTH_SPEED[] = "38400"; //This is the default baudrate that HC-05 uses

char BLUETOOTH_NAME[] = "HC-05";
char PASSWORT[] = "1234";  // vier Stellen


// Swap RX/TX connections on bluetooth chip
#define Blue_TX     9      // Bluetooth TX Solar = 9, Universal = 8
#define Blue_RX     8      // Bluetooth RX Solar = 8, Universal = 9
#define BLUETOOTH_DEFAULT_KONFIG_SPEED 38400 //This is the default baudrate that HC-05 uses



#include <SoftwareSerial.h>
SoftwareSerial BlueSerial(Blue_RX, Blue_TX); // RX, TX

/*
  The possible baudrates are:
    AT+UART=1200,0,0 -------1200
    AT+UART=2400,0,0 -------2400
    AT+UART=4800,0,0 -------4800
    AT+UART=9600,0,0 -------9600 - Default for hc-06
    AT+UART=19200,0,0 ------19200
    AT+UART=38400,0,0 ------38400
    AT+UART=57600,0,0 ------57600 - Johnny-five speed
    AT+UART=115200,0,0 -----115200
    AT+UART=230400,0,0 -----230400
    AT+UART=460800,0,0 -----460800
    AT+UART=921600,0,0 -----921600
    AT+UART=1382400,0,0 ----1382400
*/

// beelogger Solar Power
#define Power_Pin  4

void setup() {
  char c;
  digitalWrite(Power_Pin, HIGH);
  pinMode(Power_Pin, OUTPUT);

  Serial.begin(57600);
  delay(1000);

  Serial.println(F("Konfiguration Bluetooth-Modul HC-05."));
  Serial.println(" ");
  Serial.println(F("Taster am Modul drücken und Spannung für das Modul einschalten!"));
  Serial.println(F("Das Modul muss langsam blinken."));
  Serial.println();
  Serial.println(F(" '1' eingeben zum Start."));
  while (c != '1') {
    c = Serial.read();
  };
  c = 'x';

  delay(100);

  Serial.println(" ");
  Serial.println("Starte Konfiguration:");
  // Default Serial setup speed for AT-Commands is 38400
  BlueSerial.begin(BLUETOOTH_DEFAULT_KONFIG_SPEED);
  delay(3000);

  // Should respond with OK
  Serial.println("Sende: AT");
  BlueSerial.print("AT\r\n");
  waitForResponse();
  waitForResponse();

  // Should respond with its version
  Serial.println("Sende: AT+VERSION");
  BlueSerial.print("AT+VERSION\r\n");
  waitForResponse();
  waitForResponse();

  // Set pin to configured password
  String pwd = String("AT+PSWD=") + PASSWORT + String("\r\n");
  Serial.print("Sende: ");
  Serial.print(pwd);
  BlueSerial.print(pwd);
  waitForResponse();
  waitForResponse();

  // Set the name to configured name
  String rnc = String("AT+NAME=") + BLUETOOTH_NAME + String("\r\n");
  Serial.print("Sende: ");
  Serial.print(rnc);
  BlueSerial.print(rnc);
  waitForResponse();
  waitForResponse();

  // Set baudrate to configured speed
  String bd_rate = String ("AT+UART=") + BLUETOOTH_SPEED + String(",0,0\r\n");
  Serial.print("Sende: ");
  Serial.print(bd_rate);
  BlueSerial.print(bd_rate);
  waitForResponse();
  waitForResponse();
  waitForResponse();


  Serial.println(F("Antwortet das Modul mit OK,"));
  Serial.println(F("dann war der Vorgang erfolgreich."));
  Serial.println("  ");
  Serial.println("  ");
  Serial.println("  ");


  Serial.println(F("Wenn nicht, dann stimmt die Default-Baudrate nicht,"));
  Serial.println(F("das Modul ist nicht im AT-Mode (langsam blinken),"));
  Serial.println(F("oder TX/RX sind nicht richtig verdrahtet."));

  Serial.println(F("beeelogger-Universal:"));
  Serial.println(F("HC-05 RX an Pin RX am SIM800L"));
  Serial.println(F("HC-05 TX an Pin RX am SIM800L"));
  Serial.println(F("RX/TX Konfig im Sketch:"));
  Serial.println(F("#define Blue_TX     9 "));
  Serial.println(F("#define Blue_RX     8 "));

  

  //Serial.end();
  //BlueSerial.end();
}

void waitForResponse() {
  while (BlueSerial.available()) {
    Serial.write(BlueSerial.read());
  }
  Serial.write("\n");
  delay(1000);
}

void loop() {
  delay(20000);
}
