//16.05.2022 DHT Pinmode
// 01.04.2023 Universal Platine 2.x

//----------------------------------------------------------------
// Funktion Spannungen messen
//----------------------------------------------------------------
void Spannungen_messen() {
  Batteriespannung = Messe_Spannung(Batterie_messen);
#if myDEBUG
  Serial.print(F(" Batterie [V]: "));
  Serial.println(Batteriespannung);
  Serial.flush();
#endif
  if (Batteriespannung > VMinimum) {
    Solarspannung = Messe_Spannung(Solarzelle_messen);
#if myDEBUG
    Serial.print(F(" Solarspannung [V]: "));
    Serial.println(Solarspannung);
    Serial.flush();
#endif
  }
}

float Messe_Spannung (byte Pin) {
  int Messung_Spannung;
  float Spannung;
  Messung_Spannung = analogRead(Pin);
  Messung_Spannung = 0;
  for (byte j = 0 ; j < 16; j++) {
    Messung_Spannung += analogRead(Pin);
  }
  Messung_Spannung = Messung_Spannung >> 2;
  Spannung = (float)map(Messung_Spannung, 0, Kalib_Bitwert, 0, Kalib_Spannung) / 1000.0;
  return (Spannung);
}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion Alarm konfigurieren
//----------------------------------------------------------------
void Alarm_konfigurieren() {
  int IntervallMinuten;
  long l_tm = aktuell.get();
  int hnow = aktuell.hour();

  uint32_t tt = l_tm - time_on;      // calc time_on
  if (tt == 0) tt = 1;               // minimum 1 -> not a reset
  time_on = tt;                      // store total TimeOn

  if (Batteriespannung > VAlternativ) {
    IntervallMinuten = WeckIntervall_default;
    // Lora spezial Intervall konfig
    if (WeckIntervall_aktiv) {  // Manuelle Intervalsteuerung aktiviert
      if ( (hnow >= WeckIntervall_Nacht_Anfang ) || (hnow < WeckIntervall_Nacht_Ende) ) {
        IntervallMinuten = WeckIntervall_Nacht;
      } else {
        IntervallMinuten = WeckIntervall_Tag;
      }
      if (WeckIntervall_Winter_aktiv == 1) {  // Winterintervall aktiviert
        if ((aktuell.month() > WeckIntervall_Winter_Anfang) || (aktuell.month() < WeckIntervall_Winter_Ende)) {
          IntervallMinuten = WeckIntervall_Winter;
        }
      }
    }
  } else {
    IntervallMinuten = AlternativIntervallMinuten;
  }
  if (IntervallMinuten < 5) IntervallMinuten = 5; // minimal Intervall
  debugprintF("Intervall: ");  debugprintln(IntervallMinuten);

#if 1
  l_tm = l_tm  + IntervallMinuten * 60; // xx minutes later
  aktuell = l_tm - l_tm % 300;             // adjust to five minute
#else
  IntervallMinuten = 2;
  l_tm = l_tm  + IntervallMinuten * 60; // xx minutes later
  aktuell = l_tm - l_tm % 120;             // adjust to five minute
#endif

  rtc.enableInterrupts(aktuell.hour(), aktuell.minute(), 0); //interrupt at  hour, minute, second

  debugprintF("Wakeup at: ");
  debugprint(aktuell.hour());
  debugprint(":");
#if myDEBUG
  if (aktuell.minute() < 10) debugprint("0");
#endif
  debugprintln(aktuell.minute());
  debugflush();

}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion SleepNow
//----------------------------------------------------------------
void SleepNow() {
  delay(5);

  hx711_SCK_Low();    // code order, important!
  digitalWrite(Power_Pin, LOW);
  delay(5);

  TWCR &= ~(bit(TWEN) | bit(TWIE) | bit(TWEA));
  digitalWrite (A4, LOW);
  digitalWrite (A5, LOW);

  digitalWrite (SD_CS, LOW);
  pinMode (SD_MOSI, INPUT);

  attachInterrupt(digitalPinToInterrupt(DS3231_Interrupt_Pin), WakeUp, LOW);
  delay(1);
  while (ok_sleep) {
    LowPower.powerDown(SLEEP_FOREVER, ADC_OFF, BOD_OFF);
    delay(50);
  }

  // check for User Interrupt
  LowPower.powerStandby(SLEEP_500MS, ADC_OFF, BOD_OFF);

#if Bluetooth  // nur wenn konfiguriert
  if (digitalRead(DS3231_Interrupt_Pin) == 0) {
    LowPower.powerStandby(SLEEP_1S, ADC_OFF, BOD_OFF);
    if (digitalRead(DS3231_Interrupt_Pin) == 0) {
      User_Action = 1;
    }
  }
#else
  // nicht bei INT mit Bluetooth Schalter
  if (digitalRead(DS3231_Interrupt_Pin) == false) {      // switch on, warte 15 Minuten
    uint8_t i = 0;
    do {
      i++;
      LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF);
      delay(50);  // debounce switch at interrupt pin.
    } while ((i < 105)); // 105 = ca.15 Minuten Ruhe
  }
#endif

  pinMode (SD_MOSI, OUTPUT);
  hx711_SCK_High();
#if (Anzahl_Sensoren_DHT > 0 )
  //pinMode (DHT_Sensor_Pin[0], INPUT);
#endif
#if (Anzahl_Sensoren_DHT > 1)
  //pinMode (DHT_Sensor_Pin[1], INPUT);
#endif

  digitalWrite(Power_Pin, HIGH);
  delay (5);

  rtc.begin();
  rtc.clearINTStatus();

  delay(50);
  ok_sleep = true;

  Service = (float)time_on; //saving last TimeOn in Service
  aktuell = rtc.now();
  time_on = aktuell.get();    // Set time_on

}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion WakeUp
//----------------------------------------------------------------
void WakeUp() {
  ok_sleep = false;
  detachInterrupt(digitalPinToInterrupt(DS3231_Interrupt_Pin));
}
//----------------------------------------------------------------
