/*!
   @file readData.ino
   @brief Download this demo to test simple read from bmp280, connect sensor through IIC interface.
   @n  Data will print on your serial monitor

   @copyright   Copyright (c) 2010 DFRobot Co.Ltd (http://www.dfrobot.com)
   @license     The MIT License (MIT)
   @author [Frank](jiehan.guo@dfrobot.com)
   @version  V1.0
   @date  2019-03-12
   @url https://github.com/DFRobot/DFRobot_BMP280
*/


#if (Test_SD_Card) || (_BMP280_ == 0)

void Sensor_BMP280(uint8_t addr) {
  Serial.print(F("no test for BMP 280\n"));
}

#else

#include "DFRobot_BMP280.h"
#include "Wire.h"

void Sensor_BMP280(uint8_t addr) {
  float Temperatur_BMP, Luftdruck_BMP;            // Create the temperature, pressure variables
  uint8_t success = 0;
  uint32_t t = millis();

  DFRobot_BMP280_IIC::eSdo_t eSdo = (addr == 0x76) ? DFRobot_BMP280_IIC::eSdoLow : DFRobot_BMP280_IIC::eSdoHigh;
  
  DFRobot_BMP280_IIC  bmp(&Wire, eSdo);

  Serial.println("BMP280");
  bmp.reset();
  do {
    if (bmp.begin() == DFRobot_BMP280_IIC::eStatusOK) { // Check if the measurement is complete
      success = 1;
      break;
    }
    delay(200);
  }
  while (millis() - t < 1000);  // 1 sec timeout
  delay(100);

  if (success) {
    Temperatur_BMP = bmp.getTemperature();
    uint32_t    press = bmp.getPressure();
    Luftdruck_BMP = float(press) / 100.0;

    Serial.print(F(" [hPa]: "));
    Serial.println(Luftdruck_BMP);
    Serial.print(F(" [C]: "));
    Serial.println(Temperatur_BMP);
  }
  else {
    Serial.println("*");
  }

  Serial.println(" ");
  Serial.flush();
  Wire.end();
}
#endif
