//----------------------------------------------------------------
// TwoWire
//----------------------------------------------------------------

#include "Wire.h"
extern "C" {
#include "utility/twi.h"  // from Wire library, so we can do bus scanning
}

byte start_address = 8;       // lower addresses are reserved to prevent conflicts with other protocols
byte end_address = 119;       // higher addresses unlock other modes, like 10-bit addressing


void discoverI2CDevices()
{
  uint8_t cnt = 0;
  
  Wire.begin();
  Wire.setClock(100000);
  Serial.println(F("\nI2C-Scanner:"));

  Serial.print(F("scanning of I2C bus from 0x"));
  Serial.print(start_address, HEX);
  Serial.print(" to 0x");
  Serial.print(end_address, HEX);
  Serial.println("...");
  Serial.flush();
  for ( byte addr = start_address; addr <= end_address; addr++ ) {
    Wire.beginTransmission(addr);
    uint8_t error = Wire.endTransmission();
    if (error == 0) {
      i2c_device[cnt] = addr;
      cnt++;
      if (cnt == 16) break; // array limit
      Serial.print("found at address 0x");
      Serial.println(addr, HEX);
    }
    else if (error == 4) {
      Serial.print("Unknown error at address 0x");
      Serial.println(addr, HEX);
    }
  }
  Serial.println(F("I2C scan done"));
  Serial.println(" ");
  Serial.flush();
  Wire.end();
}
//--------------------------------------------------------------
