/****************************************************************/
// Sensorkonfiguration
// 1. Sensor für die Abfrage durch den Sketch aktivieren
// 2. aktive Sensoren für Temperatur/Feuchte in der Sensormatrix zuordnen
// 3. Sensor für Temperatur Wägezelle festlegen
/****************************************************************/
#define Anzahl_Sensoren_DHT     0 // Mögliche Anzahl: '0','1','2'  --- Nr 1,2 ---  (Temperatur + Luftfeuchte)
uint8_t DHTTYPE[2] = {22, 22};    // DHT-Typ 21 oder 22  (nur Adafruit DHT-Lib)

#define Anzahl_Sensoren_Si7021  0// Mögliche Anzahl: '0','1'      --- Nr 3 -----  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_SHT31   0 // Mögliche Anzahl: '0','1','2'  --- Nr 4,5 ---  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_BME280  0 // Mögliche Anzahl: '0','1','2'  --- Nr 6,7 ---  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_DS18B20 1 // Mögliche Anzahl: '0','1','2'  --- Nr 8,9 ---  (Nur Temperatur)
//                                   Mögliche Anzahl:     '3','4'  --- Nr 10,11 --- ( Messwert bei Single/DUO als "Luftfeuchte" bei 8,9)
//                                   Mögliche Anzahl:     '5'      --- Nr 0 --- 


// 2. Sensormatrix, hier kann die Zuordnung der Sensoren geändert werden
// Nr 1 - 9 aus Liste oben auswählen, wenn kein Sensor gewünscht ist einfach "0" angeben
// wenn kein Sensor für die Aussentemperatur gesetzt ist, wird automatisch der Temperatursensor der RTC verwendet
#define Aussenwerte                               0    // 0 oder Nr. 1 - 11; bei Single:  0 oder Nr. 1 - 8; bei DUO: 0 oder Nr. 1 - 9
// Sensor Beute 1
#define             Beute1                        0    // 0 oder Nr. 1 - 11; bei Single:  0 oder Nr. 1 - 8; bei DUO: 0 oder Nr. 1 - 9
// Sensor Beute 2
#define             Beute2                        0    // 0 oder Nr. 1 - 11; bei DUO: 0 oder Nr. 1 - 9
// mit drei Waagen
#define             Beute3                        0    // 0 oder Nr. 1 - 11
// mit vier Waagen
#define             Beute4                        0    // 0 oder Nr. 1 - 11


// Temperatur Wägezelle (nur Duo, Tripple, Quad usw.)
// Sensor, der die Temperatur der Wägezelle erfasst;  vorbelegt der erste DS18B20
// für Systeme mit einer Waage identisch zum Sensor Aussenwerte eintragen
#define             Temp_Zelle                    8    // Nr. 0 - 11


/****************************************************************/
// erweiterte Sensoren
/****************************************************************/
// Luftdruck von BME280
#define Korrektur_Luftdruck     0.0 // Korrekturwert um Abweichungen zu offiziellen Wetterstationen bei Bedarf auszugleichen 


#define Anzahl_Sensoren_Licht     0 // Mögliche Anzahl: '0','1'      



/****************************************************************/
// Konfiguration Waage(n)
/****************************************************************/
#define Anzahl_Sensoren_Gewicht 1 // Mögliche Anzahl: '1','2','3','4'

// Anschluss / Konfiguration Wägezellen
// mit Anzahl_Sensoren_Gewicht 1
//   HX711(1) Kanal A =  Waage1;
// mit Anzahl_Sensoren_Gewicht 2 zusätzlich:
//   HX711(1) Kanal B =  Waage2;


/****************************************************************/
// Kalibrierwerte für die Wägezellen
const long Taragewicht[4] = { 10 , 10 , 10 , 10}; // Hier ist der Wert aus der Kalibrierung einzutragen
const float Skalierung[4] = { 1.0, 1.0 , 1.00 , 1.00}; // Hier ist der Wert aus der Kalibrierung einzutragen


/****************************************************************/
// Kalibrierwerte für die Spannungsmessung Akku
const long Kalib_Spannung = 12500;    // Hier muss der Wert aus der Kalibrierung eingetragen werden, sonst funktioniert der Programmcode nicht
const long Kalib_Bitwert  = 3220;    // Hier muss der Wert aus der Kalibrierung eingetragen werden, sonst funktioniert der Programmcode nicht

//Konfiguration Spannungsversorgung


// 6V PB-Akku beelogger-Universal
//const float VAlternativ = 5.9;       // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum    = 5.7;       // Minimale Spannung ab der ab der keine Messungen und auch kein Versand von Daten erfolgt

// 2x LiIon-Akku beelogger-Universal
const float VAlternativ = 7.6;     // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
const float VMinimum = 7.5;        // Minimale Spannung ab der keine Messungen und auch kein Versand von Daten erfolgt

// 12V PB-Akku beelogger-Universal
//const float VAlternativ = 11.9;     // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum = 11.5;        // Minimale Spannung ab der keine Messungen und auch kein Versand von Daten erfolgt

// Li-Ion Akku beelogger-SMD
//const float VAlternativ = 3.8;       // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum    = 3.75;      // Minimale Spannung ab der ab der keine Messungen und auch kein Versand von Daten erfolgt
/****************************************************************/


/****************************************************************/
// WLAN Parameter
// Zwei WLAN Zugangspunkte können konfiguriert wählen,
// der jeweils verfügbare wird verwendet
// WLan Daten unbedingt nach Verfügbarkeit und Stärke eintragen (stärkstes in Nr. 1)
// Hinweis: ESP-Testsketch zeigt alle Feldstärken an
/****************************************************************/
#define Anzahl_AP 1  // Mögliche Werte: '1','2'

// Zugangspunkt Nr. 1 Daten  = vorrangiger/primärer Zugangspunkt
const char  Access_Point1[] PROGMEM =  "WLAN-Name_1";
// Passwort des Zugangspunktes Nr. 1
const char AP_Passwort_1[] PROGMEM = "WLAN-Passwort_1";

// Zugangspunkt Nr. 2 Daten
const char  Access_Point2[] PROGMEM =  "WLAN-Name_2";
// Passwort des Zugangspunktes Nr. 2
const char AP_Passwort_2[] PROGMEM = "WLAN-Passwort_2";


/****************************************************************/
// Verbindung zum Server
// Parameter zu Datenübertragung
/****************************************************************/
// Domainname zum Webserver mit beelogger-Skript
const char serverName[] PROGMEM = "community.beelogger.de"; //"meineDomain.de";

// GET mit Verzeichnis auf dem Webserver und PHP-Skript für den jeweiligen beelogger
// mit Anzahl_Sensoren_Gewicht
// 1 - Bsp: "GET /USERX/beeloggerY/beelogger_log.php?"
// 2 - Bsp: "GET /USERX/DuoY/beelogger_log.php?"
// 3 - Bsp: "GET /USERX/TripleY/beelogger_log.php?"
// 4 - Bsp: "GET /USERX/QuadY/beelogger_log.php?"


// Bsp: {"GET /DeinAccount/beelogger1/beelogger_log.php?"};

const char beelogger_pfad[] PROGMEM = {"GET /USERX/SystemY/beelogger_log.php?"};   // "USERX" und "SystemY" ersetzen
// Passwort vom Webserver-Skript
const char Passwort[] PROGMEM = "Log";  // hier dein beelogger-log - Passwort


// Sendebeschränkung während Nachtstunden
#define DO_NOT_SEND_NIGHT 0    // Sendebeschränkung 1 -> aktiv, 0 -> nicht aktiv
#define DO_NOT_SEND_BEGIN 20   // Uhrzeit Beginn Sendebeschränkung Wertebereich 18 - max 23 Uhr!!!
// Ende der Sendebeschränkung ist voreingestellt mit #define SEND_HOUR 5  auf 5 Uhr
// Achtung: automatische Umschaltung der serverseitig eingestellte Mess-/Sendeintervalle erfolgt nur wenn
//  zum Zeitpunkt des Umstellen Daten erfolgreich gesendet wurden
// Beispiel: serverseitige Einstellung zur Umstellung des Messintervalls 20 Uhr und DO_NOT_SEND_BEGIN 22
//           DO_NOT_SEND_BEGIN 20 und serverseitige Einstellung zur Umstellung des Messintervalls 21 Uhr funktioniert nicht.
// Hinweis: Wenn das EE-Prom mit Datensätzen gefüllt ist, wird immer ein Sendeversuch unternommen
/****************************************************************/


/****************************************************************/
// Allgemeine Konfiguration
/****************************************************************/
#define AlternativIntervallMinuten  120  // Weckinterval, wenn VAlternativ erreicht = Akku fast leer


// Wartezeit ohne Messungen wenn Schalter Arbeiten am Bienenvolk dauernd aktiv
// Zeit in Minuten, 5 Minuten Schritte
#define USER_INT_TM      30

/****************************************************************/


/****************************************************************/
// Konfiguration Datenablage EEProm
// Anpassungen nur mit Vorsicht.
/****************************************************************/
#define EEProm_Size 4096       // 4kByte EE-Prom    32kbit (z.B. DS3231 Modul)
//#define EEProm_Size 8192     // 8kByte EE-Prom    64kbit
//#define EEProm_Size 32768    // 32kByte EE-Prom  256kbit

// Erläuterungen:
//                  Datensatzgröße    EE-Prom 4kB  8kB  32kByte
//                                    max. Anzahl gespeicherte Datensätze      
// beelogger Single  96 Byte                 42    84   254
// beelogger DUO    120 Byte                 34    68   254
// beelogger Quad   152 Byte                 26    52   208

// mit 4kB EE-Prom
// mögliche Überbrückungszeit ohne Senden bei 5 Minuten Messzyklus
//                                          ca. Stunden   
// beelogger Single                         3,5     7    20
// beelogger DUO                            2,5     5    20
// beelogger Quad                            2      4    17 

// mögliche Überbrückungszeit ohne Senden bei 15 Minuten Messzyklus
//                                          ca. Stunden   
// beelogger Single                         10     20    60
// beelogger DUO                             8     16    60
// beelogger Quad                            6     12    50 


/****************************************************************/
/***************    ENDE Konfiguration     **********************/
/****************************************************************/
