//----------------------------------------------------------------
// DS3231
//----------------------------------------------------------------

#define DS3231_ADDRESS 0x68
#define DS3231_Stat_REG 0x0F


void DS3231_test()
{
  Serial.println("DS3231");

  rtc.begin();
  Serial.println(F(" reset alarms"));
  rtc.clearINTStatus();

  Serial.print(F(" temperature from DS3231: "));
  TempSys = rtc.getTemperature();
  Serial.print(TempSys, 1);
  Serial.println(F("°C"));

  DateTime pc_tim = DateTime(__DATE__, __TIME__);
  DateTime aktuell = rtc.now();
  long l_pczeit = pc_tim.get();
  long l_zeit = aktuell.get();
  if (l_pczeit > l_zeit) {
    Serial.println(F(" setting time in DS3231"));
    rtc.setDateTime(l_pczeit);
  }

  display_time();
  Wire.end();
  Serial.println(" ");
}

/**
  @brief Funktion display_time() Anzeige Uhrzeit
  @param  none
  @return  none
*/
void  display_time() {
  DateTime jetzt = rtc.now();
  if (jetzt.year() > 2100) {
    Serial.println(F("\nDS3231?"));
  }
  else {
    Serial.print(F(" time in DS3231: "));
    Serial.print(jetzt.date());
    Serial.print('.');
    Serial.print(jetzt.month());
    Serial.print('.');
    Serial.print(jetzt.year());
    uint8_t h = jetzt.hour();
    if (h < 10) {
      Serial.print("  ");
    }
    else Serial.print(" ");
    Serial.print(h);
    Serial.print(':');
    if (jetzt.minute() < 10) Serial.print("0");
    Serial.print(jetzt.minute());
    Serial.print(':');
    if (jetzt.second() < 10) Serial.print("0");
    Serial.print(jetzt.second());
  }
  Serial.println(" ");
  Serial.flush();
}
