//--------------------------------------------------------------
// Sketch  Konfiguration
//--------------------------------------------------------------

#define _BME680_            0    // 0 = ohne,  1= mit
#define _BMP280_            0    // 0 = ohne,  1= mit

#define Power_off_at_End    0    // 0 = aus (=LowPower),   1= Power an  


// SD-card test limits testing of some sensors because of using programm space
#define Test_SD_Card        0    // 0 = ohne,  1= test ;  DS3231 needed

/****************************************************************/
// Konfiguration One-Wire-Bus für DS18B20
// Regenmesser verwendet Pin 3, dann DS18B20 auf Pin 6
/****************************************************************/
#define One_Wire_Bus        3    // OneWire / DS18B20 an Pin D3

/****************************************************************/
// Konfiguration DHT21 / DHT22 - Temperatur und Luftfeuchte
// mit Regenmesser verwendet DS18B20 Pin 6
/****************************************************************/
uint8_t DHT_Pin[2] = {5, 6};   // DHT 22 Nummer 1 an Pin D5;  DHT 22 Nummer 2 an Pin D6

/****************************************************************/
// Konfiguration HX711 SCK /Data
/****************************************************************/
uint8_t HX711_SCK[2]   =  { A1, 10};    // HX711 S-Clock
uint8_t HX711_DT[2]    =  { A0, 11};    // HX711 Data


/****************************************************************/
// Pins Spannungen messen
/****************************************************************/
#define Batterie_messen    A6
#define Solarzelle_messen  A7
/****************************************************************/
// Teilerwerte für die Spannungsmessung
/****************************************************************/
const long Kalib_Spannung = 4000;
const long Kalib_Bitwert  = 1500;
/****************************************************************/

//--------------------------------------------------------------
// Ende Konfiguration
//--------------------------------------------------------------

/****************************************************************/
// Serielle Schnittstelle
/****************************************************************/
#define USB_RX      0          // Pin 0 RX-USB
#define USB_TX      1          // Pin 1 TX-USB
/****************************************************************/

/****************************************************************/
// Interrupt
/****************************************************************/
#define DS3231_Interrupt_Pin 2
/****************************************************************/

/****************************************************************/
// Power on/off
/****************************************************************/
#define Power_Pin 4
/****************************************************************/

/****************************************************************/
// I2C
/****************************************************************/
#define SDA   A4      // I2C Daten
#define SCL   A5      // I2C Clock
/****************************************************************/

#define GSM_Power_Pin      A2

#define SD_LED    7   // LED

#define x_RX      8
#define x_TX      9

#define SD_CS    10   // SD Card Chip Select
#define SD_MOSI  11   // SD Card MOSI
#define SD_MISO  12   // SD Card MISO
#define SD_CLK   13   // SD Card Clock

const float No_Value = -1.0;
const float No_Val = 99.9;
char s_temp[] = " temperature [C]: ";
char s_hum[] = " humidity [%RH]: ";
char s_press[] = " air pressure [HPa]: ";
