/*
   (C) 2022 R.Schick / Thorsten Gurzan - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de
// Version 2022    beelogger Multi mit EE-Prom, bis zu sechs Waagen
// 18.09.2022 fix HX711 and other issue
// 15.04.2023 BME280-/DHT beelogger-libs

#include "WLAN_MULTI_config.h"     // Konfiguration und Kalibrierung eintragen
#include "beelogger_config_EV.h"


char ID_ID[] = "WLAN_M_EV_230415";  //nur Grossbuchstaben,Zahlen, keine Blank


//----------------------------------------------------------------
// Variablen
//----------------------------------------------------------------
const float No_Val = 99.9f;  // Vorbelegung, Wert nicht gemessen
const float No_Value = -1.0f;  // Vorbelegung, Wert nicht gemessen

//                              DHT1,   DHT2,   Si7021, SHT31a, SHT31b, BMEa,   BMEb,  DS18B20a,b,      c,      d,
float SensorTemp[13] = {No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val};

//                                  DHT1,      DHT2,     Si7021,   SHT31a,   SHT31b,   BMEa,     BMEb    , leer    , leer    , leer    , leer
float SensorFeuchte[12] = {No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value};

//              DS3231Temp, Luftdruck, ZählerRegen
float Aux[3] = {No_Value, No_Value, No_Value};

float Licht = No_Value;
float DS_Temp = No_Val;

float Gewicht[6] = {No_Value, No_Value, No_Value, No_Value, No_Value, No_Value};
float LetztesGewicht[6] = {No_Value, No_Value, No_Value, No_Value, No_Value, No_Value};

float Batteriespannung = No_Value;
float Solarspannung = No_Value;
float Service = 0.0;


// Variablen permanente Daten
uint32_t time_on = 0;
uint8_t WeckIntervallMinuten = WeckIntervall_default;
uint8_t report_info = 0;           // 0 = time-On, 1 = Pegel
uint8_t my_counter = 0;            // Anzahl Messungen
uint8_t nr_to_measure = 1;         // Senden bei Start
uint8_t next_send_hour = 0;        //
uint8_t send_cycle = 1;            // Normaler Sendezyklus
uint8_t snd_dly  = 0;              // Send delay
uint8_t stuck_switch = 0;    // Service Switch permanent on
uint8_t s_alarm = 0;         // Schwarmalarm

// Interrupt Variablen
volatile uint8_t ok_sleep = true;
char DatenString[_Daten_Satz_Len];  // Datenbuffer
//----------------------------------------------------------------

void setup() {

  Serial.begin(Serial_Baudrate);
  Serial.println(ID_ID);
  Serial.flush();

  //----------------------------------------------------------------
  //  System on
  //----------------------------------------------------------------
#if defined (__AVR_ATmega328P__)
    Serial.println("ATmega328 Mode");
#endif

  stop_DFUe_device();

  Spannungen_messen();
  while (Batteriespannung < VMinimum) {
    RTCAVRZero.begin(false);
    delay(100);
    RTCAVRZero.enableAlarm(8, true);
    LowPower.standby();
    RTCAVRZero.disableAlarm();
    Spannungen_messen();
  }

  digitalWrite(Power_Pin, HIGH);     // Power On
  pinMode(Power_Pin, OUTPUT);
  digitalWrite(Power_Pin, HIGH);     // Power On
  calldelay(5);
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  // Setup Gewicht
  //----------------------------------------------------------------
  Sensor_Gewicht(true);   // Startwert Gewicht holen
  //----------------------------------------------------------------


  //----------------------------------------------------------------
  //  Check EE-Prom
  //----------------------------------------------------------------
  Serial.print(F("EE-"));
  /*
    if (my_EEPROM.isPresent()) {
    Serial.print(F("fehlt"));
    Serial.flush();
    digitalWrite(Power_Pin, LOW);
    LowPower.powerDown(SLEEP_FOREVER, ADC_OFF, BOD_OFF);
    }
    else {
  */
  Serial.print(F("in use: "));
  Serial.println((_Num_Measured + _Num_Retry) * _Daten_Satz_Len);
  Serial.println(sizeof(DatenString));
  Serial.println(" ");
  Serial.flush();
  //}
  //----------------------------------------------------------------


  //----------------------------------------------------------------
  //  Sleep Mode Interrupt
  //----------------------------------------------------------------
  pinMode(DS3231_Interrupt_Pin, INPUT_PULLUP);
  calldelay(5);
  //----------------------------------------------------------------

  Serial.flush();
  Serial.end();
  Serial_rxtx_off();
}

//#########################################################
void loop() {
  uint8_t s_alarm;
  uint8_t ureq;
  debugbegin(Serial_Baudrate);
  debugprintlnF("\nLoop");

  System_On();
  display_time();
  debugflush();

  Spannungen_messen();
  if (Batteriespannung > VMinimum) {
    ureq = User_Int();
    if (ureq) {  // 1 = Service Switch not set
      Sensor_Temp_Zelle(0);
      Sensor_DHT();
      Sensor_DS18B20();
      Sensor_Si7021();
      Sensor_SHT31();
      Sensor_BME280();
      Sensor_Licht();
      Sensor_Temp_Zelle(1);
      s_alarm = Sensor_Gewicht(0);
      sw_alarm(s_alarm);
    }
    else {
      Sensor_Gewicht(1);
    }
    Daten_Senden(ureq);
    sw_alarm_int();
  }
  Alarm_konfigurieren();
  print_info();
  debugflush();
  debugend();
  Serial_rxtx_off();

  System_Off();
  SleepNow();
}
//#########################################################
