//04.04.2020 aktuelle Zeit holen vor Alarm setzen
//25.04.2020 User Service
//03.05.2020 User Service Schalter
//14.07.2020 Servicewert minimal 1
//13.08.2020 clear rtc-int in User int
//04.12.2020 anzeige uhrzeit
//08.01.2021 Debug Info
//22.01.2021 Service Schalter
//28.01.2021 Intervallcheck
//05.03.2021 Servicezeit, RTC, Interrupt-call
// 30.04.2021 Status Reporting
// 14.10.2021 Alarm calculation
// 14.11.2021 service switch handling
// 18.11.2021 stray signal at D2 handling
// 24.12.2021 signal switch status
// 16.05.2022 DHT Pinmode
// 22.05.2022 swarm alarm
// 10.06.2022 swarm alarm intervall
// 13.07.2022 Service Switch handling
// 18.09.2022 fix HX711 and other issue

#include "Wire.h"

/**
  @brief Funktion sw_alarm
  forciere Data send, when swarm alarm detected, send data at two following intervalls

  @param alarm swarmalarm
  @return  none
*/
void sw_alarm( uint8_t alarm) {
#if SCHWARM_ALARM
  if (stuck_switch != 0) {
    s_alarm = 0; // reset alarm when user switch
  }
  else {
    if (s_alarm > 0) {    // swarm alarm is aktive
      debugprintF("Alarm."); debugflush();
      s_alarm --;
      nr_to_measure = 1;  //force send
    }
    else {
      if (alarm) {  // alarm, force send, at least 10 min Intervall
        debugprintF("Alarm!"); debugflush();
        nr_to_measure = 1;  //force send
        s_alarm = 2;        // two sends  (max three)
      }
    }
  }
#endif
}
// swarm alarm interval
void sw_alarm_int() {
  if (s_alarm) {
    if (WeckIntervallMinuten > 10)  WeckIntervallMinuten = 10;
  }
}


/**
  @brief Funktion Spannungen_messen(), speichert Messwerte in globalen Variablen
  @param none
  @return none
*/

void Spannungen_messen() {
  Batteriespannung = Messe_Spannung(Batterie_messen);

  debugprintF("Bat. [V] ");
  debugprintln(Batteriespannung);
  debugflush();

  if (Batteriespannung > VMinimum) {
    Solarspannung = Messe_Spannung(Solarzelle_messen);

    debugprintF("Sol. [V] ");
    debugprintln(Solarspannung);
    debugflush();

  }
}

/**
  @brief Funktion Messe_Spannung(), verwendet globale Kalibrierdaten
  @param ATmega Pin
  @return float Messwert
*/
float Messe_Spannung (uint8_t Pin) {
  int Messung_Spannung;
  float Spannung;
  Messung_Spannung = analogRead(Pin);
  Messung_Spannung = 0;
  for (uint8_t j = 0 ; j < 16; j++) {
    Messung_Spannung += analogRead(Pin);
  }
  Messung_Spannung = Messung_Spannung >> 2;
  Spannung = (float)map(Messung_Spannung, 0, Kalib_Bitwert, 0, Kalib_Spannung) / 1000.0;
  return (Spannung);
}


/**
  @brief Funktion Time_from_RTC(), holt Zeitstempel von RTC
  @param none
  @return Zeit im uint32_t Format = Unixtime
*/
uint32_t Time_from_RTC() {
  DateTime aktuell = rtc.now();
  uint32_t l_tm = aktuell.get();
  return (l_tm);
}


/**
  @brief Funktion Alarm_konfigurieren()

  berechnet Einschaltzeitdauer des Systems
  berechnet nächste Alarmzeit für DS3231,
  setzt Alarmzeit in DS3231

  @param none
  @return none
*/

void Alarm_konfigurieren() {

  uint32_t l_tm = Time_from_RTC();
  uint32_t tt = l_tm - time_on;      // calc time_on
  if (tt == 0) tt = 1;               // minimum 1 -> not a reset
  if (tt > 999) tt = 1;              //
  time_on = tt;                      // store total TimeOn

  long IntervallMinuten = WeckIntervallMinuten;

  if (Batteriespannung < VAlternativ) {
											
		  
    IntervallMinuten = AlternativIntervallMinuten;
    WeckIntervallMinuten = 45;
  }

  // Check Intervall
  if (IntervallMinuten < 5)  IntervallMinuten = 15;
  // next wakeup time
  l_tm = l_tm  + IntervallMinuten * 60; // xx minutes later
  l_tm = l_tm - l_tm % 300;             // adjust to five minute

  DateTime aktuell ((long)l_tm);

  rtc.enableInterrupts(aktuell.hour(), aktuell.minute(), 0); //interrupt at  hour, minute, second

  debugprintF("wakeup ");
  debugprint(aktuell.hour());
  debugprint(":");
  debugprintln(aktuell.minute());
  debugflush();
}


/**
  @brief Funktion Sleep_now()

  wenn Service Schalter gesetzt,
   dann wird ein ca. 5 Minuten Schlafintervall mit 8 Sekunden Schritten durchgeführt
   dies ignoriert auch Interrupts des DS3231 oder defekte DS3231 mit Daueralarm
  ansonsten wird
   der Interrupt an Pin D2 aktiviert,
   und wenn kein Interrupt erfolgt ist, der ATmega in dauerhaften LowPower versetzt

  @param none
  @return none
*/
void SleepNow() {
  calldelay(2000);

  if (req_svc_sw() == false) { // switch on, warte 5 Minuten
    uint8_t i, k;
    k = 1;  // default wait 5min
    if (stuck_switch  >= (USER_INT_TM / INTERVAL_STUCK_SWITCH)) {
      k = (WeckIntervallMinuten / 5); // Intervall in  5min step
    }
    RTCAVRZero.begin(false);
    delay(100);
    RTCAVRZero.enableAlarm(8, true); // multiple alarm
    do {
      i = 36; // 36 = 5 Minuten Ruhe
      do {
        LowPower.standby();
        calldelay(50);  // debounce switch at interrupt pin.
        i--;
      } while (i);
      k--;
    } while ((k) && (req_svc_sw() == 0)); //
    RTCAVRZero.disableAlarm();

  }  else { // wait on DS3231 alarm or service switch
    stuck_switch = 0;
    ok_sleep = true;
    attachInterrupt(digitalPinToInterrupt(DS3231_Interrupt_Pin), WakeUp, LOW);  // D2 = Interrupt
    //calldelay(1);
    blink_LED(2, 100);  // signal
    while (ok_sleep) {
      const uint8_t unusedPins[] = {  // not D2 = INT;
        //RX,TX, D7, D10  ...   D13,    A2, A3,  SCA/SCL?
        0, 1,     7,  10, 11, 12, 13,   16, 17,  18, 19, 20, 21, 22, 23, 24, 25
      };

      /* Ensure unused pins are not floating */
      for (uint8_t index = 0; index < sizeof(unusedPins); index++)
      {
        pinMode(unusedPins[index], INPUT_PULLUP);
        LowPower.disablePinISC(unusedPins[index]);
      }
      LowPower.powerDown();
      calldelay(30);  // debounce switch at interrupt pin.
    }

    const uint8_t UsedPins[] = {  // pins to recover
      // D10,D11, A2, A3,  SCA/SCL?
      10, 11, 16, 17,  18, 19, 20, 21, 22, 23, 24, 25
    };
    /* Recover Pin from Disabling ISR */
    for (uint8_t index = 0; index < sizeof(UsedPins); index++)
    {
      LowPower.enablePinISC(UsedPins[index]);
    }
  }
}

/**
  @brief Funktion WakeUp,  Interrupt-Routine zu attachInterrupt

  setzt globale Variable zurück,
  deaktiviert interrupt

  @param none
  @return none
*/
void WakeUp() {
  ok_sleep = false;
  detachInterrupt(digitalPinToInterrupt(DS3231_Interrupt_Pin));
}


/**
  @brief Funktion System_Off

  Schalte Spannung für Peripherie aus,
  rücksetzen CPU Bits für I2C ( see gammon.com.au )
  setzte alle benutzten Pins inaktiv

  @param none
  @return none
*/
void System_Off() {
  hx711_SCK_Low();    // code order, important!

  digitalWrite(Power_Pin, LOW);
  calldelay(5);
  Wire.end();
  pinMode(PIN_WIRE_SDA, INPUT);
  pinMode(PIN_WIRE_SCL, INPUT);

}


/**
  @brief Funktion System_On

  Schalte Spannung für Peripherie ein,
  aktiviere relevante Pins
  initialisiere Uhr, DS3231
  Einschaltzeitdauer sichern und Startzeit setzen

  @param none
  @return none
*/
void System_On() {
  hx711_start();
  pinMode(Power_Pin, OUTPUT);
  digitalWrite(Power_Pin, HIGH);
  calldelay(100);             // vcc stable
  pinMode(ONE_WIRE_BUS, OUTPUT);

  rtc.begin();
  rtc.clearINTStatus();
  calldelay(5);                 // wait clear Int

  Service = (float)time_on; //saving last TimeOn in Service
  time_on = Time_from_RTC();    // Set time_on
}


/**
  @brief Funktion User_Int

  teste ob Schalter an D2 hat Interrupt gesetzt hat
  teste ob Servicezyklus abgelaufen
  forciere Daten senden, wenn Service erstmalig aktiv

  @param none
  @return  1 wenn Service inaktiv, 0 wenn Service aktiv
*/
uint8_t User_Int() {             // User forced Interrupt ?
  uint8_t ret_val = 1;

#if (USER_INT_TM > 150)  // Limit Service switch time, important!
#undef USER_INT_TM
#define USER_INT_TM 150
#warning " USER_INT_TM  set to  150 minutes !"
#endif

  if (req_svc_sw() == false) {      // switch on?
    blink_LED(1, 500);  // signal we've noticed
    if (stuck_switch == 0) {                  // first time only
      calldelay(2000);
      if (req_svc_sw() == false) {  // still on?
        // User Service, force send data
        blink_LED(4, 200);  // signal we've noticed
        Service = 99.0;                       // report User Wakeup to server
        nr_to_measure = 1;                    // force send
        stuck_switch = 1;
        debugprintln ("User!");
      }
    }
    else {
      // return "switch is set", when still on and time is not up
      if (stuck_switch  < (USER_INT_TM / INTERVAL_STUCK_SWITCH) ) {
        ret_val = 0;
        stuck_switch++; // only increment within predefined period
      }
    }
  }
  else {
    stuck_switch = 0;
  }

  return (ret_val);
}


/**
  @brief Funktion blink_LED

  LED an Pin 13 blinken

  @param  Anzahl, Zeitdauer an/aus
  @return  none
*/
void blink_LED(uint8_t nmr, uint16_t bl_tm) {
  pinMode(13, OUTPUT);
  for (int i = 0; i < nmr; i++) {
    digitalWrite(13, LOW);  calldelay(bl_tm); // LED an
    digitalWrite(13, HIGH);  calldelay(bl_tm);
  }
  pinMode(13, INPUT);
}


/**
  @brief Funktion req_svc_sw

  auslesen Status des Interrupt Pin D2 für Service
  Achtung: auch der DS3231 kann den Pin dauerhaft setzen

  @param  none
  @return  Status Pin: 0 oder 1
*/
uint8_t req_svc_sw() {
  return (digitalRead(DS3231_Interrupt_Pin));
}


/**
  @brief Funktion display_time() Anzeige Uhrzeit als Debug Info
  @param  none
  @return  none
*/
void  display_time() {
#if  myDEBUG
  DateTime jetzt = rtc.now();
  if (jetzt.year() > 2100) {
    debugprintlnF("\nDS3231?");
  }
  else {
    debugprint(jetzt.date());
    debugprint('.');
    debugprint(jetzt.month());
    debugprint('.');
    debugprint(jetzt.year());
    uint8_t h = jetzt.hour();
    if (h < 10) {
      debugprint("  ");
    }
    else debugprint(" ");
    debugprint(h);
    debugprint(':');
    if (jetzt.minute() < 10) debugprint("0");
    debugprint(jetzt.minute());
    debugprint(':');
    if (jetzt.second() < 10) debugprint("0");
    debugprint(jetzt.second());
  }
  debugprintln(" ");
  debugflush();
#endif
}


/**
  @brief Funktion print_info()  debug output sketch status info
  @param  none
  @return  none
*/
void print_info() {
  debugprintF("Nr:");
  debugprint(my_counter);
  debugprintF("  senden: ");
  debugprint(next_send_hour);
  debugprintF("h  send-cyc: ");
  debugprint(send_cycle);
  debugprintF("h  Interval: ");
  debugprint(WeckIntervallMinuten);
  debugprintF("min  t-on: ");
  debugprint(time_on);
  debugprintF("s  sw: ");
  debugprint(stuck_switch);
  debugprintF("  report:");
  debugprint(report_info);
  debugprintF("  snd_dly:");
  debugprintln(snd_dly);
  debugflush();
}
