/*
   (C) 2020 R.Schick - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de


char ID[] = "beelogger Every Test RXTX 25.01.2021";

#include <SoftwareSerial.h>

SoftwareSerial mySerial(8, 9); // RX,TX


#define Test_Baudrate 9600    //  Baudrate für die serielle Kommunikation/Monitor

void setup() {
#define ESP_RESET A2
#define POWER A4

  pinMode(ESP_RESET , OUTPUT);
  digitalWrite(ESP_RESET , HIGH);

  pinMode(POWER, OUTPUT);
  digitalWrite(POWER, HIGH);

  my_blink(3,500);

  mySerial.begin(Test_Baudrate);
  while (!mySerial) {};

  delay(1000);

  Serial.begin(Test_Baudrate);
  while (!Serial) {};
  Serial.println(ID);
  Serial.println("");
  Serial.println("  entferne SIM800 bzw. ESP8266, ");
  Serial.println("  verbinde RX mit TX an der Buchsenleiste SIM800 oder ESP8266 ");
  Serial.println("");
  Serial.println(" Testdaten am Monitor eingeben: ");
  Serial.println("   diese werden im Monitor angezeigt. ");
  Serial.flush();
}

char incomingByte; // for incoming serial data
char c;

void loop() {
  if (mySerial.available())
    Serial.write(mySerial.read());
  if (Serial.available()) {
    //Serial.write(Serial.read());
    mySerial.write(Serial.read());
  }
}

void my_blink(uint8_t nmr, uint16_t howlong) {
  for (uint8_t x = 0; x < nmr; x++) {
    pinMode(LED_BUILTIN, OUTPUT);
    digitalWrite(LED_BUILTIN, HIGH);   // turn the LED on (HIGH is the voltage level)
    delay(howlong);                       // wait for a second
    digitalWrite(LED_BUILTIN, LOW);    // turn the LED off by making the voltage LOW
    delay(howlong);                       // wait for a second
  }
}
