/*
   (C) 2022 R.Schick - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de
// Version 2022

#include "System_Check_config.h"
#include "Sodaq_DS3231.h"

#if defined(__AVR_ATmega4809__)
#include <RocketScream_LowPowerAVRZero.h>
#include <RocketScream_RTCAVRZero.h>
#else
#include <LowPower.h>
#endif

DateTime aktuell;
uint8_t i2c_device[16] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
uint8_t System_with_DS3231 = 0;
float TempSys = -99.9;
char DatenString[70];

//--------------------------------------------------------------
void setup(void) {

  Serial.begin(9600);
  while (!Serial) {};
  delay(100);
  Serial.println(F("\n\nSystem Check 15.04.2023\n\r"));

#if defined(__AVR_ATmega4809__)
  Serial.println("\nbeelogger-Universal,  Arduino Nano Every\n");
#else
#if defined(ARDUINO_AVR_NANO)
  Serial.println("\nbeelogger-Universal,  Arduino Nano\n");
#else
  Serial.println("\nbeelogger, Arduino Pro-Mini\n");
#endif
#endif

  Serial.print(F(" Pin "));
  if (GSM_Power_Pin > 13) {
    Serial.print("A");    Serial.print(GSM_Power_Pin - 14);
  }
  else {
    Serial.print("D"); Serial.print(GSM_Power_Pin);
  }
  Serial.println(F(" low"));
  digitalWrite(GSM_Power_Pin, LOW);  // GSM off
  pinMode(GSM_Power_Pin, OUTPUT);
  delay(5);

  Serial.print(F(" Power-On using Pin: "));
  if (Power_Pin > 13) {
    Serial.print("A"); Serial.println(Power_Pin - 14);
  }
  else {
    Serial.print("D"); Serial.println(Power_Pin);
  }
  Serial.println(" ");
  pinMode(Power_Pin, OUTPUT);
  digitalWrite(Power_Pin, HIGH);
  delay(100);
  Serial.flush();

  Sensor_HX711();
  Sensor_DHT();

  discoverOneWireDevices();

  discoverI2CDevices();
  test_i2c_devices();

#if Test_SD_Card
  if (System_with_DS3231)
  {
    Daten_auf_SD_speichern();
  }
  else {
    Serial.println(F(" ohne DS3231, kein SD-Kartentest"));
  }
#endif

  Serial.println(" ");
  Serial.flush();
  if (Power_off_at_End == 0) {
    Serial.println(F("Low-Power activ."));
  }
  Serial.println(F("Sleep forever! "));
  Serial.flush();
  Serial.end();
}
//--------------------------------------------------------------


//#################################################
void loop(void) {
  // nothing to see here
  if (Power_off_at_End == 0) {
    digitalWrite(x_TX, LOW);
    pinMode(x_TX, INPUT);
#if defined(ARDUINO_AVR_ARCH)
    TWCR &= ~(bit(TWEN) | bit(TWIE) | bit(TWEA));
#endif
    digitalWrite (A4, LOW);
    digitalWrite (A5, LOW);
    digitalWrite(HX711_SCK[0], LOW);
    digitalWrite(HX711_SCK[1], LOW);
    digitalWrite(Power_Pin, LOW);
    delay(300);
  }
#if defined(__AVR_ATmega4809__)
  LowPower.powerDown();
#else
  LowPower.powerDown(SLEEP_FOREVER, ADC_OFF, BOD_OFF);
#endif
}
//#################################################


float Messe_Spannung (uint8_t Pin) {
  int Messung_Spannung;
  float Spannung;
  Messung_Spannung = analogRead(Pin);
  Messung_Spannung = 0;
  for (uint8_t j = 0 ; j < 16; j++) {
    Messung_Spannung += analogRead(Pin);
  }
  Messung_Spannung = Messung_Spannung >> 2;
  Spannung = (float)map(Messung_Spannung, 0, Kalib_Bitwert, 0, Kalib_Spannung) / 1000.0;
  return (Spannung);
}
