//----------------------------------------------------------------
// DS18B20 OneWire
//----------------------------------------------------------------
#include <OneWire.h>
#include <DallasTemperature.h>
#define Sensor_Aufloesung 12

void discoverOneWireDevices(void) {

  byte i;
  byte addr[8];

  OneWire  ds(One_Wire_Bus);  // Connect your 1-wire device to pin #

  Serial.println(F("Looking for 1-Wire devices... (i.e. DS18B20)"));
  Serial.print(F("at Pin: D"));
  Serial.println(One_Wire_Bus);
  Serial.flush();
  while (ds.search(addr)) {
    Serial.print(F("\n\rFound device with address:\n\r"));
    Serial.flush();
    for ( i = 0; i < 8; i++) {
      Serial.print("0x");
      if (addr[i] < 16) {
        Serial.print('0');
      }
      Serial.print(addr[i], HEX);
      if (i < 7) {
        Serial.print(", ");
      }
    }
    if ( OneWire::crc8( addr, 7) != addr[7]) {
      Serial.print(F("CRC is not valid!\n"));
      return;
    }
  }
  Serial.println(F("\n\rOne-Wire scan done.\r\n"));
  Serial.flush();
  ds.reset_search();


  float Temperatur_DS = 0.0;
  Serial.println(F("DS18B20 "));
  Serial.flush();

  // Pass our oneWire reference to Dallas Temperature.
  DallasTemperature ow_sensors(&ds);

  ow_sensors.begin();
  delay(500);

  ow_sensors.requestTemperatures();
  delay(500); // additional wait on sensor ready
  ow_sensors.requestTemperatures();

  uint8_t numberOfDevices = ow_sensors.getDeviceCount();

  for (uint8_t i = 0 ; i < numberOfDevices; i++) {
    Temperatur_DS = ow_sensors.getTempCByIndex(i);

    Serial.print(F("\n\rSensor "));
    Serial.print(i + 1);
    Serial.print(": ");
    Serial.print(Temperatur_DS);
    Serial.println(" °C");
  }
  
  Serial.println(" ");
  Serial.flush();
}
//--------------------------------------------------------------
