//09.03.2020
//02.04.2020  HEXA, 6 Waagen
//25.04.2020  user_interrupt handling
//07.08.2020  EE-Prom Checksumme
//18.08.2020  Sendezeit bei Netzausfall angepasst
//25.10.2020  Temperatur Waegezelle
//04.12.2020  Parameter mit config.h einstellbar
//08.01.2021  Debug Info
//28.01.2021  Intervallcheck
//05.03.2021  RTC, calc_send_hour
//19.03.2021  Zuordnung Aux[0]
// 30.04.2021 Status Reporting
// 03.05.2021 EE-Prom-only
// 04.05.2021 "_" im Datenstring ergänzt
// 05.05.2021 Senden deaktivierbar via Konfiguration
// 25.05.2021 Sendesynczeit verschiebbar
// 26.06.2021 Uhrzeit validieren
// 14.10.2021 Send delay
// 14.11.2021 service switch handling



/**
  @brief Funktion Daten_Senden 
  Daten in EE-Prom ablegen
  wenn Anzahl Messungen oder SendeZyklus erreicht: Senden
  komprimiert Daten wenn Sendefehler und EE-Prom voll
  
  @param  store=1: Daten abspeichern, verwendet bei aktivem Service
         globale Variablen
  @return  none, setzt globale Variablen
*/
void Daten_Senden(uint8_t store) {

  uint8_t time_to_send = 0;
  uint8_t cur_hour;
  // Speichere in AT24Cxx
  uint8_t x, sum = 0;  // Checksum

  DateTime  aktuell = rtc.now();
  cur_hour = aktuell.hour();

  if ((cur_hour < 24) && store) { // validate hour
    DatenString_erstellen();
    debugprintln(DatenString);

    // EE-Prom Checksum
    for (x = 0; x < strlen(DatenString); x++) {
      sum += DatenString[x];
    }
    DatenString[_Daten_Satz_Len - 1] = sum;
    my_EEPROM.WriteMem(my_counter * _Daten_Satz_Len, DatenString, _Daten_Satz_Len);
    my_counter++;

  }

  if ((next_send_hour > SEND_HOUR) || (cur_hour <= SEND_HOUR)) { // schedule past 6 or time before 6
    if (cur_hour >= next_send_hour) {            // current hour is send-time
      time_to_send = 1;                          // send
    }
  }
  if ((next_send_hour == SEND_HOUR) && (cur_hour > (SEND_HOUR - 1)) && (cur_hour < 12)) { // schedule between 6 to 11 hour
    time_to_send = 1;                         // force send
  }


  if (time_to_send) { // delay sending data within the hour
    if (snd_dly == 0) {                   // no delay pending
      snd_dly = (uint8_t) (analogRead(Batterie_messen) % 6);
      if (WeckIntervallMinuten <= 10 ) {
        if (snd_dly > 5) snd_dly = 5;    // send max at xx:50
      }
      else if (WeckIntervallMinuten <= 15) {
        if (snd_dly > 3) snd_dly = 3;    // send max at xx:45
      }
      else if (WeckIntervallMinuten <= 30 ) {
        snd_dly = 1;                     // send max at xx:30
      }
      else snd_dly = 0;                  // send immediate
    }
    else {
      snd_dly --;            // count down
    }
    if (snd_dly > 0 ) {
      time_to_send = 0;
    }
  }


  //* do not send at night time
#if DO_NOT_SEND_AT_NIGHT
#if (DO_NOT_SEND_BEGIN > 23)
#undef DO_NOT_SEND_BEGIN
#define DO_NOT_SEND_BEGIN 23
#warning " DO_NOT_SEND_BEGIN set to  23 !"
#endif
#if (DO_NOT_SEND_BEGIN < 18)
#undef DO_NOT_SEND_BEGIN
#define DO_NOT_SEND_BEGIN 23
#warning " DO_NOT_SEND_BEGIN set to  23 !"
#endif
  if ((cur_hour >= DO_NOT_SEND_BEGIN ) || ( cur_hour < SEND_HOUR)) {
    time_to_send = 0;
    calc_send_hour(cur_hour, 0);
  }
#endif

  if ((my_counter >= nr_to_measure) ||    //  number of measurements reached
      ( time_to_send )) {                 //  it's time to send data
    if (Send_Data(my_counter)) {

      my_counter = 0;
      aktuell = rtc.now();                // we may have a new time from server
      cur_hour = aktuell.hour();
      calc_send_hour(cur_hour, 0);

    }
    else {  // error sending data
      debugprintlnF("error");
      calc_send_hour(cur_hour, 1);
      if (my_counter >= (_Num_Measured + _Num_Retry)) { // additional retries ?
        /*
          debugprintln("\nCheck:   ");
          debugflush();
          for (uint8_t a = 0; a < my_counter; a++) {
          my_EEPROM.ReadMem(a * _Daten_Satz_Len, DatenString, _Daten_Satz_Len);
          debugprintln(DatenString);
          debugflush();
          }
        */
        uint8_t x = my_counter / 2;
        for (uint8_t i = 0; i < x; i++) {  // compress data, elimiate every second measuremtn
          my_EEPROM.ReadMem(i * 2 * _Daten_Satz_Len, DatenString, _Daten_Satz_Len);
          my_EEPROM.WriteMem(i * _Daten_Satz_Len, DatenString, _Daten_Satz_Len);
        }
        /*
          debugprintln("compressed:   ");
          for (uint8_t b = 0; b < x; b++) {
            my_EEPROM.ReadMem(b * _Daten_Satz_Len, DatenString, _Daten_Satz_Len);
            debugprintln(DatenString);
            debugflush();
          }
          debugprintln("   ");
        */
        my_counter = x; // set counter
      }
    }

    nr_to_measure = _Num_Measured;  // set to normal number to measure
  } // if counter
    
  // Zeiger für Ungesendete Datensätze wird geschrieben
  my_EEPROM.WriteMem(EEProm_Size - 1, my_counter);
}


/**
  @brief Funktion calc_send_hour()
  calculate next time to send data
  @param  c_hour: aktuelle Stunde, failed: Fehler beim Daten senden
         globale Variablen
  @return  none, setzt globale Variablen
*/
void calc_send_hour(uint8_t c_hour, uint8_t failed ) {
  uint8_t s_cycle;

#if (SEND_CYC_RTY < 1)
#undef SEND_CYC_RTY
#define SEND_CYC_RTY 2
#endif
#if (LONG_CYCLE < 1)
#undef LONG_CYCLE
#define LONG_CYCLE 2
#endif

  if (failed) {
    s_cycle = SEND_CYC_RTY;           // error sending data, set retry cycle
  }
  else {
    s_cycle = send_cycle;             // use cycle information from server
    if (WeckIntervallMinuten >= 30) s_cycle = send_cycle * LONG_CYCLE;
  }

  if (s_cycle < 1 ) s_cycle = 1;      // minimum 1 hour
  if (s_cycle > 12 ) s_cycle = 12;    // at least twice a day

  next_send_hour = (c_hour + s_cycle) % 24;  // next time to send
  if (next_send_hour <= c_hour) {            // next day
    if (next_send_hour > SEND_HOUR) {           // beyond 6 hours
      next_send_hour = SEND_HOUR;               // force send at 6 hours
    }
  }

  if ((c_hour < SEND_HOUR) && ((c_hour + s_cycle) > SEND_HOUR)) {  // before 6 hours
    next_send_hour = SEND_HOUR;                   // force send at 6 hours
  }

}


/**
  @brief Funktion DatenString_erstellen()
  erstellt konfigurationsabhängigen Datensatz zum abspeichern im EE-Prom
  
  @param  none,        globale Variablen
  @return  none
*/
void DatenString_erstellen() {

  int count = 0;
  DateTime jetzt = rtc.now();
  count = sprintf(DatenString, "%d/", jetzt.year());
  count += sprintf(DatenString + count, "%2.2d/", jetzt.month());
  count += sprintf(DatenString + count, "%2.2d_", jetzt.date());
  count += sprintf(DatenString + count, "%2.2d:", jetzt.hour());
  count += sprintf(DatenString + count, "%2.2d:", jetzt.minute());
  count += sprintf(DatenString + count, "%2.2d",  jetzt.second());

  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, DS_Temp, 1, No_Val);             // Wägezellentemperatur
  }
  count = Wert_hinzufuegen(count, SensorTemp[Beute1], 1, No_Val);    // Stocktemperatur 1
  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute2], 1, No_Val);  // Stocktemperatur 2
  }
  if (Anzahl_Sensoren_Gewicht > 2) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute3], 1, No_Val);  // Stocktemperatur 3
  }
  if (Anzahl_Sensoren_Gewicht > 3) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute4], 1, No_Val);  // Stocktemperatur 4
  }
  if (Anzahl_Sensoren_Gewicht > 4) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute5], 1, No_Val);  // Stocktemperatur 5
  }
  if (Anzahl_Sensoren_Gewicht > 5) {
    count = Wert_hinzufuegen(count, SensorTemp[Beute6], 1, No_Val);  // Stocktemperatur 6
  }

  count = Wert_hinzufuegen(count, SensorTemp[Aussenwerte], 1, No_Val);     // Außentemperatur

  count = Wert_hinzufuegen(count, SensorFeuchte[Beute1], 1, No_Value);     // Stockluftfeuchte 1
  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute2], 1, No_Value);   // Stockluftfeuchte 2
  }
  if (Anzahl_Sensoren_Gewicht > 2) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute3], 1, No_Value);   // Stockluftfeuchte 3
  }
  if (Anzahl_Sensoren_Gewicht > 3) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute4], 1, No_Value);   // Stockluftfeuchte 4
  }
  if (Anzahl_Sensoren_Gewicht > 4) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute5], 1, No_Value);   // Stockluftfeuchte 5
  }
  if (Anzahl_Sensoren_Gewicht > 5) {
    count = Wert_hinzufuegen(count, SensorFeuchte[Beute6], 1, No_Value);   // Stockluftfeuchte 6
  }
  count = Wert_hinzufuegen(count, SensorFeuchte[Aussenwerte], 1, No_Value);  // Außenluftfeuchte
  count = Wert_hinzufuegen(count, Licht, 1, No_Value);                 // Licht
  count = Wert_hinzufuegen(count, Gewicht[0], 2, No_Value);            // Gewicht 1
  if (Anzahl_Sensoren_Gewicht > 1) {
    count = Wert_hinzufuegen(count, Gewicht[1], 2, No_Value);          // Gewicht 2
  }
  if (Anzahl_Sensoren_Gewicht > 2) {
    count = Wert_hinzufuegen(count, Gewicht[2], 2, No_Value);          // Gewicht 3
  }
  if (Anzahl_Sensoren_Gewicht > 3) {
    count = Wert_hinzufuegen(count, Gewicht[3], 2, No_Value);          // Gewicht 4
  }
  if (Anzahl_Sensoren_Gewicht > 4) {
    count = Wert_hinzufuegen(count, Gewicht[4], 2, No_Value);          // Gewicht 5
  }
  if (Anzahl_Sensoren_Gewicht > 5) {
    count = Wert_hinzufuegen(count, Gewicht[5], 2, No_Value);          // Gewicht 6
  }
  count = Wert_hinzufuegen(count, Batteriespannung, 2, No_Value); // Akkuspannung
  count = Wert_hinzufuegen(count, Solarspannung, 2, No_Value);    // Solarspannung
  count = Wert_hinzufuegen(count, Service, 2, No_Value);    // Service
  count = Wert_hinzufuegen(count, Aux[1], 1, No_Value);  // Aux 1
  count = Wert_hinzufuegen(count, Aux[2], 2, No_Value);  // Aux 2
  count = Wert_hinzufuegen(count, Aux[0], 2, No_Value);  // Aux 0
  DatenString[count] = 0;
}


/**
  @brief Funktion Wert_hinzufuegen()
  erstellt Stringanteil für Datensatz
  
  @param  
  count: aktuelle Position im String, 
  Wert: Messwert,
  Nachkommastellen: Anzahl der Nachkommastellen für diesen Messwert
  Fehler: Vergleichswert für fehlerhaften oder unbenutzten Messwert 
  @return  neue Position im Datenstring
*/
int Wert_hinzufuegen(int count, float Wert, uint8_t Nachkommastellen, float Fehler) {
  char Konvertierung[16];
  int count_neu = count;

  if (Wert == Fehler) {
    count_neu += sprintf(DatenString + count, ",%s", "");
  } else {
    dtostrf(Wert, 1, Nachkommastellen, Konvertierung);
    count_neu += sprintf(DatenString + count, ",%s", Konvertierung);
  }
  return count_neu;
}
