/*
   (C) 2020 R.Schick / Thorsten Gurzan - beelogger.de

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
// Der Sketch verwendet 13498 Bytes (27%) des Programmspeicherplatzes. Das Maximum sind 49152 Bytes.
// Globale Variablen verwenden 698 Bytes (11%) des dynamischen Speichers, 5446 Bytes für lokale Variablen verbleiben.

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de


#include <Sodaq_DS3231.h>
#include <Wire.h>
//#include <LowPower.h>


// Kalibrierung, bitte Werte eintragen.
//----------------------------------
const long Kalib_Spannung =  12930;    // Hier ist der Wert aus der Kalibrierung einzutragen
const long Kalib_Bitwert  =  3367;    // Hier ist der Wert aus der Kalibrierung einzutragen

//----------------------------------


// Intervalle
//----------------------------------
byte WeckIntervallMinuten = 1;
byte AlternativIntervallMinuten = 6;
float VAlternativ = 3.83;             // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
float VMinimum = 3.8;                 // Minimale Spannung, Fehlermeldung
//----------------------------------


float Batteriespannung = -1.0;
float Solarspannung = -1.0;
float RTCTemp = 99.9;

volatile bool ok_sleep = false;

#define USB_RX      PIN_WIRE_HWSERIAL1_RX           // Pin 0 RX-USB
#define USB_TX      PIN_WIRE_HWSERIAL1_TX           // Pin 1 TX-USB

#define DS3231_Interrupt_Pin  2

#define Power_Pin  4

#define Batterie_messen    A6
#define Solarzelle_messen  A7

DateTime aktuell;
int count = 2;

//--------------------------------------------------
void setup() {
  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, HIGH);

  Serial.begin(9600);
  while (!Serial) {  };
  delay(1000);
  Serial.println("beelogger Power-On-Off-Test Every ");
  Serial.println();

  Serial.println();
  Serial.println("... teste Uhr(DS3231), ADC-Kalibrierwerte und Power-ON-OFF ");
  Serial.flush();



  if ( Kalib_Bitwert == 100) {
    Serial.println();
    Serial.println();
    Serial.println("Bitte Kalibrierwerte eintragen! ");
    Serial.println("Bitte Kalibrierwerte eintragen! ");
    Serial.println("Bitte Kalibrierwerte eintragen! ");
    Serial.println();
    Serial.println();
    Serial.flush();
    WeckIntervallMinuten = 10;
  }
  Spannungen_messen();

  pinMode(Power_Pin, OUTPUT);
  digitalWrite(Power_Pin, HIGH);
  delay(5);


  rtc.begin();

  DateTime pc_tim = DateTime(__DATE__, __TIME__);
  long l_pczeit = pc_tim.get();
  DateTime aktuell = rtc.now();
  long l_zeit = aktuell.get();
  if (l_pczeit > l_zeit)  rtc.setDateTime(pc_tim.get());

  //rtc.setDateTime(pc_tim.get());

  rtc.clearINTStatus();

  delay(100);
  pinMode(DS3231_Interrupt_Pin, INPUT_PULLUP);
  delay(100);

  check_D2();  // check Interrupt Pin

  pinMode(DS3231_Interrupt_Pin, INPUT_PULLUP);
  ok_sleep = true;

  delay(5);

  if (display_time() == 0) {
    digitalWrite(Power_Pin, LOW);
    Serial.println("\n\nSketch STOP");
    Serial.flush();
    delay(200);
    while (true) {};
  }

  Alarm_konfigurieren();
  SleepNow(false);
}
//--------------------------------------------------


//##################################################
void loop() {
  Serial.begin(9600);
  while (!Serial) {  };
  check_intervall();
  Spannungen_messen();
  check_D2();  // check Interrupt Pin
  display_time();
  display_temp();

  Alarm_konfigurieren();
  SleepNow(true);
}
//##################################################






//--------------------------------------------------
void WakeUp() {
  detachInterrupt(digitalPinToInterrupt(DS3231_Interrupt_Pin));
  ok_sleep = false;
}
//--------------------------------------------------


//--------------------------------------------------
void SleepNow(byte power_off) {
  delay(100);

  //char pwr_off;
  //power_off = 1; count--;

  if (power_off) {
    Serial.println("Sleep-Modus mit Power-OFF ist aktiviert, bitte warten ... ");
    Serial.flush();
    digitalWrite(LED_BUILTIN, LOW);
    digitalWrite(Power_Pin, LOW);
    pinMode(Power_Pin, INPUT);
    delay(2000);
    check_D2();  // check Interrupt Pin
  }
  else {
    Serial.println("Sleep-Modus mit Power-ON gestartet, bitte warten ... ");
  }
  Serial.flush();
  Serial.end();        // Serial aus
  delay(50);

  turn_off();

  delay(1);
  /* Only asynchronous input pin can be used as wake up source during power */
  /* down. Pin D2, D6, D14, D16, D18, D22 on 32-pin ATMega4808 */
  attachInterrupt(digitalPinToInterrupt(DS3231_Interrupt_Pin), WakeUp, LOW);  // D2 = Interrupt
  //attachInterrupt(DS3231_Interrupt_Pin, WakeUp, LOW);

  delay(10);  // neu
  if (ok_sleep) {

    //LowPower.powerDown();
    power_dwn();

  }
  else {
    Serial.begin(9600);
    while (!Serial) {  };
    Serial.println("********************************************");
    Serial.println("Sleep-Modus konnte nicht aktiviert werden");
    Serial.println("********************************************");
    Serial.flush();
  }

  Serial.begin(9600);
  while (!Serial) {  };
  Serial.println("###################");
  Serial.flush();
  delay(500);
  pinMode(Power_Pin, OUTPUT);
  digitalWrite(Power_Pin, HIGH);
  delay (500);
  rtc.begin();
  rtc.clearINTStatus();
  ok_sleep = true;

  if (power_off) {
    Serial.println("Sleep-Modus mit Power-OFF beendet ");
    Serial.println();
    Serial.println("Power-On-OFF Test erfolgreich!");
    Serial.println();
    Serial.flush();
    count --;
  }
  else {
    Serial.println("Power-ON Sleep wurde beendet.");
    Serial.println();
    Serial.flush();
  }
  Serial.println();
  Serial.flush();
  delay(5);
  // Power off test counter
  if (count == 0) {
    Serial.println("------------------- Test beendet");
    Serial.flush();
    Serial.end();        // Serial aus
    delay(50);

    digitalWrite(Power_Pin, LOW);
    pinMode(Power_Pin, INPUT);

    attachInterrupt(digitalPinToInterrupt(DS3231_Interrupt_Pin), WakeUp, LOW);  // D2 = Interrupt
    //attachInterrupt(DS3231_Interrupt_Pin, WakeUp, LOW);

    //LowPower.powerDown();
    turn_off();
    delay(10);
    power_dwn();

    Serial.begin(9600);
    while (!Serial) {  };
    while (1 == 1) {
      Serial.print("*");
      delay (5000);
    }
  }
}
//--------------------------------------------------


//--------------------------------------------------
void turn_off() {
  //Wire.begin();
  //delay(50);
  //Wire.end();//TWCR &= ~(bit(TWEN) | bit(TWIE) | bit(TWEA));
  delay(50);

  pinMode(PIN_WIRE_SDA, INPUT);
  pinMode(PIN_WIRE_SCL, INPUT);
  pinMode(USB_RX, INPUT);
  pinMode(USB_TX, INPUT);
}
//--------------------------------------------------


//--------------------------------------------------
#include <avr/io.h>
#include <avr/sleep.h>

void power_dwn() {
  VREF.CTRLB = 0x00;       // ADC Ref on request only
  CPU_CCP = CCP_IOREG_gc;  // Configuration Change Protection
  CLKCTRL.MCLKCTRLA = ( CLKCTRL_CLKSEL_OSCULP32K_gc);// | 1 << CLKCTRL_CLKOUT_bp ); // = OSCULP32K   CPU-CLK 32KHz / CLKOUT off
  CLKCTRL.MCLKCTRLB = ( 0 | 1 << CLKCTRL_PEN_bp );   // RTC-CLK
  while (CLKCTRL.MCLKSTATUS & CLKCTRL_SOSC_bm) {}    // stable clock?

  //set_sleep_mode(SLEEP_MODE_STANDBY);
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);
  cli();
  sleep_enable();
  sei();
  sleep_cpu();

  CPU_CCP = CCP_IOREG_gc;
  CLKCTRL.MCLKCTRLA = ( CLKCTRL_CLKSEL_OSC20M_gc | 1 << CLKCTRL_CLKOUT_bp );
  CLKCTRL.MCLKCTRLB = ( 0 | 1 << CLKCTRL_PEN_bp );
  while (CLKCTRL.MCLKSTATUS & CLKCTRL_SOSC_bm) {} // stable clock?
}
//--------------------------------------------------


//--------------------------------------------------
void check_intervall() {
  long l_akt = aktuell.get() - 60; //min. 1 minute
  DateTime jetzt = rtc.now();
  long l_jetzt = jetzt.get();
  long df = (l_jetzt - l_akt);
  if (df < 59) {
    Serial.println("********************************************");
    Serial.println("Fehler Sleepzeit nicht erreicht. Interrupt !");
    Serial.println("********************************************");
    Serial.println();
    Serial.flush();
  }
}
//--------------------------------------------------

//--------------------------------------------------
void display_temp() {
  RTCTemp = rtc.getTemperature();
  Serial.print("Temperatur ueber Sensor in RTC: ");
  Serial.println(RTCTemp);
  Serial.println();
  Serial.flush();
}
//--------------------------------------------------



//--------------------------------------------------
void Spannungen_messen() {
  //char BATT;  Batteriespannung = 10.0; return;

  Batteriespannung = Messe_Spannung(Batterie_messen);
  Serial.print(F(" Batterie [V]: "));
  Serial.println(Batteriespannung);
  Serial.println();
  Serial.flush();
  if (Batteriespannung > VMinimum) {
    Solarspannung = Messe_Spannung(Solarzelle_messen);
    Serial.print(F(" Solarspannung [V]: "));
    Serial.println(Solarspannung);
    Serial.println();
    Serial.flush();
  }
}
//--------------------------------------------------


//--------------------------------------------------
float Messe_Spannung (byte Pin) {
  long Messung_Spannung;
  float Spannung;
  Messung_Spannung = analogRead(Pin);
  Messung_Spannung = 0;
  for (byte j = 0 ; j < 16; j++) {
    Messung_Spannung += analogRead(Pin);
  }
  Messung_Spannung = Messung_Spannung >> 2;
  Serial.print("\nADC-Bitwert= ");  Serial.print(Messung_Spannung); Serial.println();
  Serial.flush();
  Spannung = (float)map(Messung_Spannung, 0, Kalib_Bitwert, 0, Kalib_Spannung) / 1000.0;
  return (Spannung);
}
//--------------------------------------------------


//--------------------------------------------------
void Alarm_konfigurieren() {
  byte IntervallMinuten;

  if (Batteriespannung > VAlternativ) {
    IntervallMinuten = WeckIntervallMinuten;
  } else {
    Serial.println();
    Serial.println("******************************************************************");
    Serial.println("Batteriespannung unter Grenzwert, alternatives Intervall aktiviert");
    Serial.println("******************************************************************");
    Serial.println();
    Serial.flush();
    IntervallMinuten = AlternativIntervallMinuten;
  }

  Serial.println();
  Serial.print("Eingestelltes Weckintervall: ");
  Serial.print(IntervallMinuten);
  Serial.println(" Minute(n)");
  Serial.flush();

  aktuell = rtc.now();
  long timestamp = aktuell.get();
  aktuell = timestamp + IntervallMinuten * 60;
  rtc.enableInterrupts(aktuell.hour(), aktuell.minute(), aktuell.second());

  Serial.print("Wakeup at: ");
  Serial.print(aktuell.hour());
  Serial.print(":");
  Serial.flush();
  if (aktuell.minute() < 10) Serial.print("0");
  Serial.print(aktuell.minute());
  Serial.print(":");
  if (aktuell.second() < 10) Serial.print("0");
  Serial.println(aktuell.second());  Serial.println();
  Serial.flush();
}
//--------------------------------------------------


//--------------------------------------------------
void check_D2() {
  int val = digitalRead(DS3231_Interrupt_Pin);
  if ( val == 0) {
    Serial.println();
    Serial.println();
    Serial.println("  PIN D2  ist auf 0 Volt, eventuell Kurzschluß, Schalter ein? ");
    Serial.println("  Sketch nicht funktionsfähig! ");
    Serial.println("  Sketch neu starten oder ");
    Serial.flush();
    Serial.println("  bitte korrigieren! ");
    Serial.println();
    Serial.println();
    Serial.flush();
    while (digitalRead(DS3231_Interrupt_Pin) == 0) {
      delay (5000);
      Serial.print("*");
      Serial.flush();
    };
  }
}
//--------------------------------------------------

//--------------------------------------------------
uint8_t  display_time() {
  uint8_t ok_val = 0;
  char buf[8];
  DateTime aktuell = rtc.now();
  if ( aktuell.year() > 2100) {
    Serial.print("\nUhrbaustein nicht erkannt oder nicht vorhanden \n");
    Serial.flush();
  }
  else {
    ok_val = 1;
    Serial.print("beelogger-System Datum und Uhrzeit: ");
    Serial.print(aktuell.date());
    Serial.print('.');
    Serial.print(aktuell.month());
    Serial.print('.');
    Serial.flush();
    Serial.print(aktuell.year());
    byte h = aktuell.hour();
    if (h < 10) {
      Serial.print("  ");
    }
    else Serial.print(' ');
    Serial.print(h);
    Serial.print(':');
    sprintf(buf, "%02d", aktuell.minute());
    Serial.print(buf);
    Serial.print(':');
    sprintf(buf, "%02d", aktuell.second());
    Serial.print(buf);
    Serial.flush();
  }
  Serial.println();
  Serial.flush();
  return (ok_val);
}
//--------------------------------------------------
