/****************************************************************/
// Funktion SIM800L - Mobilfunk  TCP / CIP-Send  EE-Prom
/****************************************************************/
// 24.04.2021 STM32
// 02.01.2022 fix EE-Prom errorhandling
// 16.03.2022 fix Ram Use of Wire
// 15.10.2023 use EE-Prom up to 128kByte in STM32F4x1 systems
// 14.07.2024 Mx-Strings
// 18.07.2024 USE EEProm "round-robin"
// 12.01.2025 Send A=1 obsolete


/****************************************************************/
// Konfiguration SIM800L - Mobilfunk
/****************************************************************/
#include <SIM800_STM_beelogger.h>

#define SERVER_TM_OUT 10000 // 10000 = 10 sec
/****************************************************************/


/****************************************************************/
// Parameter Datenversand via Http // diese nicht modifizieren
/****************************************************************/
const char Str_Http[]    PROGMEM = " HTTP/1.1\r\n";
const char Str_Con_cls[] PROGMEM = "Connection: close\r\n\r\n";

const char Str_Pw[]      PROGMEM = {"PW="};
const char Str_Id[]      PROGMEM = {"&Z=2&ID="};
#if(Anzahl_Sensoren_Gewicht == 1)
const char Str_MData[] PROGMEM = { "&M1=" };  // Parameter Multi Data  Senden
#endif
#if(Anzahl_Sensoren_Gewicht == 2)
const char Str_MData[] PROGMEM = { "&M2=" };  // Parameter Multi Data  Senden
#endif
#if(Anzahl_Sensoren_Gewicht == 3)
const char Str_MData[] PROGMEM = { "&M3=" };  // Parameter Multi Data  Senden
#endif
#if(Anzahl_Sensoren_Gewicht == 4)
const char Str_MData[] PROGMEM = { "&M4=" };  // Parameter Multi Data  Senden
#endif
/****************************************************************/


/**
  @brief Utility functions
  stop_DFUe_device(): SIM7600E Reset aktiv oder Power inaktiv

  @param  none, globale Variablen
  @return  none
*/
void stop_DFUe_device() {
  pinMode(SIM_Power_Pin, OUTPUT);
  digitalWrite(SIM_Power_Pin, LOW);    // SIM800 "off"
}

/**
  @brief Funktion SIM7600E Send_Data()
  initialisiere SIM7600E, vebinde ins Mobilfunknetz
  verbinde zum Server, lese Daten aus EE-Prom,
  übertrage Daten, Server-Quittung auswerten
  Fehlerbehandlung bei der Übertragung
  Setze aus Serverquittung:
  - Zeit in DS3231
  - Messintervall
  - Sendeintervall

  @param  count:: Anzahl Datensätze zu übertragen, globale Variablen
  @return  senden erfolgreich > 0
*/
uint8_t Send_Data(uint16_t count) {
  char parameter[128];
  uint8_t additonal_Data = 0;

  uint8_t sum, test, first; // EE-Prom Checksumme
  char chk[2];

  uint16_t ee_pos;
  uint16_t x, y;       // Datensatz zaehler
  uint16_t s_cnt = 0;            // send counter

  uint8_t data_send;    // send status
  uint8_t retry;        // retry counter

  CGPRS_STM_SIM800 dfue;

  digitalWrite(SIM_Power_Pin, HIGH);

  debugprintlnF("GSMon");
  debugflush();

  delay(4000);

  if (dfue.init(6000)) {  // Init SIM800 Modul
    dfue.sendCommand("AT");
    debugprintlnF("Init!");
    debugflush();

    strcpy_P(parameter, APN);
    debugprintln(parameter);
    debugflush();
    if (dfue.start(parameter) == 0) {  // Start dfue Connection
      dfue.sendCommand("AT");

      // user action, force time_on or signal quality
      if (((report_info == 1) && (Service < 90.0)) || (Service == 999.0)) {
        delay(100);

        int Signal = dfue.getSignalQuality();
        Service = (float)Signal;
        additonal_Data = 1;

        debugprint(Signal);
        debugprintlnF(" dBm");
        debugflush();

      }
      else if ((report_info == 2) && (Service < 90.0)) {
        delay(100);
        int simVoltage = dfue.getSIM800_Voltage();
        if (simVoltage > 0) {
          Service = ((float)simVoltage) / 1000.0;
          additonal_Data = 1;
        }
      }
      else if (Service == 99.0) additonal_Data = 1;

      //#################
      AT24Cxx  my_EEPROM(AT24Cxx_CTRL_ID);
      data_send = 0;    // send status
      retry = 0;        // retry counter
      do {  // retry loop
        do {  // Blockweise send loop
          data_send = 0;
          // always new connect; session alive not supported by server

          strcpy_P(parameter, serverName);
          debugprintln(parameter);
          debugflush();
          if (dfue.Connect(parameter)) {  // Start TCP Connection
            dfue.sendCommand("AT");
            debugprintlnF("Con!");
            debugflush();

            if (dfue.prep_send()) {         // Prepare send data

              strcpy_P(parameter, beelogger_pfad);    // GET ....
              debugprintln(parameter);
              debugflush();
              dfue.send(parameter);
              strcpy_P(parameter, Str_Pw);
              dfue.send(parameter);
              strcpy_P(parameter, Passwort);
              dfue.send(parameter);
              // System ID
              strcpy_P(parameter, Str_Id);
              strcat(parameter, ID_ID);
              dfue.send(parameter);

              //Daten
              y = 0; first = 1;
              do {
                // lese von AT24Cxx
                test = 0;
                do {
                  ee_pos = (my_counter_start + s_cnt + y);
                  //debugprintln(ee_pos);debugflush();
                  if (ee_pos >= _EE_DATA_SETS) ee_pos -= _EE_DATA_SETS;
                  ee_pos *= _Daten_Satz_Len;
                  //debugprintln(ee_pos);debugflush();
                  my_EEPROM.ReadStr(ee_pos, DatenString, _Daten_Satz_Len - 2);
                  DatenString[(_Daten_Satz_Len - 2)] = 0;  // String ende erzwingen
                  sum = 0;
                  for (x = 0; x < strlen(DatenString); x++) {  // EE_Prom Checksum test
                    sum += DatenString[x];
                  }
                  ee_pos = ee_pos + _Daten_Satz_Len - 1;
                  my_EEPROM.ReadStr(ee_pos, chk, 1);
                  x = (uint8_t)chk[0];
                  test++;
                } while ((test < 2) && (sum != x));  // zwei Leseversuche

                if (sum == x) {           // checksumme i.o.
                  if (first == 1) {       // einfügen Satztrenner
                    first = 0;
                    strcpy_P(parameter, Str_MData);
                    dfue.send(parameter);

                    debugprint(parameter);
                    debugflush();
                  }
                  else                 {
                    dfue.send(",");
                  }
                  dfue.send(DatenString);
                  delay(50);
                  debugprintln(DatenString);
                  debugflush();
                }
                else {                    // Datensatz auslassen
                  DatenString[0] = 0;
                  debugprintF("EE?");
                  debugprintln(ee_pos);
                  debugflush();
                }
                y++;

              } while ( (y < _Send_Sets) && ((s_cnt + y) < count) );

              if ( (additonal_Data) && ((s_cnt + y) == count) ) { // all done, Service ?
                char service_data[16];
                dtostrf(Service, 1, 3, service_data);
                sprintf(DatenString, "&S=%s", service_data);
                dfue.send(DatenString);

                debugprintln(DatenString);
                debugflush();
              }
              // ende Daten
              strcpy_P(parameter, Str_Http);   dfue.send(parameter);// HTTP/1.1
              strcpy(parameter, "Host: ");     dfue.send(parameter);
              strcpy_P(parameter, serverName); dfue.send(parameter);
              strcpy(parameter, "\r\n");       dfue.send(parameter);
              strcpy_P(parameter, Str_Con_cls); dfue.send(parameter);
              dfue.send(0x00);   // Start send data
              // http complete
              debugprintln("http");
              debugflush();

              if (dfue.sendCommand(0, SERVER_TM_OUT, "ok *")) { // hat Server Anfrage quittiert ?

                data_send = 1; // success
                retry = 0;
                s_cnt += _Send_Sets;

                char *p_buf = strstr(dfue.buffer, "ok *");  // search string start
                *p_buf = 0;
                uint8_t pos = 0;
                do {
                  p_buf --;    // search start of line
                  pos++;
                }
                while ( (!(*p_buf == '\n')) && (pos < 20));

                debugprint("Q:"); debugprintln(p_buf); debugflush();

                // Format Quittung aus beelogger-log.php
                // echo "5ok *"  = 5 Minuten
                int n;
                if (char *p_bf = strchr(p_buf, 'T') ) {
                  n = atoi(p_bf + 1);  // Konvertiere str in int

                  char x = *(p_buf + 1);
                  if ((x > 0x2F) && (x < 0x3A)) { // first char a number?
                    long l_tm = atol(p_buf);
                    uint32_t epochTime = (uint32_t)l_tm ;
                    rtc_stm.setEpoch(epochTime);
                  }
                }
                else {
                  n = atoi(p_buf); // Konvertiere str in int
                }
                if ((n > 4) && (n <= 60)) {
                  WeckIntervallMinuten = (uint8_t) n;
                }

                report_info = 0;
                if (strchr(p_buf, 'P')) report_info = 1;
                if (strchr(p_buf, 'V')) report_info = 2;
                if (strchr(p_buf, 'A')) send_cycle = SEND_CYC_A;
                else if (strchr(p_buf, 'B')) send_cycle = SEND_CYC_B;
                else if (strchr(p_buf, 'C')) send_cycle = SEND_CYC_C;
                else if (strchr(p_buf, 'D')) send_cycle = SEND_CYC_D;
              } // received ok *
            } // prep_send
          } // Connect
          dfue.disConnect();
          delay(2000);
        }
        while ((s_cnt < count) && (data_send == 1)); // while my_counter
        //######################
        if (data_send == 0) {  // failed, stop and retry
          dfue.stop();        // stop CIP session

          debugprintlnF("Retry");
          debugflush();

          delay(5000);
          retry ++;
        }
        if (retry == 1)report_info = 0; // error may be due to fieldstrength measurement
      }
      while ((retry < 3) && (data_send == 0)); // retry TCP Connect
      my_EEPROM.end();
    }
    // start
  }
  // init

#if myDEBUG
  if (s_cnt > count) s_cnt = count;
#endif
  debugprintF("\nsend "); debugprintln(s_cnt); debugflush();

  dfue.stop();        // stop CIP session
  dfue.shutdown();    // shutdown dfue
  delay(200);
  digitalWrite(SIM_Power_Pin, LOW);
  digitalWrite(SER2_RX, LOW);
  digitalWrite(SER2_TX, LOW);
  delay(1000);
  return (s_cnt);
}
