/**
  @brief Funktion BME280 - Temperatur und Luftfeuchte, Luftdruck
  @param  i2c address
  @return  none
*/

#if Test_SD_Card

void Sensor_BME280(uint8_t addr) {
  Serial.println(F(" SD-card test active, not testing BME 280"));
}

#else

#include "beelogger_Adafruit_BME280.h"
#define SEALEVELPRESSURE_HPA (1013.25f)

void Sensor_BME280(uint8_t addr) {

  float Temperatur_BME;
  float Luftfeuchte_BME;
  float Luftdruck_BME;
  uint8_t check;

  Serial.println(F("BME280"));

  beelogger_Adafruit_BME280 my_bme;
  check = my_bme.begin(addr); // I2C Adresse
  if (!check) {
    Serial.print("ID= "); Serial.println(my_bme.sensorID(), 16);
    Serial.print(F(" 0x56-0x58 -> BMP 280\n"));
    Serial.print(F(" 0x60      -> BME 280\n"));
    Serial.print(F(" 0x61      -> BME 680\n"));
    Serial.print(F(" 0xFF bad, or a BMP 180 / BMP 085\n"));
  }
  else {
    delay (100); // time to get sensor ready

    Temperatur_BME = my_bme.readTemperature();
    Luftfeuchte_BME = my_bme.readHumidity();
    Luftdruck_BME = my_bme.readPressure();
    if (!isnan(Luftdruck_BME)) {
      Luftdruck_BME = Luftdruck_BME / 100.0;
    }
    Serial.print(s_temp);
    Serial.println(Temperatur_BME);
    Serial.print(s_hum);
    Serial.println(Luftfeuchte_BME);
    Serial.print(s_press);
    Serial.println(Luftdruck_BME);
  }
  Wire.end();
  Serial.println(" ");
  Serial.flush();
}
#endif
