/*
   (C) 2023 R.Schick - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de

//----------------------------------------------------------------
// Konfiguration
//----------------------------------------------------------------

#define UNI_2X  // Universal Platine Version 2.x // am Zeilenanfang entfernen

//----------------------------------------------------------------
// Ende Konfiguration
//----------------------------------------------------------------

char ID[] = "beelogger Test RXTX 09.04.2025";
#include <AltSoftSerial.h>
AltSoftSerial altSerial;   // D8, D9 für Serial

#define Test_Baudrate 9600    //  Baudrate für die serielle Kommunikation/Monitor

#define POWER 4

#define ESP_RESET A2

#if (defined(ARDUINO_AVR_PRO) && (F_CPU==16000000L) && (not defined UNI_2X)) // Pro Mini 5V 16MHz Universal 1.x  
#undef ESP_RESET
#define ESP_RESET 12
#endif

void setup() {

  digitalWrite(ESP_RESET , HIGH);
  pinMode(ESP_RESET , OUTPUT);
  digitalWrite(POWER, HIGH);
  pinMode(POWER, OUTPUT);

  my_blink(2, 500);
  altSerial.begin(Test_Baudrate);

  Serial.begin(Test_Baudrate);
  while (!Serial);
  Serial.println(ID);
  Serial.println(" ");
  Serial.println("  Start des SIM 76x0 bzw. ESP8266 beobachten oder ");
  Serial.println("  bei Fehlersuche Modul entfernen und RX mit TX an der Buchsenleiste SIM800 oder ESP8266 verbinden. ");
  Serial.println(" ");
  Serial.println(" Monitor Einstellung 'Sowohl NL als auch CR' vornehmen");
  Serial.println(" Testdaten am Monitor eingeben: ");
  Serial.println("   diese werden im Monitor angezeigt. ");
  Serial.flush();
}

char incomingByte; // for incoming serial data
char c;

void loop() {
  if (Serial.available()) {
    c = Serial.read();
    altSerial.print(c);
  }
  // reply only when you receive data:
  if (altSerial.available() > 0) {
    Serial.println("\nEmpfangen:");
    while (altSerial.available() > 0) {
      // read the incoming byte:
      incomingByte = altSerial.read();
      Serial.print(incomingByte);
      delay(2);
    }
  }
}


void my_blink(uint8_t nmr, uint16_t howlong) {
  for (uint8_t x = 0; x < nmr; x++) {
    pinMode(LED_BUILTIN, OUTPUT);
    digitalWrite(LED_BUILTIN, HIGH);   // turn the LED on (HIGH is the voltage level)
    delay(howlong);                       // wait for a second
    digitalWrite(LED_BUILTIN, LOW);    // turn the LED off by making the voltage LOW
    delay(howlong);                       // wait for a second
  }
}
