/*
   (C) 2022 R.Schick - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de

//Version 2023.12.08
//----------------------------------------------------------------
// Konfiguration
//----------------------------------------------------------------

// #define UNI_2X  // Universal Platine Version 2.x // am Zeilenanfang entfernen

#define Power_Pin 4
#define LED_ 13

#define ESP_RESET A2

#if (defined(ARDUINO_AVR_PRO) && (F_CPU==16000000L) && (not defined UNI_2X)) // Pro Mini 5V 16MHz Universal 1.x 
#undef ESP_RESET
#define ESP_RESET 12
#endif

//--------------------------------------------------------------
#include <LowPower.h>
void setup(void) {


  blink_LED(3, 100);

  digitalWrite(Power_Pin, HIGH); // Power On
  pinMode(Power_Pin, OUTPUT);
  delay(5);
  digitalWrite(ESP_RESET, HIGH); // ESP Reset Run mode
  pinMode(ESP_RESET, OUTPUT);
  delay(5);

}
//--------------------------------------------------------------
void loop(void) {
  // nothing to see here
  LowPower.powerDown(SLEEP_FOREVER, ADC_OFF, BOD_OFF);
}
//--------------------------------------------------------------

/**
  @brief Funktion blink_LED

  LED an Pin "13" blinken

  @param  Anzahl, Zeitdauer an/aus
  @return  none
*/
void blink_LED(uint8_t nmr, uint16_t bl_tm) {
  pinMode(LED_, OUTPUT);
  for (int i = 0; i < nmr; i++) {
    digitalWrite(LED_, LOW);  delay(bl_tm); // LED an
    digitalWrite(LED_, HIGH); delay(bl_tm);
  }
  pinMode(LED_, INPUT);
}
