//--------------------------------------------------------------
// SD-Karte 
//----------------------------------------------------------------
#if Test_SD_Card
#include <SPI.h>
#include <SdFat.h>
#include <EEPROM.h>        // Dateiname in ATmega EE-Prom ablegen



uint8_t LED_ON = 1;

void Daten_auf_SD_speichern() {

  char File_Name[16] = {"        .   "};
  EEPROM.put(0, File_Name);

  strcpy(File_Name, "test_csv.csv");
  
  SdFat SD;
  File dataFile;

  Serial.println("\n");
  Serial.println(F("Info:  SD - Card need to be formated  FAT or FAT16 (not FAT32) "));
  Serial.println(" ");
  Serial.flush();
  Serial.print(F("data prepared:  "));
  DatenString_erstellen();
  Serial.println(DatenString);
  Serial.println(" ");
  Serial.print(F("connect to SD - Card:  "));
  Serial.flush();

  if (SD.begin(SD_CS, SPI_HALF_SPEED)) {
    Serial.println("o.k.");
    Serial.flush();

    Serial.print(F("open file:  "));
    Serial.println(File_Name);
    Serial.flush();
    dataFile = SD.open(File_Name, FILE_WRITE);
    if (dataFile) {
      dataFile.println(DatenString);
      Serial.print(F("write to file: "));
      Serial.println(DatenString);
      Serial.flush();
      dataFile.close();
      if (LED_ON == 1) {
        digitalWrite(SD_LED, HIGH);
        delay(150);
        digitalWrite(SD_LED, LOW);
        LED_ON = 0;
      }
      else {
        Serial.println(F("error file write!"));
      }
    }
    else {
      Serial.println(F("error file open!"));
    }
  }
  else {
    Serial.println(F("error connect to SD-card!"));
  }
  Serial.println(F("SD test done "));
  Serial.flush();
  if (LED_ON == 1) {
    digitalWrite(SD_LED, HIGH);
    delay(2000);
    digitalWrite(SD_LED, LOW);
  }
  delay(100);
  SPI.end();
  LED_ON = 0;
}
#endif
//--------------------------------------------------------------

//----------------------------------------------------------------
// Funktion SD-Kartenmodul - Datenstring erstellen
//----------------------------------------------------------------
void DatenString_erstellen() {

  DateTime aktuell = rtc.now();
  int count = 0;

  count = sprintf(DatenString, "%d/", aktuell.year());
  count += sprintf(DatenString + count, "%2.2d/", aktuell.month());
  count += sprintf(DatenString + count, "%2.2d ", aktuell.date());
  count += sprintf(DatenString + count, "%2.2d:", aktuell.hour());
  count += sprintf(DatenString + count, "%2.2d", aktuell.minute());

  count = Wert_hinzufuegen(count, TempSys, 2, 1);        // Testwert

  DatenString[count] = 0;
}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion SD-Kartenmodul - Wert hinzufügen
//----------------------------------------------------------------
int Wert_hinzufuegen(int count, double Wert, byte Nachkommastellen, float Fehler) {
  char Konvertierung[16];
  int count_neu = count;

  if (((Fehler == 1) and (Wert == No_Val)) or ((Fehler == 2) and (Wert == No_Value)) ) {
    count_neu += sprintf(DatenString + count, ", %s", "");

  } else {
    dtostrf(Wert, 1, Nachkommastellen, Konvertierung);
    count_neu += sprintf(DatenString + count, ", %s", Konvertierung);
  }
  return count_neu;
}
//----------------------------------------------------------------
