//----------------------------------------------------------------
// TwoWire
//----------------------------------------------------------------

#include "Wire.h"
extern "C" {
#include "utility/twi.h"  // from Wire library, so we can do bus scanning
}

byte start_address = 8;       // lower addresses are reserved to prevent conflicts with other protocols
byte end_address = 119;       // higher addresses unlock other modes, like 10-bit addressing

void discoverI2CDevices()
{
  Wire.begin();
  Wire.setClock(100000);
  Serial.println(F("\nI2C-Scanner:"));

  Serial.print(F("scanning of I2C bus from 0x"));
  Serial.print(start_address, HEX);
  Serial.print(" to 0x");
  Serial.print(end_address, HEX);
  Serial.println("...");
  Serial.flush();

  // start the scan, will call "scanFunc()" on result from each address
  scanI2CBus( start_address, end_address, scanFunc );

  Serial.println(F("I2C scan done"));
  Serial.println(" ");
  Serial.flush();
  Wire.end();
}


// Scan the I2C bus between addresses from_addr and to_addr.
// On each address, call the callback function with the address and result.
// If result==0, address was found, otherwise, address wasn't found
// (can use result to potentially get other status on the I2C bus, see twi.c)
// Assumes Wire.begin() has already been called
void scanI2CBus(byte from_addr, byte to_addr,
                void(*callback)(byte address, byte result) )
{
  byte rc;
  byte data = 0; // not used, just an address to feed to twi_writeTo()
  for ( byte addr = from_addr; addr <= to_addr; addr++ ) {
    rc = twi_writeTo(addr, &data, 0, 1, 0);
    callback( addr, rc );
  }
}

uint8_t i2c_cnt = 0;

// Called when address is found in scanI2CBus()
// Feel free to change this as needed
// (like adding I2C comm code to figure out what kind of I2C device is there)
void scanFunc( byte addr, byte result ) {
  if (result == 0) {
    Serial.print(" found at addr: 0x");
    Serial.println(addr, HEX);
    i2c_device[i2c_cnt] = addr;
    i2c_cnt++;
    if (i2c_cnt > 16) i2c_cnt = 0; // overwrite found devices
    Serial.flush();
  }
}
//--------------------------------------------------------------
