//----------------------------------------------------------------
// Check communication module
//----------------------------------------------------------------

#include <AltSoftSerial.h>
AltSoftSerial altSerial;

#define dfue_Baudrate 9600    //  Baudrate für die serielle Kommunikation/Monitor


void dfue() {
#if ((dfue_Test == 1) && (Test_SD_Card == 0))

  Serial.println(F("Testing Com.-Modul"));
  altSerial.begin(dfue_Baudrate);
  delay (1000);
  for (uint8_t x = 0; x < 8; x++) {
    altSerial.println("AT");
    uint8_t r_val = read_ser(500);
    if (r_val == 2) {
      Serial.println(F(" found"));
      altSerial.println("AT+SIMCOMATI");
      read_ser(2000);
      altSerial.println("AT+GMR");
      read_ser(1000);
      break;
    }
    delay(5000);
    Serial.print(".");
  }
  Serial.println(" ");
  Serial.flush();
#endif
  digitalWrite(ESP_RESET , LOW);
}
//--------------------------------------------------------------



uint8_t read_ser(unsigned long timeout) {
  unsigned long t = millis();
  char c;
  uint8_t f = 0;
  do {
    if (altSerial.available()) {
      c = altSerial.read();
      Serial.print(c);
      if (f == 0) {
        if (c == 'O') f = 1;
      }
      else if (f == 1) {
        if (c == 'K') f = 2;
        else f = 0;
      }
      else if (f == 2) {
        if (c == '\r') break;
        else f = 0;
      }
    }
  } while ((millis() - t) < timeout);
  return (f); // f = 2 -> "OK"
}
