//----------------------------------------------------------------
// DS18B20 OneWire 
//----------------------------------------------------------------
#include <OneWire.h>

void discoverOneWireDevices(void) {
  byte i;
  byte addr[8];

  OneWire  ds(ONE_WIRE_BUS);  // Connect your 1-wire device to pin #

  Serial.println(F("Looking for 1-Wire devices... (i.e. DS18B20)"));
  Serial.print(F("at Pin: D"));
  Serial.println(ONE_WIRE_BUS);
  Serial.flush();
  while (ds.search(addr)) {
    Serial.print(F("\n\rFound device with address:\n\r"));
    Serial.flush();
    for ( i = 0; i < 8; i++) {
      Serial.print("0x");
      if (addr[i] < 16) {
        Serial.print('0');
      }
      Serial.print(addr[i], HEX);
      if (i < 7) {
        Serial.print(", ");
      }
    }
    if ( OneWire::crc8( addr, 7) != addr[7]) {
      Serial.print(F("CRC is not valid!\n"));
      return;
    }
  }
  Serial.println(F("\n\rOne-Wire scan done.\r\n"));
  Serial.flush();
  ds.reset_search();
  return;
}
//--------------------------------------------------------------
