/*
 * (C) 2015 Thorsten Gurzan - beelogger.de
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
 
// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de

#include <Wire.h>
#include <Adafruit_MCP23017.h>

const byte Anzahl_Sensoren_Bienenzaehler = 4; // Mögliche Werte: '0','1','2','3','4'

Adafruit_MCP23017 mcp[Anzahl_Sensoren_Bienenzaehler];

byte SensorAktuell[16];
byte LetzterSensor[Anzahl_Sensoren_Bienenzaehler][16]; 
               
long BienenIn = -1;
long BienenOut = -1;

byte Aktualisierung = 0;


void setup() { 
  Serial.begin(9600);
 
  if ((Anzahl_Sensoren_Bienenzaehler > 0) and (Anzahl_Sensoren_Bienenzaehler < 5)) {
    for (byte j=0; j < Anzahl_Sensoren_Bienenzaehler; j++) {
      mcp[j].begin(j+4); 
      for (byte i=0; i < 16; i++) {
        mcp[j].pinMode(i, INPUT);
        mcp[j].pullUp(i, LOW);
        LetzterSensor[j][i] = 0;
      }   
    }  
  }
}  


void loop() {
  if ((Anzahl_Sensoren_Bienenzaehler > 0) and (Anzahl_Sensoren_Bienenzaehler < 5)) {  
    for (byte j = 0; j < Anzahl_Sensoren_Bienenzaehler; j++) {     
      
      for (byte i = 0; i < 16; i++) { 
        SensorAktuell[i] = mcp[j].digitalRead(i);
      } 
    
      for (byte i = 0; i < 8; i++) { 
        if (SensorAktuell[i] != LetzterSensor[j][i]) {
          if (SensorAktuell[i] > SensorAktuell[i+8]) {
            if (BienenIn == -1) BienenIn = 1;
            else  BienenIn++;
          }
          Aktualisierung = 1;  
        }
        if (SensorAktuell[i+8] != LetzterSensor[j][i+8]){ 
          if (SensorAktuell[i+8] > SensorAktuell[i]) {
            if (BienenOut == -1) BienenOut = 1;
            else BienenOut++;
          }
          Aktualisierung = 1;
        }          
        LetzterSensor[j][i] = SensorAktuell[i];
        LetzterSensor[j][i+8] = SensorAktuell[i+8];
      }
    } 
    
    if (Aktualisierung > 0) { 
      for (byte j = 0; j < Anzahl_Sensoren_Bienenzaehler; j++) {  
        for (byte i = 0; i < 8; i++) {
          Serial.print(LetzterSensor[j][i]);
          Serial.print(LetzterSensor[j][i+8]);
          Serial.print(" ");
        }
        Serial.print(" --- ");
      }
      Serial.print(" ");
      Serial.print("BienenIn: "); 
      Serial.print(BienenIn); 
      Serial.print("  ");
      Serial.print("BienenOut: "); 
      Serial.println(BienenOut); 
    }  
    Aktualisierung = 0;
    delay(10);
  }
}


          
