/**
  @brief Funktion Si7021 - Temperatur und Luftfeuchte
  @param  none
  @return  none
*/
#define SI7021_Type 1  // 0 = use adafruit lib;  1 = use alternative lib



#if SI7021_Type == 1
#include "SI7021.h"
#else
#include "Adafruit_Si7021.h"
#endif

void Sensor_Si7021() {
  /*
    #if Test_SD_Card
    Serial.println(" SD-card test active, no SI7021");
    #else
  */
#if 1

  float Temperatur_SI;
  float Luftfeuchte_SI;
  Serial.println(" SI7021");

#if SI7021_Type
  SI7021 sensor7021;
  int check = sensor7021.begin();
#else
  Adafruit_Si7021 mySI7021 = Adafruit_Si7021();
  int check = mySI7021.begin();
#endif
  delay(200);

  if (check) {
#if SI7021_Type
    int temperature = sensor7021.getCelsiusHundredths();
    Temperatur_SI = ((float) temperature) / 100.0;
    int humidity = sensor7021.getHumidityPercent();
    Luftfeuchte_SI = ((float) humidity );
#else
    Temperatur_SI = mySI7021.readTemperature();
    Luftfeuchte_SI = mySI7021.readHumidity();
#endif
    Serial.print(s_temp);
    Serial.println(Temperatur_SI);
    Serial.print(s_hum);
    Serial.println(Luftfeuchte_SI);
  }
#endif
  Wire.end();
  Serial.println(" ");
  Serial.flush();

}
