/*
   (C) 2023 R.Schick - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de
// Version 2025

#include "A_System_Check_config.h"
#include "A_beelogger_config.h"
#include <LowPower.h>
#include "Sodaq_DS3231.h"

uint8_t i2c_device[16] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
uint8_t System_with_DS3231 = 0;
float TempSys = -99.9;
char DatenString[70];

//--------------------------------------------------------------
void setup(void) {

  Serial.begin(9600);
  while (!Serial) {};
  delay(100);
  Serial.println(F("\n\nSystem Check 15.04.2025\n\r"));
#if defined (ARDUINO_AVR_NANO_EVERY)
  Serial.println(F(" beelogger-Universal mit Arduino Nano EVERY "));
#endif
#if defined(ARDUINO_AVR_NANO)
  Serial.println(F(" beelogger-Universal mit Arduino Nano  "));
#else
#if defined(ARDUINO_AVR_PRO)// Pro Mini
#if defined (UNI_2X)
  Serial.println(F(" beelogger-Universal Platine 2.x"));
#else
#if (F_CPU==16000000L)     // 5V 16MHz
  Serial.print(F(" beelogger-Universal 1.x mit Arduino Pro-Mini  "));
  Serial.println(F(" 5V / 16MHz  "));
#else
  Serial.print(F(" beelogger-SMD  mit Arduino Pro-Mini 8MHz "));
  Serial.println(F(" 3,3V / 8MHz  "));
#endif
#endif
#endif
#endif


  prnt_pin(Power_Pin, 1);
  delay(5);
  Serial.flush();

  Serial.print(F("\n Pin A")); Serial.print(Batterie_messen - 14);  Serial.print (F(": Akku Bitwert:  "));
  Serial.println(Messe_Spannung( Batterie_messen ));
  Serial.print(F(" Pin A")); Serial.print(Solarzelle_messen - 14);  Serial.print (F(": Solar Bitwert:  "));
  Serial.println(Messe_Spannung( Solarzelle_messen ));
  Serial.println(" ");

  prnt_pin(ESP_RESET, dfue_Test);
  delay(5);
  Serial.flush();

  Sensor_HX711();
  Sensor_DHT();

  discoverOneWireDevices();
  Sensor_DS18B20();

  discoverI2CDevices();
  test_i2c_devices();

#if Test_SD_Card
  if (System_with_DS3231)
  {
    Daten_auf_SD_speichern();
  }
  else {
    Serial.println(F(" ohne DS3231, kein SD-Kartentest"));
  }
#endif
  dfue();
  Serial.println(" ");
  Serial.flush();

}
//--------------------------------------------------------------


//#################################################
void loop(void) {
  // nothing to see here
  if (Power_state_at_End == 0) {
    Serial.println(F("Low-Power activ."));
    digitalWrite(ESP_TX, LOW);
    pinMode(ESP_TX, INPUT);
    TWCR &= ~(bit(TWEN) | bit(TWIE) | bit(TWEA));
    digitalWrite (A4, LOW);
    digitalWrite (A5, LOW);
    digitalWrite(HX711_SCK[0], LOW);
    digitalWrite(HX711_SCK[1], LOW);
    digitalWrite(HX711_DT[0], LOW);
    digitalWrite(HX711_DT[1], LOW);
    digitalWrite(Power_Pin, LOW);
  }
  Serial.println(F("Sleep forever!"));
  Serial.flush();
  Serial.end();
  delay(300);
  LowPower.powerDown(SLEEP_FOREVER, ADC_OFF, BOD_OFF);
}
//#################################################


float Messe_Spannung (uint8_t Pin) {
  int Messung_Spannung;
  //float Spannung;
  Messung_Spannung = analogRead(Pin);
  Messung_Spannung = 0;
  for (uint8_t j = 0 ; j < 16; j++) {
    Messung_Spannung += analogRead(Pin);
  }
  Messung_Spannung = Messung_Spannung >> 2;
  //Spannung = (float)map(Messung_Spannung, 0, Kalib_Bitwert, 0, Kalib_Spannung) / 1000.0;
  return (Messung_Spannung);
}

void prnt_pin(uint8_t pin, uint8_t on) {
  Serial.print(F(" Pin "));
  if (pin > 13) {
    Serial.print("A"); Serial.print(pin - 14);
  }
  else {
    Serial.print("D"); Serial.print(pin);
  }
  if (on) {
    Serial.println(F(" high"));
    digitalWrite(pin , HIGH);  // on hold
  } else {
    Serial.println(F(" low"));
    digitalWrite(pin , LOW);  // on hold
  }
  pinMode(pin, OUTPUT);
}
