/*
   (C) 2023 R.Schick / Thorsten Gurzan - beelogger.de

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de


//----------------------------------------------------------------
// Allgemeine Konfiguration
//----------------------------------------------------------------

// #define UNI_2X  // Universal Platine Version 2.x // am Zeilenanfang entfernen


//----------------------------------------------------------------
// Kalibrierwerte Spannung, bitte eintragen.
//----------------------------------------------------------------
int Kalib_Spannung = 4000; // Hier muss der Wert aus der Kalibrierung eingetragen werden
int Kalib_Bitwert  = 1500; // Hier muss der Wert aus der Kalibrierung eingetragen werden
//----------------------------------------------------------------

//----------------------------------------------------------------
// GSM Konfiguration
//----------------------------------------------------------------

// Name des Zugangspunktes des Netzwerkproviders
//const char APN[] PROGMEM = {"internet.telekom"};
//const char APN[] PROGMEM = {"web.vodafone.de"};
//const char APN[] PROGMEM = {"internet.eplus.de"};
const char APN[] PROGMEM = {"APN"};  // passende Provider-APN eintragen


// Domainname zum Webserver mit beelogger-Skript
//const char serverName[] PROGMEM = {"meineDomain.de"};
const char serverName[] PROGMEM  = {"community.beelogger.de"};

// Verzeichnis auf dem Webserver und PHP-Skript für den jeweiligen beelogger liegen
//const char beelogger_pfad[] PROGMEM = {"GET /Accountname/beelogger1/beelogger_log.php?"};
const char beelogger_pfad[] PROGMEM = {"GET /USERXYZ/beelogger1/beelogger_log.php?"};  // bitte anpassen: USERXYZ und ggf. beelogger1

// Passwort vom Webserver-Skript
//const char Passwort[] PROGMEM = {"!meinPasswort!"};
const char Passwort[] PROGMEM = {"Log"};  // "Log" = default testsystem beelogger

//----------------------------------------------------------------

// EE-Prom Adresse
uint8_t _EEProm_adress = 0x57;

//----------------------------------------------------------------
// Ende Konfiguration
//----------------------------------------------------------------


char ID_ID[] = "GSM_TEST_230401";

// Pin  Belegung SIM800
byte GSM_TX = 9;
// beelogger_Universal (NANO), solar Multishield 2.5, neue Verdrahtung für Multishield 2.0,2.1,2.2
byte GSM_RX = 8;

//----------------------------------------------------------------
// Parameter Datenversand via Http // diese nicht modifizieren
//----------------------------------------------------------------
const char Str_Http[] PROGMEM  = " HTTP/1.1\r\n"; // mit Leerzeichen vorne
const char Str_Con[]  PROGMEM  = "Connection: close\r\n\r\n";
//----------------------------------------------------------------


//----------------------------------------------------------------
// Konfiguration SIM800L - Mobilfunk
//----------------------------------------------------------------
#include "SIM800_beelogger_23.h"
#define SERVER_TM_OUT 10000 // 10000 = 10 sec
const char Str_Pw[]      PROGMEM = {"PW="};
const char Str_Opt[]     PROGMEM = {"&Z=2&A=1"};
const char Str_Id[]      PROGMEM = {"&ID="};
const char Str_MData[]   PROGMEM = {"&M1_Data="};  // Parameter Mutli Data  Senden
CGPRS_SIM800 dfue;

// Pin  Belegung SIM 800
#define Stop_GSM_WLAN A2

#if (defined(ARDUINO_AVR_PRO) && (F_CPU==16000000L) && (not defined UNI_2X)) // Pro Mini 5V 16MHz Universal 1.x  
#undef Stop_GSM_WLAN
#define Stop_GSM_WLAN 12
#endif


//----------------------------------------------------------------

#define Power_Pin 4

#define Batterie_messen    A6
#define Solarzelle_messen  A7

#if (defined(ARDUINO_AVR_PRO) && (F_CPU==16000000L) && (not defined UNI_2X)) // Pro Mini 5V 16MHz Universal 1.x  
#undef Batterie_messen
#undef Solarzelle_messen
#define Batterie_messen    A2
#define Solarzelle_messen  A3
#endif

/****************************************************************/
// Variablen
/****************************************************************/
const float No_Val = 99.9f;  // Vorbelegung, Wert nicht gemessen
const float No_Value = -1.0f;  // Vorbelegung, Wert nicht gemessen

// Test-Messdaten (regulär kommen die Messdaten von den Sensoren)
float SensorTemp[2] = {25.0, 35.0};
float SensorFeuchte[2] = {40.0, 60.0};
float Licht = 5000;
float Gewicht[2] = {2.5, No_Value};
float Batteriespannung = 4.7;
float Solarspannung = 1.7;
float Service = 0.0;
float Aux[3] = {1.0, 2.0, 3.0};
#define Aussenwerte 0
#define Beute1      1
#define Anzahl_Sensoren_Gewicht 1

bool OK = true;
byte Verbindungsversuche = 0;


char DatenString[80];  // Datenbuffer
char parameter[80];

// stability test
#include <Wire.h>
#include "Sodaq_DS3231.h"
#define _DS3231_ADDRESS 0x68


void setup() {
  char buf[64];
  char c = '0';
  Serial.begin(9600);
  while (!Serial) {};
  Serial.println(F("GSM Test 08.12.2023: "));

  strcpy_P(parameter, beelogger_pfad);

  char *p_buf = strstr(parameter, "/beelogger");  // search first /
  uint8_t n = atoi(p_buf + 10);
  //Serial.println(p_buf + 10);
  if (n == 0) {
    Serial.println(parameter);
    Serial.println(F("\n GSM  Test Sketch nur mit beeloggerX,  X = 1...n"));
    Serial.println(F("keine  DUO, Triple, Quad, usw."));
    Serial.flush();
  }

  digitalWrite(Power_Pin, HIGH);
  pinMode(Power_Pin, OUTPUT);
  digitalWrite(Power_Pin, HIGH);
  digitalWrite(Stop_GSM_WLAN, HIGH);
  pinMode(Stop_GSM_WLAN, OUTPUT);
  digitalWrite(Stop_GSM_WLAN, HIGH);

  Serial.println(F("\nTeste DS3231 vorhanden?"));
  Serial.flush();
  Wire.begin();
  Wire.beginTransmission(_DS3231_ADDRESS);
  uint8_t error = Wire.endTransmission();

  if (error == 0) {
    Serial.println("DS3231 ... gefunden\n");

    EE_WriteMem(0, ID_ID, strlen(ID_ID));
    EE_ReadStr(0, DatenString, strlen(ID_ID));
    //Serial.println(DatenString);
    if (strcmp(ID_ID, DatenString) == 0)Serial.println(F("EE-Prom ... i.O.\n"));
    else {
      Serial.println(F("###  EE-Prom Fehler  ###\n"));
      Serial.println(F("###  EE-Prom Fehler  ###\n"));
      delay(10000);
    }
    rtc.begin();
    rtc.setDateTime(1); // start RTC
    delay(50);
    DateTime pc_tim = DateTime(__DATE__, __TIME__);
    long l_pczeit = pc_tim.get();
    DateTime aktuell = rtc.now();
    long l_zeit = aktuell.get();
    if (l_pczeit > l_zeit)  rtc.setDateTime(l_pczeit);
    if (display_time()) {
      Serial.println(F("Uhrbaustein initialisiert."));
    }
    else {
      digitalWrite(Power_Pin, LOW);
      digitalWrite(Stop_GSM_WLAN, LOW);
      Serial.println(F("\n\nSketch STOP"));
      delay(200);
      while (true) {
        delay(100);
      };
    }
  }
  else {
    Serial.println("nein\n");
    digitalWrite(Power_Pin, LOW);
    digitalWrite(Stop_GSM_WLAN, LOW);
    Serial.println(F("\n\nSketch STOP"));
    delay(200);
    while (true) {
      delay(100);
    };
  }

  SensorTemp[0] = rtc.getTemperature();
  Serial.print(F("Temperatur RTC: "));
  Serial.print(SensorTemp[0]);
  Serial.println(F("°C\n"));
  rtc.clearINTStatus();

  Serial.print(F("Initialisiere Modul ... "));
  delay(4000);
  Serial.print(F("RX= "));
  Serial.println(GSM_RX);

  Spannungen_messen();
  if ( Kalib_Bitwert == 100) {
    Serial.println(" ");
    Serial.println(F("Bitte Kalibrierwerte Spannungsmessung eintragen! "));
    Serial.println(" ");
  }
  Serial.flush();
  Serial.println(F("\n----"));
  Serial.println(F(" LED auf SIM800L blinkt?"));
  Serial.println(F("----\n"));
  Serial.println(F(" Weiter mit w"));

  c = '0';
  while (c != 'w') {
    c = Serial.read();
    delay(10);
  }
  Serial.println(F("..."));
  Serial.flush();

  if (dfue.init(5000)) {
    Serial.println(F("SIM800 Init i.O.\n"));
    Serial.flush();
  } else {
    OK = false;
    Serial.println(F("Modul konnte nicht initialisiert werden"));
    Serial.println(F("  Fehler in GSM RX/TX Verbindung ?"));
    Serial.println(F("  Verdrahtung und Akkuspannung kontrollieren\n"));
#if defined(ARDUINO_AVR_PRO)
    Serial.println(F("********************************"));
    Serial.println(F("beelogger_Solar: "));
    Serial.println(F(" Sketchkonfiguration und Pinbelegung beachten "));
    Serial.print(F(" akuelle Sketchkonfiguration: "));
    Serial.print(F(" byte GSM_RX = ")); Serial.println(GSM_RX); Serial.println("");
    Serial.println(F(" byte GSM_RX = 8;  // aktuelle Verdrahtung: Solar Multishield 2.x und Universal"));
    Serial.println(F(" byte GSM_RX = 10; // beelogger Solar, alte Verdrahtung: bitte ändern"));
    Serial.println(F("********************************\n"));
    Serial.println(F(" Weiter mit w"));
    c = '0';
    while (c != 'w') {
      c = Serial.read();
      delay(10);
    }
#endif
    GSM_Abschaltung();
  }

  strcpy_P(parameter, beelogger_pfad);

  p_buf = strstr(parameter, "/beelogger");  // search first /
  n = atoi(p_buf + 10);
  //Serial.println(p_buf + 10);
  if (n == 0) {
    Serial.println(parameter);
    Serial.println(F("\n GSM  Test Sketch nur mit beeloggerX,  X = 1...n"));
    Serial.println(F("keine  DUO, Triple, Quad, usw."));
    Serial.flush();
    OK = false;
    GSM_Abschaltung();
  }

  // Modul vorhanden und antwortet
  if (OK) {
    dfue.sendCommand("AT+IPR=9600");
    dfue.sendCommand("AT&W");

    Serial.println(F("SIM800L Modul Informationen:"));
    Serial.flush();

    dfue.sendCommand("AT+CGMI");
    Serial.println(dfue.buffer);
    Serial.flush();
    dfue.sendCommand("AT+CGMM");
    Serial.println(dfue.buffer);
    Serial.flush();

    dfue.sendCommand("AT+CGMR");   // Firmwareversion
    strcpy(buf, dfue.buffer);
    Serial.println(dfue.buffer);
    Serial.flush();

    delay(5000);  // warte !
    dfue.sendCommand("AT+CBC");  // SIM800 Versorgung
    Serial.println("\n");
    Serial.println(F("SIM800L Versorgung in:  %, milliVolt"));
    Serial.print(F("                       "));
    Serial.println(&dfue.buffer[10]);
    int simVoltage = 0;
    float simVolt;
    char *p = strstr(dfue.buffer, "+CBC");
    if (p) {
      int x = 0;
      do {
        p++; x++;
      } while ( !(*p == '\n') && (x < 18)); // check EOL und Buffer
      simVoltage = atoi(p - 5);
      simVolt = ((float)simVoltage) / 1000.0;
      if (simVoltage < 3930) {
        Serial.print(F("SIM800L Versorgung:  "));
        Serial.print (simVolt);
        Serial.println(F("  Volt"));
        Serial.println(F("kritisch, bitte Spannung prüfen und/oder Akku laden"));
      }
    }
    Serial.println(" ");
    Serial.flush();

    // Prüfe APN Daten
    strcpy_P(parameter, APN);
    Serial.print(F("Verbinde zum Mobilfunknetz "));
    Serial.print(F(" ... "));
    if (strcmp(parameter, "APN") == 0) {
      Serial.println(F(" ... "));
      Serial.println(F("Bitte Provider (APN) konfigurieren!"));
      OK = false;
    }
    else {
      Serial.println(" ");
      Serial.flush();
      delay(3000);
      Serial.println(F("\n einen Moment bitte...\n"));
      delay(10000); // Warte !!

      if (dfue.getOperatorName()) {
        Serial.print(F("Mobilfunkanbieter: "));
        Serial.println(dfue.buffer);
        Serial.println(" ");
        Serial.flush();
      }
      else {
        Serial.println(F("  Provider ? "));
        //OK = false;
      }
    }

    if (OK) {
      signal_strength();
      // starte Verbindung
      Serial.print(F("\nVerbindung zu "));
      Serial.print(parameter);
      Serial.flush();
      int code;
      code = dfue.start(parameter);
      if (code == 0) {
        Serial.println(F("  hergestellt."));
        delay(5000);
        uint8_t lvl;
        lvl = signal_strength();         // Signal
        if (lvl) OK = true;
        Serial.flush();
      }
      else {
        OK = false;
        Serial.println(F("Verbindungsfehler!"));
        if (code == 1) {
          Serial.println(F("Registrieren/Anmelden im GSM Netz nicht möglich!"));
          Serial.println(F("ev. SIM Karte nicht erkannt. Einbaulage prüfen !"));
        }
        else if (code == 2) {
          Serial.println(F("Verbindung zum Datendienst nicht möglich!"));
        }
        else {
          Serial.println(F("Anmelden beim Provider nicht erfolgreich!"));
        }
        Serial.println(dfue.buffer);
        Serial.println(" ");
      }
    }

    // angemeldet, stelle IP her
    if (OK) {
      Serial.println(F("Initialisiere Internetverbindung ... "));
      Serial.flush();

      strcpy_P(parameter, serverName);
      Serial.println(parameter);
      strcpy_P(parameter, beelogger_pfad);
      Serial.println(parameter);
      Serial.flush();
    }
    else {
      GSM_Abschaltung();
    }
  }
}

int count = 0;
//######################################
void loop() {

  if (OK) {
    DatenString_erstellen();

    strcpy_P(parameter, serverName);
    if (dfue.Connect(parameter)) {  // Start TCP Connection
      Serial.println(F("\n\rTCP!"));
      Serial.println(" ");
      Serial.print(F("Daten senden Paket:  "));
      Serial.print(count + 1);
      Serial.println(F("  von 2"));
      Serial.flush();

      if (dfue.prep_send()) {         // Prepare send data

        strcpy_P(parameter, beelogger_pfad);    // GET ....
        dfue.send(parameter);
        Serial.println(parameter);
        Serial.flush();              strcpy_P(parameter, Str_Pw);
        dfue.send(parameter);
        strcpy_P(parameter, Passwort);
        dfue.send(parameter);
        strcpy_P(parameter, Str_Opt);         //
        dfue.send(parameter);
        // System ID
        strcpy_P(parameter, Str_Id);
        dfue.send(parameter);
        strcpy(parameter, ID_ID);
        dfue.send(parameter);

        //Daten
        strcpy_P(parameter, Str_MData);
        dfue.send(parameter);

        dfue.send(DatenString);  // Datensatz
        delay(50);
        Serial.println(DatenString);
        Serial.flush();
        strcpy_P(parameter, Str_Http);
        dfue.send(parameter);
        dfue.send("Host: ");
        strcpy_P(parameter, serverName);
        dfue.send(parameter);
        dfue.send("\r\n");

        strcpy_P(parameter, Str_Con);
        dfue.send(parameter);
        dfue.send(0x00); // Startkommando senden

        if (dfue.sendCommand(0, SERVER_TM_OUT, "200 OK")) { // WLAN und Connect haben geklappt, HTTP Response Kontrolle

          Serial.println(F("HTTP OK"));
          Serial.flush();

          if (dfue.sendCommand(0, SERVER_TM_OUT, "ok *")) { // hat Server Anfrage quittiert ?
            OK = true; // success

            char *p_buf = strstr(dfue.buffer, "ok *");  // search string start
            uint8_t pos = 0;
            *p_buf = 0; //Stringende
            do {
              p_buf --;    // search start of line
              pos++;
            }
            while ( (!(*p_buf == '\n')) && (pos < 20));

            int n;
            if (char *p_bf = strchr(p_buf, 'T') ) {
              n = atoi(p_bf + 1);  // Konvertiere str in int

              char x = *(p_buf + 1);
              if ((x > 0x2F) && (x < 0x3A)) { // first char a number?
                long l_tm = atol(p_buf);
                l_tm = l_tm - 946684800;  // EPOCH_TIME_OFFSET
                rtc.setDateTime(l_tm);
                Serial.println("Uhrzeit in DS3231 gesetzt.  ");
                display_time();
              }
            }
            else {
              n = atoi(p_buf); // Konvertiere str in int
            }
            Serial.print(n);
            Serial.print(F("Quittung: "));
            Serial.println(p_buf);
            Serial.flush();
            display_time();
            Serial.println(F("Test erfolgreich!\n"));
            Serial.flush();
            // Format Quittung aus beelogger-log.php
            // echo "5ok * "  = 5 Minuten
          }
          // received ok *
        }
        // Http OK  0,200 ?
      }
      // prep_send
      dfue.disConnect();
      delay(2000);
      // Abschaltung nach 3 Datenübertragungen
      count++;
      if (count >= 2) {
        Serial.flush();
        OK = false;
        dfue.httpUninit();
        GSM_Abschaltung();
        Serial.println(F("Test beendet"));
        Serial.flush();
      }
      else {
        delay(2000);
        Serial.print(F("Signalstaerke: "));
        delay(1000);
        int Signal = dfue.getSignalQuality();
        Service = (float)Signal;
        Serial.print(Signal);
        Serial.println(F(" dB"));
        delay(2000);
      }
      Serial.println(" ");
      Serial.println(F(" wiederhole Senden in 4 Minuten"));
      Serial.flush();
      for (int i = 0; i < 6 * 4; i++) {
        delay(10000);
        Serial.print(".");
      }
      // Test-Messdaten um 1 erhöhen
      SensorTemp[0] = rtc.getTemperature();
      SensorTemp[1] += 0.3;
      SensorFeuchte[0] ++;
      SensorFeuchte[1] ++;
      Licht += 50.0;
      Gewicht[0] += 0.1;
      Batteriespannung += 0.2;
      Solarspannung += 0.1;
    } // connect
    else {
      OK = false;
      Serial.println(F("Initialisierung fehlgeschlagen\n"));
      Serial.println(dfue.buffer);
      Serial.println(" ");
      Serial.flush();
      GSM_Abschaltung();
    }
  }
}

void GSM_Abschaltung() {
  dfue.stop();        // stop CIP session
  Serial.println(F("Modul wird abgeschaltet\n"));
  Serial.flush();
  dfue.shutdown();
  digitalWrite(Stop_GSM_WLAN, LOW);
  digitalWrite(Power_Pin, LOW);
}

//--------------------------------------------------
uint8_t display_time() {
  uint8_t ok_val = 0;
  DateTime aktuell = rtc.now();
  if ( aktuell.year() > 2100) {
    Serial.print(F("\nUhrbaustein nicht erkannt oder nicht vorhanden \n"));
  }
  else {
    ok_val = 1;
    Serial.print(F("\nDatum und Uhrzeit aktuell im Uhrbaustein: \n"));
    Serial.print(aktuell.date(), DEC);
    Serial.print('.');
    Serial.print(aktuell.month(), DEC);
    Serial.print('.');
    Serial.print(aktuell.year(), DEC);
    Serial.print(' ');
    Serial.print(aktuell.hour(), DEC);
    Serial.print(':');
    Serial.print(aktuell.minute(), DEC);
    Serial.print(':');
    Serial.print(aktuell.second(), DEC);
  }
  Serial.println(" ");
  Serial.flush();
  return (ok_val);
}
//--------------------------------------------------

uint8_t signal_strength() {
  uint8_t lvl_ok = 1;
  char c = 'm';
  int Signal = dfue.getSignalQuality();
  if ((Signal < -80) || (Signal > -10)) {
    Serial.print(F("Signal schwach: "));
    Serial.print(Signal);
    Serial.println(F(" dB\n"));
    Serial.print(F(" Test eventuell nicht erfolgreich durchführbar! "));
    if (Signal < -83) lvl_ok = 0;
    delay(15000);
    Serial.println(F(" Weiter mit w"));
    while (c != 'w') {
      c = Serial.read();
      delay(500);
    }
  }
  else if (Signal) {
    Serial.print(F("Signalstaerke: "));
    Serial.print(Signal);
    Serial.println(F(" dB"));
  }
  else {
    Serial.print(F("\n\n Fehler bei Abfrage Signalstärke\n\n"));
    lvl_ok = 0;
    delay(15000);
    Serial.println(F(" Weiter mit w"));
    while (c != 'w') {
      c = Serial.read();
      delay(500);
    }
  }
  Serial.flush();
  return (lvl_ok);
}

//--------------------------------------------------
void Spannungen_messen() {
  Batteriespannung = Messe_Spannung(Batterie_messen);
  Serial.print(F(" Batterie [V]: "));
  Serial.println(Batteriespannung);
  Serial.println(" ");
  Serial.flush();
  /*
    if (Batteriespannung > VMinimum) {
    Solarspannung = Messe_Spannung(Solarzelle_messen);
    Serial.print(F(" Solarspannung [V]: "));
    Serial.println(Solarspannung);
    Serial.println();
    Serial.flush();
    }
  */
}

float Messe_Spannung (byte Pin) {
  int Messung_Spannung;
  float Spannung;
  Messung_Spannung = analogRead(Pin);
  Messung_Spannung = 0;
  for (byte j = 0 ; j < 16; j++) {
    Messung_Spannung += analogRead(Pin);
  }
  Messung_Spannung = Messung_Spannung >> 2;
  Serial.print(F("\nADC - Bitwert = "));  Serial.print(Messung_Spannung); Serial.println();
  Spannung = (float)map(Messung_Spannung, 0, Kalib_Bitwert, 0, Kalib_Spannung) / 1000.0;
  return (Spannung);
}

/**
  @brief Funktion DatenString_erstellen()
  erstellt konfigurationsabhängigen Datensatz zum abspeichern im EE-Prom

  @param  none,        globale Variablen
  @return  none
*/
void DatenString_erstellen() {

  int count = 0;
  DateTime jetzt = rtc.now();
  count = sprintf(DatenString, "%d/", jetzt.year());
  count += sprintf(DatenString + count, "%2.2d/", jetzt.month());
  count += sprintf(DatenString + count, "%2.2d_", jetzt.date());
  count += sprintf(DatenString + count, "%2.2d:", jetzt.hour());
  count += sprintf(DatenString + count, "%2.2d:", jetzt.minute());
  count += sprintf(DatenString + count, "%2.2d",  jetzt.second());

  count = Wert_hinzufuegen(count, SensorTemp[Beute1], 1, No_Val);    // Stocktemperatur 1
  count = Wert_hinzufuegen(count, SensorTemp[Aussenwerte], 1, No_Val);     // Außentemperatur
  count = Wert_hinzufuegen(count, SensorFeuchte[Beute1], 1, No_Value);     // Stockluftfeuchte 1
  count = Wert_hinzufuegen(count, SensorFeuchte[Aussenwerte], 1, No_Value);  // Außenluftfeuchte
  count = Wert_hinzufuegen(count, Licht, 1, No_Value);                 // Licht
  count = Wert_hinzufuegen(count, Gewicht[0], 2, No_Value);            // Gewicht 1

  count = Wert_hinzufuegen(count, Batteriespannung, 2, No_Value); // Akkuspannung
  count = Wert_hinzufuegen(count, Solarspannung, 2, No_Value);    // Solarspannung
  count = Wert_hinzufuegen(count, Service, 2, No_Value);    // Service
  count = Wert_hinzufuegen(count, Aux[1], 1, No_Value);  // Aux 1
  count = Wert_hinzufuegen(count, Aux[2], 2, No_Value);  // Aux 2
  count = Wert_hinzufuegen(count, Aux[0], 2, No_Value);  // Aux 0
  DatenString[count] = 0;
}


/**
  @brief Funktion Wert_hinzufuegen()
  erstellt Stringanteil für Datensatz

  @param
  count: aktuelle Position im String,
  Wert: Messwert,
  Nachkommastellen: Anzahl der Nachkommastellen für diesen Messwert
  Fehler: Vergleichswert für fehlerhaften oder unbenutzten Messwert
  @return  neue Position im Datenstring
*/
int Wert_hinzufuegen(int count, float Wert, uint8_t Nachkommastellen, float Fehler) {
  char Konvertierung[16];
  int count_neu = count;

  if (Wert == Fehler) {
    count_neu += sprintf(DatenString + count, ",%s", "");
  } else {
    dtostrf(Wert, 1, Nachkommastellen, Konvertierung);
    count_neu += sprintf(DatenString + count, ",%s", Konvertierung);
  }
  return count_neu;
}
//--------------------------------------------------

// EE-Prom functions
uint8_t EE_WriteMem(int iAddr, const char *pBuf, int iCnt)
{
  uint8_t iBytes, iRC = 0;
  // Writes are restricted to a single 32 byte page.  Therefore. if a write spans a page
  // boundry we must split the write.
  while (iCnt > 0) {
    iBytes = min(iCnt, BUFFER_LENGTH - 2);
    int iCurPage = iAddr & ~((int)0x1f);
    if (iAddr + iBytes > iCurPage + 32) { // Number of bytes is too large
      iBytes = (iCurPage + 32) - iAddr;
    }
    Wire.beginTransmission(_EEProm_adress);
    Wire.write( highByte(iAddr) ); // Address MSB
    Wire.write( lowByte(iAddr) );  // Address LSB
    Wire.write((uint8_t*)pBuf, iBytes);
    Wire.endTransmission();
    iRC  += (int)iBytes;
    iCnt -= (int)iBytes;
    iAddr += (int)iBytes;
    pBuf += (int)iBytes;
    delay(10); // delay(50);  // Give the EEPROM time to write its data
  }  /* while */
  delay(20);
  return (iRC);
}

uint8_t EE_ReadStr(int iAddr, char Buf[], int iCnt) {
  uint8_t iRead = 0, iBytes;
  char c;
  while (iCnt > 0) {
    Wire.beginTransmission(_EEProm_adress);
    Wire.write(iAddr >> 8); // Address MSB
    Wire.write(iAddr & 0xff); // Address LSB
    Wire.endTransmission();
    iBytes = min(iCnt, 128);
    Wire.requestFrom(_EEProm_adress, iBytes);
    while (Wire.available() && iCnt > 0) {
      c = Wire.read();
      Buf[iRead] = c;
      if (c == '\0') {
        iCnt = 0; break;
      }  /* if */
      iRead++; iCnt--; iAddr++;
    }  /* while */
  }
  return (iRead);
}
