//----------------------------------------------------------------
// Funktion BME680
//----------------------------------------------------------------
// Lib ClosedCube_BME680.h"  small code but bad results
//----------------------------------------------------------------

//----------------------------------------------------------------
#if (Test_SD_Card) || (_BME680_ == 0)

void Sensor_BME680(uint8_t addr) {
  Serial.println(F("not testing BME 680"));
}

#else

#include "Zanshin_BME680.h"
void Sensor_BME680(uint8_t addr) {

  int32_t  temp, humidity, pressure, gas;  // BME readings
  uint8_t check;
  uint8_t t_try = 0;

  BME680_Class BME680;  ///< Create an instance of the BME680 class
  Serial.println(F("BME680"));
  do {
    check = BME680.begin(I2C_STANDARD_MODE, addr);
    t_try++;
    delay(2000);
  }
  while ((check == 0) && (t_try < 3)); // start BME680 using I2C

  if (check) {
    //("- Setting 16x oversampling for all sensors\n"));
    BME680.setOversampling(TemperatureSensor, Oversample16);  // Use enumerated type values
    BME680.setOversampling(HumiditySensor, Oversample16);     // Use enumerated type values
    BME680.setOversampling(PressureSensor, Oversample16);     // Use enumerated type values
    /*
       After the measurement period, the pressure and temperature data can be passed through an optional IIR filter,
       which removes short-term fluctuations in pressure (e.g. caused by slamming a door).
       For humidity and gas, such a filter is not needed and has not been implemented
    */
    //("- Setting IIR filter to a value of 4 samples\n"));
    //BME680.setIIRFilter(IIR4); // Use enumerated type values

    //("- Setting gas measurement to 320\xC2\xB0\x43 for 150ms\n"));  // "°C" symbols
    BME680.setGas(320, 150);  // 320°c for 150 milliseconds

    BME680.getSensorData(temp, humidity, pressure, gas);  // Get readings
    delay(2000);
    BME680.getSensorData(temp, humidity, pressure, gas);  // Get readings


    float f_temp_C = (float)temp / 100.0;
    float f_hum  = (float)humidity / 100.0;
    float f_baro_HPA = (float)pressure / 1000.0;
    float f_gas  = (float)gas / 100.0;

    Serial.print(s_temp);
    Serial.println(f_temp_C);
    Serial.print(s_hum);
    Serial.println(f_hum);
    Serial.print(s_press);
    Serial.println(f_baro_HPA);
    Serial.print(F(" gas [mOhm]: "));
    Serial.println(f_gas);
  }
  Wire.end();

  Serial.flush();
}
#endif
//----------------------------------------------------------------
