//----------------------------------------------------------------
// DHT OneWire
//----------------------------------------------------------------

#include <beelogger_DHT.h>

void Sensor_DHT() {
  float Temperatur_DHT;
  float Luftfeuchte_DHT;

  Serial.println("DHT 22:\n");
  Serial.flush();

  for (uint8_t i = 0; i < 2; i++) {

    Temperatur_DHT = No_Val;
    beelogger_DHT beeDHT(DHT_Sensor_Pin[i], DHT22);
    beeDHT.begin();
    Serial.print("DHT at pin: D");
    Serial.println(DHT_Sensor_Pin[i]);
    Serial.flush();

    uint8_t x = 3;
    do {
      delay(2000);     // Wait a few seconds between measurements.
      Temperatur_DHT = beeDHT.readTemperature();    // Read temperature as Celsius (the default)
      Luftfeuchte_DHT = beeDHT.readHumidity();

      x--;
      if (x == 0) break;
      Serial.print("*");
    } while (((Temperatur_DHT == 1.0) && (Luftfeuchte_DHT == 1.0)) ||
             (Temperatur_DHT < -30.0) || (Luftfeuchte_DHT == 0.0));

    pinMode (DHT_Sensor_Pin[i], INPUT);  // pwrsave

    // Check if any reads failed
    if (isnan(Temperatur_DHT) || (Temperatur_DHT < -30.0) || (Temperatur_DHT > 60.0)) Temperatur_DHT = No_Val;
    if (isnan(Luftfeuchte_DHT) || (Luftfeuchte_DHT < 2.0) || (Luftfeuchte_DHT >= 99.9)) Luftfeuchte_DHT = No_Value;

    if (Temperatur_DHT == No_Val) {
      Serial.println(F("  DHT not found or not installed."));
    }
    else {
      Serial.print(s_temp);
      Serial.println(Temperatur_DHT);
      Serial.print(s_hum);
      Serial.println(Luftfeuchte_DHT);
    }
  }
  Serial.print("\n");
  Serial.flush();
}
//--------------------------------------------------------------
