//----------------------------------------------------------------
// EE-Prom
//----------------------------------------------------------------
#include <beelogger_at24cxx.h>

void test_EE(uint8_t addr) {

  Serial.println("EE-Prom");

  AT24Cxx my_EEPROM(addr);
  if (my_EEPROM.isPresent() == 0) {  // testing
    char mybuffer[16];
    char mybuff[16];
    long i = 0, m;
    Serial.print(" is present at: 0x");
    Serial.println(addr, HEX);

    //Serial.print("\n  ");
    my_EEPROM.WriteStr(0, "Test!");  // data to compare
    // EE-Prom data pointer wraps around, when size exceeded
    // data at "0" is overwritten
    do {
      if ((i % 4) == 0) {
        Serial.print((i + 4) / 4);
        Serial.print(", ");
      }
      i++;
      ltoa(i, mybuffer, 10);
      my_EEPROM.WriteStr(i * 256, mybuffer); // write data
      my_EEPROM.ReadStr(i * 256, mybuff, 8); // read to verify
      if (strcmp(mybuff, mybuffer) == 0) {
        my_EEPROM.ReadStr(0, mybuff, 8);     // reading at "0"
      }
    } while (strcmp("Test!", mybuff) == 0);  // not yet overwritten?
    Wire.end();
    //Serial.println(" ");
    Serial.print("\n    EE-Prom: ");
    if (i < 5)  Serial.println(" ************** Fehler");
    else {
      m = i * 256 / 1024;
      Serial.print(m);
      Serial.println(" kByte");
    }
    my_EEPROM.WriteMem(4094, 0); // erase counters
    my_EEPROM.WriteMem(4095, 0); //
    my_EEPROM.WriteMem(8190, 0); //
    my_EEPROM.WriteMem(8191, 0); //
    my_EEPROM.WriteMem(16382, 0); //
    my_EEPROM.WriteMem(16383, 0); //
    my_EEPROM.WriteMem(32766, 0); //
    my_EEPROM.WriteMem(32767, 0); //


    Serial.flush();
  }
  else {
    Serial.print("  not found at:");
    Serial.print(addr);
  }
  Wire.end();
  Serial.println(" ");
  Serial.flush();
}

//----------------------------------------------------------------
