//----------------------------------------------------------------
// HX711
//----------------------------------------------------------------
#include <HX711.h>

void Sensor_HX711() {
  unsigned long val;

  Serial.print(F("\nHX711 Nummer 1:"));
  Serial.flush();
  HX711 scale;
  scale.begin(HX711_DT[0], HX711_SCK[0], 128); // Nr.1 channel A
  scale.power_up();
  val = 0xFFFFFFFF;
  if (scale.wait_ready_retry(3, 500)) {
    scale.read();
    val = scale.read_average(10);
  }
  if (val != 0xFFFFFFFF) {
    Serial.println(F(" found."));
    Serial.print("  databits: ");
    Serial.flush();
    Serial.println(val, HEX);
  }
  else {
    Serial.println(F(" not found or defect!"));
    Serial.println(F(" please check wiring."));
  }
  scale.power_down();
  Serial.flush();

  Serial.print(F("\nHX711 Nummer 2:"));
  Serial.flush();
  scale.begin(HX711_DT[1], HX711_SCK[1], 128); // Nr.2 channel A
  scale.power_up();
  val = 0xFFFFFFFF;
  if (scale.wait_ready_retry(3, 500)) {
    scale.read();
    val = scale.read_average(10);
  }
  if (val != 0xFFFFFFFF) {
    Serial.println(F(" found."));
    Serial.print("  databits: ");
    Serial.flush();
    Serial.println(val, HEX);
  }
  else {
    Serial.println(F(" not found or defect!"));
    Serial.println(F(" please check wiring."));
  }
  scale.power_down();
  Serial.println(" ");
  Serial.flush();

}
