//----------------------------------------------------------------
// Test I2C devices found
//----------------------------------------------------------------
void test_i2c_devices() {

  uint8_t cnt = 0;

  Wire.begin();
  Wire.setClock(100000);

  while ((  i2c_device[cnt] != 0) && (cnt < 16)) {

    switch (i2c_device[cnt]) {
      case 0x20:
      case 0x21:
      case 0x22:
        Serial.println(" MCP23017   check adress?");
        break;

      case 0x24:
      case 0x25:
      case 0x26:
      case 0x27:
        Serial.println(" MCP23017     found.");
        break;

      case 0x5C:
      case 0x23:
        if (i2c_device[cnt] == 0x5C) Serial.println(" alternativ adress:");
        Sensor_Licht(i2c_device[cnt]);
        break;
      case 0x40:
        Sensor_Si7021();
        break;
      case 0x44:
      case 0x45:
        Sensor_SHT31(i2c_device[cnt]);
        break;
      case 0x50:
      case 0x51:
      case 0x52:
      case 0x53:
      case 0x54:
      case 0x55:
      case 0x56:
      case 0x57:
        test_EE(i2c_device[cnt]);
        break;
      case 0x68:
        System_with_DS3231 = 1;
        DS3231_test();
        break;
      case 0x76:
      case 0x77:
        Sensor_BME280(i2c_device[cnt]);
        Sensor_BMP280(i2c_device[cnt]);
        Sensor_BME680(i2c_device[cnt]);
        break;
      default:
        Serial.print(" no test available for 0x");
        Serial.println(i2c_device[cnt], HEX);
        break;
    }
    cnt++;
  }
  Wire.end();
}
