

//#define UNI_2X  // Universal Platine Version 2.x // am Zeilenanfang entfernen


#include <OneWire.h>
#include <DallasTemperature.h>

/****************************************************************/
// Konfiguration One-Wire-Bus für DS18B20
// Regenmesser verwendet Pin 3, dann DS18B20 auf Pin 6
/****************************************************************/
#if  (Anzahl_Sensor_Regen) || (defined (UNI_2X))
#define ONE_WIRE_BUS 6
#else
#define ONE_WIRE_BUS 3
#endif

#define Power_Pin 4
#define TEMPERATURE_PRECISION 12 // Lower resolution

// Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
OneWire oneWire(ONE_WIRE_BUS);

// Pass our oneWire reference to Dallas Temperature.
DallasTemperature sensors(&oneWire);

int numberOfDevices; // Number of temperature devices found

DeviceAddress tempDeviceAddress; // We'll use this variable to store a found device address

void setup(void)
{

  digitalWrite(Power_Pin, HIGH);     // Power On
  pinMode(Power_Pin, OUTPUT);
  delay(5);

  // start serial port
  Serial.begin(9600);
  delay(500);
  Serial.println("Dallas Temperature IC Control Library Demo");
  Serial.println(" ");
#if defined (ARDUINO_AVR_NANO_EVERY)
  Serial.println(F(" beelogger-Universal mit Arduino Nano EVERY "));
#endif
#if defined(ARDUINO_AVR_NANO)
  Serial.println(F(" beelogger-Universal mit Arduino Nano  "));
#else
#if defined(ARDUINO_AVR_PRO)// Pro Mini
#if defined (UNI_2X)
  Serial.println(F(" beelogger-Universal Platine 2.x"));
#endif
#if (F_CPU==16000000L)     // 5V 16MHz
  Serial.print(F(" beelogger-Universal  mit Arduino Pro-Mini  "));
  Serial.println(F(" 5V / 16MHz  "));
#else
  Serial.print(F(" beelogger-SMD  mit Arduino Pro-Mini  "));
  Serial.println(F(" 3,3V / 8MHz  "));
#endif
#endif
#endif

  // Start up the library
  sensors.begin();

  // Grab a count of devices on the wire
  numberOfDevices = sensors.getDeviceCount();

  // locate devices on the bus
  Serial.print("Locating devices...");

  Serial.print("Found ");
  Serial.print(numberOfDevices, DEC);
  Serial.println(" devices.");

  // report parasite power requirements
  Serial.print("Parasite power is: ");
  if (sensors.isParasitePowerMode()) Serial.println("ON");
  else Serial.println("OFF");

  // Loop through each device, print out address
  for (int i = 0; i < numberOfDevices; i++)
  {
    // Search the wire for address
    if (sensors.getAddress(tempDeviceAddress, i))
    {
      Serial.print("Found device ");
      Serial.print(i, DEC);
      Serial.print(" with address: ");
      printAddress(tempDeviceAddress);
      Serial.println();

      Serial.print("Setting resolution to ");
      Serial.println(TEMPERATURE_PRECISION, DEC);

      // set the resolution to TEMPERATURE_PRECISION bit (Each Dallas/Maxim device is capable of several different resolutions)
      sensors.setResolution(tempDeviceAddress, TEMPERATURE_PRECISION);

      Serial.print("Resolution actually set to: ");
      Serial.print(sensors.getResolution(tempDeviceAddress), DEC);
      Serial.println();
    } else {
      Serial.print("Found ghost device at ");
      Serial.print(i, DEC);
      Serial.print(" but could not detect address. Check power and cabling");
    }
  }

}

// function to print the temperature for a device
void printTemperature(DeviceAddress deviceAddress)
{
  // method 1 - slower
  //Serial.print("Temp C: ");
  //Serial.print(sensors.getTempC(deviceAddress));
  //Serial.print(" Temp F: ");
  //Serial.print(sensors.getTempF(deviceAddress)); // Makes a second call to getTempC and then converts to Fahrenheit

  // method 2 - faster
  float tempC = sensors.getTempC(deviceAddress);
  Serial.print("Temp C: ");
  Serial.print(tempC);
  Serial.print(" Temp F: ");
  Serial.println(DallasTemperature::toFahrenheit(tempC)); // Converts tempC to Fahrenheit
}

void loop(void)
{
  delay(5000);
  // call sensors.requestTemperatures() to issue a global temperature
  // request to all devices on the bus
  Serial.print("Requesting temperatures...");
  sensors.requestTemperatures(); // Send the command to get temperatures
  Serial.println("DONE");


  // Loop through each device, print out temperature data
  for (int i = 0; i < numberOfDevices; i++)
  {
    // Search the wire for address
    if (sensors.getAddress(tempDeviceAddress, i))
    {
      // Output the device ID
      Serial.print("Temperature for device: ");
      Serial.println(i, DEC);

      // It responds almost immediately. Let's print out the data
      printTemperature(tempDeviceAddress); // Use a simple function to print out the data
    }
    //else ghost device! Check your power requirements and cabling

  }
}

// function to print a device address
void printAddress(DeviceAddress deviceAddress)
{
  for (uint8_t i = 0; i < 8; i++)
  {
    if (deviceAddress[i] < 16) Serial.print("0");
    Serial.print(deviceAddress[i], HEX);
  }
}
