/*
   (C) 2018 Thorsten Gurzan - beelogger.de

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de


#include <Wire.h>
#include <AS_BH1750.h>

AS_BH1750 sensor;

#define Anzahl_Sensoren_Licht  1 // Anzahl der angeschlossenen Sensoren - Mögliche Werte: '0','1'

float Licht = -1.0;

// Für beelogger-Solar: Aktivierung der Stromversorgung für Sensoren, Module und DS3231
#ifdef ARDUINO_ARCH_AVR
#define Power_Pin 4

#else
#define Power_Pin PB5          //  for STM32Fxyz
#endif


void setup() {
  Serial.begin(9600);
  while (!Serial) {};
  Serial.println("BH1750 Test 11.03.2022");
  Serial.println(" ");
  digitalWrite(Power_Pin, HIGH);
  pinMode(Power_Pin, OUTPUT);
  delay(1000);

  if (Anzahl_Sensoren_Licht == 1) {
    if (sensor.begin()) {
      Serial.println("Sensor initialisiert");
    }
    else {
      Serial.println("Initialisierung Sensor fehlgeschlagen");
    }
  }
  Serial.println(" ");
}


void loop() {
  if (Anzahl_Sensoren_Licht == 1) {
    Licht = sensor.readLightLevel();
    if (Licht < 0) Serial.println("Fehler");
    else {
      Serial.print("Beleuchtungsstaerke: ");
      Serial.print(Licht);
      Serial.println(" lx");
    }
    delay(1000);
  }
}
