/*
   (C) 2023 R.Schick - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de

//----------------------------------------------------------------
// Konfiguration
//----------------------------------------------------------------

#define Test_Niederschlagsmesser    0    // 0 = aus,  1= An

#define Test_EE_Prom        0    // 0 = aus,  1= An

// #define UNI_2X  // Universal Platine Version 2.x // am Zeilenanfang entfernen
//----------------------------------------------------------------
// Ende Konfiguration
//----------------------------------------------------------------


#include "Wire.h"
#include <LowPower.h>

#define Rain_Interrupt_Pin  3  // D3 = Interrupt Pin

#define Power_Pin 4
#define Stop_GSM_WLAN A2

#if (defined(ARDUINO_AVR_PRO) && (F_CPU==16000000L) && (not defined UNI_2X)) // Pro Mini 5V 16MHz Universal 1.x  
#undef Stop_GSM_WLAN
#define Stop_GSM_WLAN 12
#endif
#endif
#endif

volatile byte  Rain_Counter = 0;
volatile unsigned long alteZeit = 0, entprellZeit = 20;

void setup(void) {

  Serial.begin(9600);
  while (!Serial) {};
  Serial.println(F("EE-Prom / Niederschlagsmesser  Test   Version 08.12.2023"));
  Serial.println(" ");
  Serial.flush();
  
  digitalWrite(Stop_GSM_WLAN, LOW);  // On hold
  pinMode(Stop_GSM_WLAN, OUTPUT);
  delay(5);

  digitalWrite(Power_Pin, HIGH);
  pinMode(Power_Pin, OUTPUT);
  delay(5);

  char c = 'm';
  if (!Test_EE_Prom) {
    Serial.println( " EE-Prom Test mit '1' und 'Enter' starten!");
    Serial.println( " Eingabe von 'x':   kein EE-Prom-Test.");
    Serial.flush();
    while ((c != '1') && (c != 'x')) {
      c = Serial.read();
    };
  }
  if ((Test_EE_Prom) || (c == '1')) {
    test_EE();
  }
  else {
    Serial.println(" ");
    Serial.println("EE-Prom nicht getestet");
    Serial.println(" ");
    Serial.flush();
  }


  TWCR &= ~(bit(TWEN) | bit(TWIE) | bit(TWEA));
  digitalWrite (A4, LOW);
  digitalWrite (A5, LOW);

  Serial.println("Power-Off");
  Serial.println(" ");
  Serial.flush();
  digitalWrite(Power_Pin, LOW);


  if (Test_Niederschlagsmesser)  {
    pinMode(Rain_Interrupt_Pin, INPUT_PULLUP);
    delay(500);
    if (digitalRead(Rain_Interrupt_Pin) == 0) {
      Serial.println("kein Signal am Interrupt Pin oder Kontakt Niederschlagsmesser geschlossen");
      Serial.println(" ");
      Serial.flush();
    }
    alteZeit = millis();
    attachInterrupt(digitalPinToInterrupt(Rain_Interrupt_Pin), Rain_Cnt, FALLING);  // D3 = Interrupt
  }
  else {
    Serial.println(" ");
    Serial.println("Test Niederschlagsmesser in der Sketch-Konfiguration nicht aktiviert");
    Serial.println(" ");
    Serial.flush();
  }

}

//#################################################
void loop(void) {

  if (Test_Niederschlagsmesser)  {
    Serial.println("Test Niederschlagsmesser:");
    Serial.println("  warte auf Signal / Interrupt: ");
    Serial.flush();
    do {

      LowPower.powerDown(SLEEP_FOREVER, ADC_OFF, BOD_OFF);
      delay(100);
      Serial.print("Zähler Niederschlagsmesser: ");
      Serial.println(Rain_Counter);
      Serial.flush();


    } while (1 == 1);
  }
  else {
    Serial.println("Sleep forever! ");
    Serial.flush();
    LowPower.powerDown(SLEEP_FOREVER, ADC_OFF, BOD_OFF);
  }
}
//#################################################


//----------------------------------------------------------------
// Funktion Rain_Cnt Interrupt Handler
//----------------------------------------------------------------
void Rain_Cnt() { // D3 = Interrupt
  // innerhalb der entprellZeit nichts machen
  if ((millis() - alteZeit) > entprellZeit) {
    Rain_Counter++;
    alteZeit = millis(); // letzte Schaltzeit merken
  }
}
//----------------------------------------------------------------

//----------------------------------------------------------------
// EE-Prom
//----------------------------------------------------------------
#include <beelogger_at24cxx.h>

void test_EE() {
  Serial.println(" EE-Prom Test: ");
  Serial.println(" ");

  AT24Cxx my_EEPROM(0x53);
  if (my_EEPROM.isPresent() == 0) {
    Serial.print(" EE-Prom at: 0x53");
    eeprom_test(0x53);
  }
  else {
    AT24Cxx my_EEPROM(0x57);
    if (my_EEPROM.isPresent() == 0) {
      Serial.print(" EE-Prom at: 0x57");
      eeprom_test(0x57);
    }
    else {
      Serial.print(" EE-Prom not found at: 0x53 / 0x57");
    }
  }
  Serial.println(" ");
  Serial.println(" ");
  Serial.flush();
}

void eeprom_test(byte nmr) {
  char mybuffer[32];
  char mybuff[32];
  long i = 0, m;
  Serial.print("\n  ");
  AT24Cxx my_EEPROM(nmr);
  my_EEPROM.WriteStr(0, "Test!");
  do {
    if ((i % 4) == 0) {
      Serial.print((i + 4) / 4);
      Serial.print(", ");
    }
    i++;
    ltoa(i, mybuffer, 10);
    my_EEPROM.WriteStr(i * 256, mybuffer);
    ltoa(i - 1, mybuffer, 10);
    my_EEPROM.ReadStr(0, mybuff, 15);
  } while (strcmp("Test!", mybuff) == 0);
  Serial.println(" ");
  Serial.print(" EE-Prom: ");
  m = i * 256 / 1024;
  Serial.print(m);
  Serial.println(" kByte");
  Serial.flush();
}
//----------------------------------------------------------------
