/****************************************************************/
// Funktion SIM7600E - Mobilfunk  TCP / SSL-Send  EE-Prom
/****************************************************************/
// 29.07.2020 SIM7600
// 07.08.2020 EE-Prom Checksumme
// 18.08.2020 Debug Ausgabe optimiert
// 03.12.2020 Sendezyklen konfigurierbar
// 08.01.2021 Debug Info
// 19.03.2021 String handling
// 03.05.2021 EE-Prom-only
// 25.05.2021 EE-Prom error handling
// 12.11.2021 Close Session optimized
// 28.11.2021 Debug Messages
// 28.03.2022 Pegelmessung
// 07.04.2023 modify Http calls
// 07.02.2024 Datenstring Signalpegel
// 08.02.2024 wait a sec before sending next data
// 14.07.2024 Mx-Strings
// 18.07.2024 Use EE-Prom 'round robin'
// 10.01.2025 add debugflush
// 12.01.2025 Send A=1 obsolete
// 22.08.2025 Anpassung für SNI-Mode
// 30.11.2025 Watchdog EE-Prom lesen


#if (_LTE_TLS == 1)

#define NUM_RETRY 3

/****************************************************************/
// Kommunikation SIM7600E - Mobilfunk
/****************************************************************/
#include "src/SIM7600_beelogger.h"

#define SERVER_TM_OUT 10000  // 10000 = 10 sec
/****************************************************************/


/****************************************************************/
// Parameter Datenversand via Http // diese nicht modifizieren
/****************************************************************/
const char Str_Pw[] PROGMEM = { "PW=" };
const char Str_Id[] PROGMEM = { "&Z=2&ID=" };
#if (Anzahl_Sensoren_Gewicht == 1)
const char Str_MData[] PROGMEM = { "&M1=" };  // Parameter Multi Data  Senden
#endif
#if (Anzahl_Sensoren_Gewicht == 2)
const char Str_MData[] PROGMEM = { "&M2=" };  // Parameter Multi Data  Senden
#endif
#if (Anzahl_Sensoren_Gewicht == 3)
const char Str_MData[] PROGMEM = { "&M3=" };  // Parameter Multi Data  Senden
#endif
#if (Anzahl_Sensoren_Gewicht == 4)
const char Str_MData[] PROGMEM = { "&M4=" };  // Parameter Multi Data  Senden
#endif
const char STR_CON[] PROGMEM = { "Connection: keep-alive\r\n" };
/****************************************************************/

/**
  @brief Utility functions
  stop_DFUe_device(): SIM7600E Reset aktiv oder Power inaktiv
  dfue_rxtx_off():  Serial TX/RX dfiniert setzen

  @param  none, globale Variablen
  @return  none
*/
void stop_DFUe_device() {
  digitalWrite(GSM_Power_Pin, LOW);  // SIM7600E-Modul "off" or Reset
  pinMode(GSM_Power_Pin, OUTPUT);
}

void dfue_rxtx_off() {
  digitalWrite(GSM_RX, LOW);
  digitalWrite(GSM_TX, LOW);
}


/**
  @brief Funktion SIM7600E Send_Data()
  initialisiere SIM7600E, vebinde ins Mobilfunknetz
  verbinde zum Server, lese Daten aus EE-Prom,
  übertrage Daten, Server-Quittung auswerten
  Fehlerbehandlung bei der Übertragung
  Setze aus Serverquittung:
  - Zeit in DS3231
  - Messintervall
  - Sendeintervall

  @param  count:: Anzahl Datensätze zu übertragen, globale Variablen
  @return  senden erfolgreich > 0
*/
uint8_t Send_Data(uint8_t count) {
  char parameter[64];
  uint8_t s_cnt = 0;  // send counter
  uint8_t additional_Data = 0;
  //float ServiceX = No_Value;

  uint8_t x, y;  // Datensatz zaehler

  uint8_t sum, test, first;  // EE-Prom Checksumme
  char chk[2];

  uint16_t pos;
  uint8_t data_send;  // send status
  uint8_t retry;      // retry counter

  CGPRS_SIM7600 dfue;

  debugprintlnF("LTEon");
  debugflush();

  digitalWrite(GSM_Power_Pin, HIGH);

  if (dfue.init()) {  // Init SIM7600 Modul

#if SET_LTE_ONLY == 1
    dfue.sendCommand("AT&F");
    dfue.sendCommand("AT+CNMP=38");
#endif
#if SET_LTE_ONLY == 2
    dfue.sendCommand("AT&F");
    dfue.sendCommand("AT+CNMP=2");
#endif

#if SET_LTE_ONLY == 3
    dfue.sendCommand("AT+CGDCONT=1,\"IP\",\"\"");
#endif

    strcpy_P(parameter, APN);
    debugprintln(parameter);
    debugflush();

    if (dfue.start_TLS(parameter, APN_Benutzer, APN_Passwort) == 0) {  // Start dfue Connection

      if (dfue.ssl_init()) {  // Init SSL

#if SNI_ACTIVE
        dfue.sendCommand("AT+CSSLCFG=\"enableSNI\",0,1");  // 0,1 -> SNI enable; 0,0 ->SNI-disable
#endif

        if (dfue.ssl_start()) {  // Start SSL
          debugprintlnF("SSL!");
          debugflush();

          if (Service < 90.0) {      // if user action, force time_on
            if (report_info == 1) {  // pegelmessung
              calldelay(3000);       // 28.03.2022

              int Signal = dfue.getSignalQuality();
              Service = (float)Signal;
              additional_Data = 1;

              debugprint(Signal);
              debugprintlnF(" dBm");
              debugflush();
            }
          }
          //#################
          data_send = 0;  // send status
          retry = 0;      // retry counter
          do {            // retry loop
            do {          // Blockweise send loop
              data_send = 0;
              // always new connect; session alive not supported by server

              strcpy_P(parameter, serverName);
              debugprintln(parameter);
              debugflush();
              if (dfue.ssl_open(parameter)) {  // Open Server connection
                calldelay(50);
                strcpy_P(parameter, beelogger_pfad);  // GET ....
                debugxprintln(".");
                debugprint(parameter);
                debugflush();
                dfue.ssl_data(parameter);
                strcpy_P(parameter, Str_Pw);
                dfue.ssl_data(parameter);
                strcpy_P(parameter, Passwort);
                dfue.ssl_data(parameter);
                // System ID, options
                strcpy_P(parameter, Str_Id);
                debugprint(parameter);
                debugflush();
                dfue.ssl_data(parameter);
                strcpy(parameter, ID_ID);
                debugprintln(parameter);
                debugflush();
                dfue.ssl_data(parameter);
                calldelay(50);

                //Daten
                wdt_enable(WDTO_4S);
                y = 0;
                first = 1;
                do {
                  // lese von AT24Cxx
                  test = 0;
                  do {
                    pos = data_start + (uint16_t)(s_cnt + y);
                    if (pos >= _EE_DATA_SETS) pos -= _EE_DATA_SETS;
                    pos *= _Daten_Satz_Len;
                    my_EEPROM.ReadStr(pos, DatenString, _Daten_Satz_Len - 2);
                    DatenString[(_Daten_Satz_Len - 2)] = 0;  // String ende erzwingen
                    sum = 0;
                    for (x = 0; x < strlen(DatenString); x++) {  // EE_Prom Checksum test
                      sum += DatenString[x];
                    }
                    pos = pos + _Daten_Satz_Len - 1;
                    my_EEPROM.ReadStr(pos, chk, 1);
                    x = (uint8_t)chk[0];
                    test++;
                  } while ((test < 2) && (sum != x));  // zwei Leseversuche

                  if (sum == x) {      // checksumme i.o.
                    if (first == 1) {  // Multi Type
                      first = 0;
                      strcpy_P(parameter, Str_MData);
                      debugprint(parameter);
                      debugflush();
                      dfue.ssl_data(parameter);
                      calldelay(50);
                    } else {  // einfügen Satztrenner
                      dfue.ssl_data(",");
                    }
                    debugprintln(DatenString);
                    debugflush();
                    dfue.ssl_data(DatenString);  // Datensatz
                    calldelay(100);
                  } else {  // Datensatz auslassen
                    DatenString[0] = 0;
                    debugprintF("EE?");
                    debugprintln(pos);
                    debugflush();
                  }
                  y++;

                } while ((y < _Send_Sets) && ((s_cnt + y) < count));
                wdt_disable();
                if ((additional_Data && ((s_cnt + y) == count)) || (Service == 99.0)) {  // all done, Service ?
                  char service_data[16];
                  dtostrf(Service, 1, 1, service_data);
                  sprintf(DatenString, "&S=%s", service_data);
                  debugprintln(DatenString);
                  debugflush();
                  dfue.ssl_data(DatenString);
                  calldelay(50);
                }
                calldelay(50);
                // ende Daten
                dfue.ssl_data(" HTTP/1.1\r\n");  // HTTP/1.1
                dfue.ssl_data("Host: ");
                debugxprint(" HTTP/1.1\r\nHost: ");
                debugxflush();
                strcpy_P(parameter, serverName);
                dfue.ssl_data(parameter);
                debugxprintln(parameter);
                debugxflush();
                dfue.ssl_data("\r\n");
                strcpy_P(parameter, STR_CON);
                dfue.ssl_data(parameter);
                debugxprint(parameter);
                debugxflush();
                calldelay(50);
                dfue.ssl_data("\r\n");
                // http complete
                if (dfue.sendCommand(0, SERVER_TM_OUT, "ok *")) {  // hat Server Anfrage quittiert ?
                  data_send = 1;                                   // success
                  retry = 0;
                  s_cnt += _Send_Sets;

                  char *p_buf = strstr(dfue.buffer, "ok *");  // search string start
                  uint8_t pos = 0;
                  do {
                    p_buf--;  // search start of line
                    pos++;
                  } while ((!(*p_buf == '\n')) && (pos < 20));

                  debugprint("Q:");
                  debugprintln(p_buf);
                  debugflush();

                  // Format Quittung aus beelogger-log.php
                  // echo "5ok *"  = 5 Minuten
                  uint8_t n;
                  if (char *p_bf = strchr(p_buf, 'T')) {
                    n = atoi(p_bf + 1);  // Konvertiere str in int

                    char x = *(p_buf + 1);
                    if ((x > 0x2F) && (x < 0x3A)) {  // first char a number?
                      long l_tm = atol(p_buf);
                      l_tm = l_tm - 946684800;  // EPOCH_TIME_OFFSET
                      rtc.setDateTime(l_tm);
                    }
                  } else {
                    n = atoi(p_buf);  // Konvertiere str in int
                  }
                  if (n <= 60) {
                    WeckIntervallMinuten = (uint8_t)n;
                  }

                  report_info = 0;
                  if (strchr(p_buf, 'P')) {  // Pegelmessung
                    report_info = 1;
                  }

                  if (strchr(p_buf, 'A')) {
                    send_cycle = SEND_CYC_A;
                  } else if (strchr(p_buf, 'B')) {
                    send_cycle = SEND_CYC_B;
                  } else if (strchr(p_buf, 'C')) {
                    send_cycle = SEND_CYC_C;
                  } else if (strchr(p_buf, 'D')) {
                    send_cycle = SEND_CYC_D;
                  }
                  calldelay(1000);
                }  // received ok *
              }    // Open / Connect
              //dfue.ssl_data("+++");// back to command mode
              debugxprintlnF("cls:");
              debugxflush();
              if (!dfue.sendCommand(0, 3000, "PEER_CLOSED")) {  // wait for connection terminate
                dfue.ssl_close();
              }
              debugxprintln(F("ok"));
              debugxflush();
            } while ((s_cnt < count) && (data_send == 1));  // while my_counter
            //######################
            if (data_send == 0) {  // failed, stop and retry
              debugprintlnF("Retry");
              debugflush();
              calldelay(2000);
              retry++;
            }
          } while ((retry < NUM_RETRY) && (data_send == 0));  // retry TCP Connect
        }                                                     // ssl_start
        dfue.ssl_stop();                                      // stop Network
      }                                                       // ssl_init
    }                                                         // start APN
  }                                                           // init

  dfue.shutdown();  // shutdown dfue
  calldelay(50);
  dfue_rxtx_off();
  digitalWrite(GSM_Power_Pin, LOW);

#if myDEBUG
  if (s_cnt > count) s_cnt = count;
#endif
  debugprintF("send ");
  debugprintln(s_cnt);
  debugflush();
  return (s_cnt);
}
#endif
