// 14.07.2024 Mx-Strings
// 30.11.2025 Watchdog EE-Prom lesen


#if (_WLAN_https == 1)
#pragma message " information: using WLAN https needs ESP8266 with esp_https_beelogger firmware"

//----------------------------------------------------------------
// Konfiguration ESP-8266-01 WLAN Modul
//----------------------------------------------------------------
#include <SoftwareSerial.h>
#define ESP_Baudrate 9600
SoftwareSerial ESP_SERIAL = SoftwareSerial(ESP_RX, ESP_TX);  //RX, TX
char buffer[64];
#define DEB_buff 0  // debug receive buffer
#define DEB_cmd 0   // debug data to send
//----------------------------------------------------------------



//----------------------------------------------------------------
// Parameter Datenversand  // diese nicht modifizieren
//----------------------------------------------------------------
#define SERVER_TM_OUT 15000  // 15000 = 15 sec
const char Str_Pw[] PROGMEM = "PW=";
const char Str_Id[] PROGMEM = "&Z=2&A=1&ID=";
#if (Anzahl_Sensoren_Gewicht == 1)
const char Str_MData[] PROGMEM = { "&M1=" };  // Parameter Multi Data  Senden
#endif
#if (Anzahl_Sensoren_Gewicht == 2)
const char Str_MData[] PROGMEM = { "&M2=" };  // Parameter Multi Data  Senden
#endif
#if (Anzahl_Sensoren_Gewicht == 3)
const char Str_MData[] PROGMEM = { "&M3=" };  // Parameter Multi Data  Senden
#endif
#if (Anzahl_Sensoren_Gewicht == 4)
const char Str_MData[] PROGMEM = { "&M4=" };  // Parameter Multi Data  Senden
#endif
//----------------------------------------------------------------

/**
  @brief Utility functions
  stop_DFUe_device(): ESP8266 Reset aktiv
  dfue_rxtx_off():  Serial TX/RX dfiniert setzen

  @param  none, globale Variablen
  @return  none
*/
void stop_DFUe_device() {
  digitalWrite(ESP_RESET, LOW);  // ESP "off"
  pinMode(ESP_RESET, OUTPUT);
}


/**
  @brief Funktion ESP8266 Setup_WLAN()
  initialisere ESP8266,
  Verbinde zum WLAN AP

  @param  none, globale Variablen
  @return  number of Access Point used
*/
boolean Setup_WLAN() {
  char parameter[64];

  for (uint8_t x = 0; x < Anzahl_AP; x++) {
    ESP_SERIAL.begin(ESP_Baudrate);
    calldelay(250);
    ESP_SERIAL.print("*");
    calldelay(10);  // dummy print, recover from pwrsave
    digitalWrite(ESP_RESET, HIGH);
    calldelay(500);  //important
    debugprintlnF("ESP?");
    debugflush();
    if (com_2_esp(0, 5000, "*ok*")) {  // wait or timeout
      char *slen = strstr(buffer, "20");
      debugprintln(slen);
      debugflush();

      calldelay(200);

      if (x == 1) {
        strcpy_P(parameter, Access_Point2);
        if (com_2_esp(parameter, 2000, 0)) {
          debugprintln(parameter);
          debugflush();
          strcpy_P(parameter, AP_Passwort_2);
          com_2_esp(parameter, 2000, 0);
        }
      } else {
        strcpy_P(parameter, Access_Point1);
        if (com_2_esp(parameter, 2000, 0)) {
          debugprintln(parameter);
          debugflush();
          strcpy_P(parameter, AP_Passwort_1);
          com_2_esp(parameter, 2000, 0);
        }
      }

      if (!com_2_esp(0, 5000, "ok")) {  // read echo params
        debugprintln(buffer);
        debugprintln("??");
        debugflush();
      }
      if (com_2_esp(0, 15000, "APOK")) {
        debugprintlnF("WLAN!");
        debugflush();
        return true;
      }
    }  // ESP *ok*
  }    // for
  return false;
}
//----------------------------------------------------------------


/**
  @brief Funktion ESP8266 Send_data()
  verbinde zum Server, lese Daten aus EE-Prom,
  übertrage Daten, Server-Quittung auswerten
  Fehlerbehandlung bei der Übertragung
  Setze aus Serverquittung:
  - Zeit in DS3231
  - Messintervall
  - Sendeintervall

  @param  count:: Anzahl Datensätze zu übertragen, globale Variablen
  @return  senden erfolgreich > 0
*/
uint8_t Send_Data(uint8_t count) {
  char parameter[64];
  uint8_t additional_Data = 0;  // erzeuge zusätzlichen Datensatz
  uint8_t s_cnt = 0;            // send counter
  uint8_t x, y;                 // Datensatz zaehler

  uint8_t sum, test, first;  // EE-Prom Checksumme
  char chk[2];

  uint16_t pos;
  uint8_t data_send;  // send status
  uint8_t retry;      // retry counter

  if (Setup_WLAN()) {  // Connect to access point

    if (Service < 90.0) {  // only if not UserService
      // Signalstärke AP
      if (report_info) {
        strcpy(parameter, "+++P");                // WLan signal strength
        if (com_2_esp(parameter, 5000, "dBm")) {  //
          int pegel = atoi(buffer);
          Service = (float)pegel;
          additional_Data = 1;

          debugprintF("WLAN [dBm] ");
          debugprintln(Service);
          debugflush();
        }
      }
    }

    do {  // Block send loop
      retry = 0;
      do {  // Connect and send loop
        data_send = 0;
        strcpy_P(parameter, serverName);
        com_2_esp(parameter, 2000, 0);
        debugprint(parameter);
        debugflush();
        strcpy_P(parameter, beelogger_pfad);
        com_2_esp(&parameter[4], 2000, 0);
        debugprintln(&parameter[4]);
        debugflush();
        strcpy_P(parameter, Str_Pw);  // erstelle Daten
        com_2_esp(parameter, 2000, 0);
        strcpy_P(parameter, Passwort);
        com_2_esp(parameter, 2000, 0);
        strcpy_P(parameter, Str_Id);
        com_2_esp(parameter, 2000, 0);
        strcpy(parameter, ID_ID);
        com_2_esp(parameter, 2000, 0);

        // Daten
        wdt_enable(WDTO_4S);
        y = 0;
        first = 1;
        do {
          // lese von AT24Cxx
          test = 0;
          do {
            pos = (data_start + (uint16_t)(s_cnt + y));
            if (pos >= _EE_DATA_SETS) pos -= _EE_DATA_SETS;
            pos *= _Daten_Satz_Len;
            my_EEPROM.ReadStr(pos, DatenString, _Daten_Satz_Len - 2);
            DatenString[(_Daten_Satz_Len - 2)] = 0;  // String ende erzwingen
            sum = 0;
            for (x = 0; x < strlen(DatenString); x++) {  // EE_Prom Checksum test
              sum += DatenString[x];
            }
            pos = pos + _Daten_Satz_Len - 1;
            my_EEPROM.ReadStr(pos, chk, 1);
            x = (uint8_t)chk[0];
            test++;
          } while ((test < 2) && (sum != x));  // zwei Leseversuche

          if (sum == x) {      // checksumme i.o.
            if (first == 1) {  // Multi Type
              first = 0;
              strcpy_P(parameter, Str_MData);
              com_2_esp(parameter, 500, 0);
              debugprint(parameter);
              debugflush();
            } else {  // einfügen Satztrenner
              strcpy(parameter, ",");
              com_2_esp(parameter, 500, 0);
              debugprint(parameter);
              debugflush();
            }
            calldelay(50);
            com_2_esp(DatenString, 2000, 0);  // Datensatz
            debugprintln(DatenString);
            debugflush();
          } else {  // Datensatz auslassen
            DatenString[0] = 0;
            debugprintF("EE?");
            debugprintln(pos);
            debugflush();
          }
          y++;

        } while ((y < _Send_Sets) && ((s_cnt + y) < count));
        wdt_disable();

        if ((additional_Data && ((s_cnt + y) == count)) || (Service == 99.0)) {  // all done, Service ?
          char service_data[16];
          dtostrf(Service, 1, 1, service_data);
          sprintf(DatenString, "&S=%s", service_data);
          com_2_esp(DatenString, 2000, 0);
          debugprintln(DatenString);
          debugflush();
        }

        // ende Daten
        strcpy(parameter, "+++");                           // send data
        if (com_2_esp(parameter, SERVER_TM_OUT, "ok *")) {  // hat Server Anfrage quittiert ?
          data_send = 1;                                    // success
          retry = 0;
          s_cnt += _Send_Sets;  // have been send

          char *p_buf = strstr(buffer, "ok *");  // search string start
          *p_buf = 0;
          uint8_t xpos = 0;
          do {
            p_buf--;  // search start of line
            xpos++;
          } while ((!(*p_buf == '\n')) && (xpos < 20));

          debugprint("Q:");
          debugprintln(p_buf);
          debugflush();

          int n;
          if (char *p_bf = strchr(p_buf, 'T')) {
            n = atoi(p_bf + 1);  // Konvertiere str in int

            char x = *(p_buf + 1);
            if ((x > 0x2F) && (x < 0x3A)) {  // first char a number?
              long l_tm = atol(p_buf);
              l_tm = l_tm - 946684800;  // EPOCH_TIME_OFFSET
              rtc.setDateTime(l_tm);
            }
          } else {
            n = atoi(p_buf);  // Konvertiere str in int
          }
          if (n <= 60) {
            WeckIntervallMinuten = (uint8_t)n;
          }

          report_info = 0;
          if (strchr(p_buf, 'P')) report_info = 1;
          if (strchr(p_buf, 'A')) send_cycle = SEND_CYC_A;
          else if (strchr(p_buf, 'B')) send_cycle = SEND_CYC_B;
          else if (strchr(p_buf, 'C')) send_cycle = SEND_CYC_C;
          else if (strchr(p_buf, 'D')) send_cycle = SEND_CYC_D;
        }  // ok * ?

        if (data_send == 0) {  // failed, terminate http session
          debugprintF("Retry: ");
          debugprintln(retry);
          debugflush();
          retry++;
          if (retry) report_info = 0;  // may be error on measuring fi eld strength
          calldelay(3000);             // wait
        }
      } while ((retry < 3) && (data_send == 0));    // retry TCP Connect and send
    } while ((s_cnt < count) && (data_send == 1));  // while my_counter
    //*************************

    strcpy(parameter, "+++D");
    com_2_esp(parameter, 1000, 0);  // disconnect
    calldelay(200);
  }
  if (s_cnt > count) s_cnt = count;
  debugprintF("send: ");
  debugprintln(s_cnt);
  debugflush();
  calldelay(200);
  ESP_SERIAL.end();  // stopListening();
  calldelay(50);
  digitalWrite(ESP_RX, LOW);
  digitalWrite(ESP_TX, LOW);  // pwrsave, needs recover after sleep
  digitalWrite(ESP_RESET, LOW);
  return (s_cnt);  // return Sets send, 0 = all failed,
}
//----------------------------------------------------------------



// com_2_esp: send data to ESP
// if parameter 'cmd' is 0 (don't use "" or "0"), nothing is send,
// the data from ESP is checked against data in 'expected'
// if 'expected' is 0, then string is "OK\r"
int com_2_esp(char *cmd, unsigned long timeout, const char *expected) {
  if (cmd) {
    empty_rcv();
    strcat(cmd, "\r");  // always append CR
#if DEB_cmd
    Serial.print(F("\r\nCmd:  "));
    Serial.println(cmd);
    Serial.flush();
#endif
    ESP_SERIAL.print(cmd);
    ESP_SERIAL.flush();  // wait for data to be transmitted
  }
  strcpy(buffer, "    ");
  unsigned long t = millis();
  uint8_t n = 0;
  do {
    if (ESP_SERIAL.available()) {
      char c = ESP_SERIAL.read();
#if DEB_buff
      Serial.print(c);
#endif
      if (n >= (sizeof(buffer) - 1)) {
        // buffer full, discard first half
        n = sizeof(buffer) / 2 - 1;
        memcpy(buffer, buffer + sizeof(buffer) / 2, n);
      }
      // copy received character and terminate string
      buffer[n++] = c;
      buffer[n] = 0;
      // compare buffer to expected string or "OK" if an empty one is given
      if (strstr(buffer, expected ? expected : "OK\r")) {
        return n;
      }
      if (c == '\r') n = 0;  // if newline reset counter, check a single line only
    }
  } while ((millis() - t) < timeout);
  return 0;  // not found
}

// empty RX Buffer
void empty_rcv() {
  do {
    ESP_SERIAL.read();
    delay(5);
  } while (ESP_SERIAL.available() > 0);
  delay(50);
}
#endif  //_WLAN_https
