// 30.06.2024 Zuordnung Aux[]

//----------------------------------------------------------------
// Add-On  Sensor
//
//  Regenmesser
//
//
//----------------------------------------------------------------

//----------------------------------------------------------------
// Konfiguration Regenmesser
//----------------------------------------------------------------
#if Anzahl_Sensor_Regen
volatile byte Rain_Counter;
volatile unsigned long alteZeit = 0, entprellZeit = 20;  // 20msec
#endif

//----------------------------------------------------------------
// Funktion Regenmesser
//----------------------------------------------------------------
void Sensor_Regen() {
#if Anzahl_Sensor_Regen
  byte r_cnt = Rain_Counter;
  Rain_Counter = 0;
  float f_Rain = Rain_Cal * (float)r_cnt;
  Aux[1] = f_Rain;  // Zuordnung Wert Regenmesser zu Sensor
#endif
}
//----------------------------------------------------------------

//----------------------------------------------------------------
// Funktion Init_Rain_Int
//----------------------------------------------------------------
void Init_Rain_Int() {
#if Anzahl_Sensor_Regen
  pinMode(Rain_Interrupt_Pin, INPUT_PULLUP);
  delay(5);
  attachInterrupt(digitalPinToInterrupt(Rain_Interrupt_Pin), Rain_Cnt, FALLING);  // D3 = Interrupt
#endif
}
//----------------------------------------------------------------

//----------------------------------------------------------------
// Funktion Rain_Cnt Interrupt Handler
//----------------------------------------------------------------
#if Anzahl_Sensor_Regen
void Rain_Cnt() {  // D3 = Interrupt
  // innerhalb der entprellZeit nichts machen
  // just reading millis(), it is incremented in loop()
  if ((millis() - alteZeit) > entprellZeit) {
    Rain_Counter++;
    alteZeit = millis();  // letzte Schaltzeit merken
  }
}
#endif
//----------------------------------------------------------------


/*
Der Regenmesser verwendet ein Messsystem mit einer Wippe.
Hier eine Beschreibung:
http://www.elektronik-labor.de/Notizen/Regensensor.html
Fertig fuer ca. 10Euro mit dem Stichwort "Rain Gauge" bei den diversen Verkaufsplattformen.
Allgemeine Informationen in Sachen Regen messen:
- Ausstellungsort
https://www.wetterstation.net/regenmesser-aufstellen/
- Art des Regens: Niesel, feiner Nebel oder auch gefroren (Schnee)
Hier recht brauchbare Informationen zu Stärken und Schwächen der Niederschlagsmessverfahren:
https://de.wikipedia.org/wiki/Niederschlagsmesser
 

Beim beelogger funktioniert das Messen Interrupt gesteuert, 
so dass der Prozessor das Wippenbewegungen zaehlen zu jeder Zeit nebenbei erledigt.
Damit dies mit der beelogger-Hardware möglich ist, sind kleinere Anpassungen notwendig:
- Der Anschluss des DS18B20 (D3) wird fuer den Kontakt der Wippe benoetigt.
- Der Widerstand  (4k7) am Anschluß des DS18B20 (Solar Z-R1) darf nicht bestueckt sein, ggf. entfernen.
- Der DS18B20 kann anstelle des DHT2 angeschlossen werden.
- Der Reed-Kontakt des Regenmessers wird am Anschluss Data (D3) und GND angeschlossen.
- Ein Filter aus einen 1k Widerstand und einem 100nF Kondensator

Ein Multi-Sketch mit Aux-Funktion wird mit der beelogger_addon.ino erweitert.
Einfach diese beelogger_addon.ino in das Sketch-Verzeichnis kopieren.
Die Zuordnung des Sensor-Wertes ist in der Funktion Sensor_Regen() auf die Variable Aux[1] programmiert.

Der Haupt-Sketch muss in der setup() und loop erweiteret werdwen.

In setup() sind diese Zeilen zu ergänzen:
#if Anzahl_Sensor_Regen
  Init_Rain_Int();
#endif

In loop() wird unmittelbar vor dem Aufruf der Funktion Daten_Senden dies eingefügt:
#if Anzahl_Sensor_Regen
    Sensor_Regen();
#endif




Die Kalibrierung des Regenmessers ist recht einfach.

- 100ml Wasser langsam durch das Messsystem laufen lassen und die Ticks vom beelogger zählen lassen.
     Eine größere Menge Wasser geht auch.

- Die Wassermenge durch die Anzahl der Ticks teilen, bei mir gibt das dann ca. 5ml.

- Die Oberfläche des Auffangbehälters berechnen: Oberfläche = 2* PI * (Radius zum Quadrat)
   Im getesten Aufbau ist die 104cm² (Trichter mit 11,5cm Durchmesser).

Mit diesen Werten kann der Kalibrierwert errechnet werden.
Kal_Wert =  Wassermenge pro Tick[ml]  / Oberfläche des Auffangbehälters[cm²];
Der Wert ist auf Liter pro Quadratmeter umzurechnen.
mit 10000 cm²/m² und 1000 ml/l ergibt sich Faktor 10

Das ergibt im Beispiel einen Kalibrierfaktor mit (5ml / 104 cm²)*10  von  0,48 l/m².

 * 
 */
