/****************************************************************/
// GSM Konfiguration
/****************************************************************/
// Name des Zugangspunktes des Netzwerkproviders
const char  APN[] PROGMEM = {"APN-Name"};

//Beispiele:
//const char  APN[] PROGMEM ={"iot.1nce.net"}; // 1nce
//const char  APN[] PROGMEM ={"internet.t-mobile"}; // Telekom
//const char  APN[] PROGMEM ={"internet.telekom"}; // congstar
//const char  APN[] PROGMEM ={"web.vodafone.de"};  // vodafone
//const char  APN[] PROGMEM = {"pinternet.interkom.de"}; // O2
//const char  APN[] PROGMEM = {"internet.eplus.de"};  // eplus
//const char  APN[] PROGMEM = {"TM"}; //Thingsmobile
// kein APN-Benutzer, kein APN-Passwort



/****************************************************************/
// Verbindung zum Server
// Parameter zu Datenübertragung
/****************************************************************/

// Domainname zum Webserver mit beelogger-Skript
// Länge maximal 30 Zeichen
const char serverName[] PROGMEM = "community.beelogger.de";

// GET mit Verzeichnis auf dem Webserver und PHP-Skript für den jeweiligen beelogger
// Mit Anzahl_Sensoren_Gewicht 1...4
// 1 - Bsp: "GET /USERX/beeloggerY/beelogger_log.php?"
// 2 - Bsp: "GET /USERX/DuoY/beelogger_log.php?"
// 3 - Bsp: "GET /USERX/TripleY/beelogger_log.php?"
// 4 - Bsp: "GET /USERX/QuadY/beelogger_log.php?"

const char beelogger_pfad[] PROGMEM = {"GET /USERX/SystemY/beelogger_log.php?"};   // "USERX" und "SystemY" ersetzen


// Passwort vom Webserver-Skript
const char Passwort[] PROGMEM =  {"Log"};   // hier dein beelogger-log - Passwort


// Sendebeschränkung während Nachtstunden
#define DO_NOT_SEND_AT_NIGHT 0    // Sendebeschränkung 1 -> aktiv, 0 -> nicht aktiv
#define DO_NOT_SEND_BEGIN 20   // Uhrzeit Beginn Sendebeschränkung Wertebereich 18 - max 23 Uhr!!!
// Ende der Sendebeschränkung ist voreingestellt mit #define SEND_HOUR 6  auf 6 Uhr
// Achtung: automatische Umschaltung der serverseitig eingestellte Mess-/Sendeintervalle erfolgt nur wenn
//  zum Zeitpunkt des Umstellen Daten erfolgreich gesendet wurden
// Beispiel: serverseitige Einstellung zur Umstellung des Messintervalls 20 Uhr und DO_NOT_SEND_BEGIN 22
//           DO_NOT_SEND_BEGIN 20 und serverseitige Einstellung zur Umstellung des Messintervalls 21 Uhr funktioniert nicht.
// Hinweis: Wenn das EE-Prom mit Datensätzen gefüllt ist, wird immer ein Sendeversuch unternommen
/****************************************************************/
