/****************************************************************/
// Funktion SIM800L - Mobilfunk  TCP / CIP-Send  EE-Prom
/****************************************************************/
//25.04.2020 Multi Funktion als Standard
//01.05.2020 check first char of timestammp from server
//13.08.2020 Debug Ausgabe optimiert
//03.12.2020 Sendezyklen konfigurierbar
//12.12.2020 wdt kontrolle
//15.12.2020 chksum EE-Prom Daten
//08.01.2021 Debug Info
//19.03.2021 String handling
// 30.04.2021 Status Reporting
// 03.05.2021 EE-Prom-only
// 25.05.2021 EE-Prom error handling
// 20.11.2021 Reinit I2C Bus if Pro-Mini
// 28.11.2021 Debug Messages
// 07.02.2024 Datenstring Signalpegel
// 14.07.2024 Mx-Strings
// 12.01.2025 Send A=1 obsolete


/****************************************************************/
// Konfiguration SIM800L - Mobilfunk
/****************************************************************/
#include "SIM800_beelogger_24.h"

#define SERVER_TM_OUT 10000 // 10000 = 10 sec

/****************************************************************/


/****************************************************************/
// Parameter Datenversand via Http // diese nicht modifizieren
/****************************************************************/
const char Str_Http[]    PROGMEM = " HTTP/1.1\r\n";
const char Str_Con_cls[] PROGMEM = "Connection: close\r\n\r\n";

const char Str_Pw[]      PROGMEM = {"PW="};
const char Str_Id[]      PROGMEM = {"&Z=2&ID="};
#if(Anzahl_Sensoren_Gewicht == 1)
const char Str_MData[] PROGMEM = { "&M1=" };  // Parameter Multi Data  Senden
#endif
#if(Anzahl_Sensoren_Gewicht == 2)
const char Str_MData[] PROGMEM = { "&M2=" };  // Parameter Multi Data  Senden
#endif
#if(Anzahl_Sensoren_Gewicht == 3)
const char Str_MData[] PROGMEM = { "&M3=" };  // Parameter Multi Data  Senden
#endif
#if(Anzahl_Sensoren_Gewicht == 4)
const char Str_MData[] PROGMEM = { "&M4=" };  // Parameter Multi Data  Senden
#endif
/****************************************************************/


/**
  @brief Utility functions
  stop_DFUe_device(): SIM7600E Reset aktiv oder Power inaktiv
  dfue_rxtx_off():  Serial TX/RX dfiniert setzen

  @param  none, globale Variablen
  @return  none
*/
void stop_DFUe_device() {
  digitalWrite(GSM_Power_Pin, LOW);    // SIM800 "off"
  pinMode(GSM_Power_Pin, OUTPUT);
}

void dfue_rxtx_off() {
  digitalWrite (GSM_RX, LOW);
  digitalWrite (GSM_TX, LOW);
}

/**
  @brief Funktion set_I2_clock

  einstellen der Geschwindigkeit des I2C-Bus

  @param none
  @return  none
*/
#include "Wire.h"
void set_I2C_clock() {
  Wire.begin();
  Wire.setClock(100000);  // 100kHz
}

/**
  @brief Funktion SIM7600E Send_Data()
  initialisiere SIM7600E, vebinde ins Mobilfunknetz
  verbinde zum Server, lese Daten aus EE-Prom,
  übertrage Daten, Server-Quittung auswerten
  Fehlerbehandlung bei der Übertragung
  Setze aus Serverquittung:
  - Zeit in DS3231
  - Messintervall
  - Sendeintervall

  @param  count:: Anzahl Datensätze zu übertragen, globale Variablen
  @return  senden erfolgreich > 0
*/
uint8_t Send_Data(uint8_t count) {
  char parameter[64];
  uint8_t s_cnt = 0;            // send counter
  uint8_t additonal_Data = 0;
  //float ServiceX = No_Value;
  uint8_t x, y;       // Datensatz zaehler

  uint8_t sum, test, first; // EE-Prom Checksumme
  char chk[2];

  uint16_t pos;
  uint8_t data_send;    // send status
  uint8_t retry;        // retry counter

  CGPRS_SIM800 dfue;

  digitalWrite(GSM_Power_Pin, HIGH);

  debugprintlnF("GSMon");
  debugflush();

  calldelay(4000);

  if (dfue.init(6000)) {  // Init SIM800 Modul

    debugprintlnF("Init!"); debugflush();

    strcpy_P(parameter, APN);
    debugprintln(parameter); debugflush();
    if (dfue.start(parameter) == 0) {  // Start dfue Connection

      if (Service < 90.0) {      // only if not UserService
        if (report_info == 1) {

          int Signal = dfue.getSignalQuality();
          Service = (float)Signal;
          additonal_Data = 1;

          debugprint(Signal);
          debugprintlnF(" dBm");
          debugflush();

        }
        else if (report_info == 2) {
          int simVoltage = dfue.getSIM800_Voltage();
          if (simVoltage > 0) {
            Service = ((float)simVoltage) / 1000.0;
            additonal_Data = 1;
          }
        }
      }

      //#################
      data_send = 0;    // send status
      retry = 0;        // retry counter
      do {  // retry loop

        AT24Cxx the_EEPROM(AT24Cxx_CTRL_ID);
#if defined(ARDUINO_AVR_PRO) // reinit I2C-Bus
        set_I2C_clock();
#endif
        do {  // Blockweise send loop
          data_send = 0;
          // always new connect; session alive not supported by server

          strcpy_P(parameter, serverName);
          debugprintln(parameter); debugflush();
          if (dfue.Connect(parameter)) {  // Start TCP Connection

            debugprintlnF("Con!"); debugflush();

            if (dfue.prep_send()) {         // Prepare send data

              strcpy_P(parameter, beelogger_pfad); dfue.send(parameter);
              debugprintln(parameter); debugflush();
              strcpy_P(parameter, Str_Pw);   dfue.send(parameter);
              strcpy_P(parameter, Passwort); dfue.send(parameter);
              // System ID, options
              strcpy_P(parameter, Str_Id);   dfue.send(parameter);
              debugprint(parameter); debugflush();
              strcpy(parameter, ID_ID);      dfue.send(parameter);
              debugprintln(parameter); debugflush();

              //Daten

              y = 0; first = 1;
              do {
                // lese von AT24Cxx
                test = 0;
                do {
                  pos = data_start + (uint16_t)(s_cnt + y);
                  if (pos >= _EE_DATA_SETS) pos -= _EE_DATA_SETS;
                  pos *= _Daten_Satz_Len;
                  my_EEPROM.ReadStr(pos, DatenString, _Daten_Satz_Len - 2);
                  DatenString[(_Daten_Satz_Len - 2)] = 0;  // String ende erzwingen
                  sum = 0;
                  for (x = 0; x < strlen(DatenString); x++) { // EE_Prom Checksum test
                    sum += DatenString[x];
                  }
                  pos = pos + _Daten_Satz_Len - 1;
                  my_EEPROM.ReadStr(pos, chk, 1);
                  x = (uint8_t)chk[0];
                  test++;
                } while ((test < 2) && ( sum != x)); // zwei Leseversuche

                if (sum == x) {           // checksumme i.o.
                  if (first == 1) {       // Multi Type
                    first = 0;
                    strcpy_P(parameter, Str_MData); dfue.send(parameter);
                    debugprint(parameter); debugflush();
                  }
                  else {                 // einfügen Satztrenner
                    dfue.send(",");
                  }
                  dfue.send(DatenString);  // Datensatz
                  calldelay(50);
                  debugprintln(DatenString);
                  debugflush();

                }
                else {                    // Datensatz auslassen
                  DatenString[0] = 0;
                  debugprintF("EE?");
                  debugprintln(pos);
                  debugflush();
                }
                y++;

              } while ( (y < _Send_Sets) && ((s_cnt + y) < count) );

              if ( (additonal_Data) && ((s_cnt + y) == count) ) { // all done, Service ?
                char service_data[16];
                dtostrf(Service, 1, 1, service_data);
                sprintf(DatenString, "&S=%s", service_data);
                dfue.send(DatenString);
                debugprintln(DatenString); debugflush();
              }
              // ende Daten
              strcpy_P(parameter, Str_Http); // HTTP/1.1
              dfue.send(parameter);
              strcpy(parameter, "Host: ");
              dfue.send(parameter);
              strcpy_P(parameter, serverName);
              dfue.send(parameter);
              strcpy(parameter, "\r\n");
              dfue.send(parameter);
              strcpy_P(parameter, Str_Con_cls);
              dfue.send(parameter);
              dfue.send(0x00);   // Start send data
              // http complete
              debugprintln("http"); debugflush();

              if (dfue.sendCommand(0, SERVER_TM_OUT, "ok *")) { // hat Server Anfrage quittiert ?

                data_send = 1; // success
                retry = 0;
                s_cnt += _Send_Sets;

                char *p_buf = strstr(dfue.buffer, "ok *");  // search string start
                *p_buf = 0;
                pos = 0;
                do {
                  p_buf --;    // search start of line
                  pos++;
                }
                while ( (!(*p_buf == '\n')) && (pos < 20));

                debugprint("Q:"); debugprintln(p_buf); debugflush();

                // Format Quittung aus beelogger-log.php
                // echo "5ok *"  = 5 Minuten
                int n;
                if (char *p_bf = strchr(p_buf, 'T') ) {
                  n = atoi(p_bf + 1);  // Konvertiere str in int

                  char x = *(p_buf + 1);
                  if ((x > 0x2F) && (x < 0x3A)) { // first char a number?
                    uint32_t l_tm = atol(p_buf);
                    l_tm = l_tm - 946684800;  // EPOCH_TIME_OFFSET
                    rtc.setDateTime(l_tm);
                  }
                }
                else {
                  n = atoi(p_buf); // Konvertiere str in int
                }
                if (n <= 60) { //14.10.
                  WeckIntervallMinuten = (uint8_t)n;
                }

                report_info = 0;
                if (strchr(p_buf, 'P') ) {
                  report_info = 1;
                }
                else if (strchr(p_buf, 'V') ) {
                  report_info = 2;
                }
                if (strchr(p_buf, 'A') ) {
                  send_cycle = SEND_CYC_A;
                }
                else if (strchr(p_buf, 'B') ) {
                  send_cycle = SEND_CYC_B;
                }
                else if (strchr(p_buf, 'C') ) {
                  send_cycle = SEND_CYC_C;
                }
                else if (strchr(p_buf, 'D') ) {
                  send_cycle = SEND_CYC_D;
                }
              } // received ok *
            } // prep_send
          } // Connect
          dfue.disConnect();
          calldelay(1000);
        }
        while ((s_cnt < count) && (data_send == 1)); // while my_counter
        //######################
        if (data_send == 0) {  // failed, stop and retry
          dfue.stop();        // stop CIP session

          debugprintlnF("Retry"); debugflush();

          calldelay(3000);
          retry ++;
          if (retry == 2 ) report_info = 0; // maybe error on measuring flied strength
        }
      }
      while ((retry < 3) && (data_send == 0)); // retry TCP Connect
    }
    // start
  }
  // init
#if myDEBUG
  if (s_cnt > count) s_cnt = count;
#endif
  debugprintF("send "); debugprintln(s_cnt);
  debugflush();

  dfue.stop();        // stop CIP session
  dfue.shutdown();    // shutdown dfue
  calldelay(50);
  dfue_rxtx_off();
  digitalWrite(GSM_Power_Pin, LOW);
  return (s_cnt);
}
