/*
   (C) 2023 R.Schick / Thorsten Gurzan - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de
// Version 2022    beelogger Multi mit EE-Prom, bis zu vier Waagen
// 30.04.2021 Status Reporting
// 03.05.2021 EE-Prom-only
// 14.11.2021 service switch handling
// 22.05.2022 swarm alarm
// 10.06.2022 swarm alarm intervall
// 10.12.2022 autoconfig Arduino ProMini
// Version 2023
// 16.03.2023 preset Gewicht[]
// 01.04.2023 Universal Platine 2.x
// 06.04.2023 store dataset counter in eeprom
// 15.04.2023 check EE-Prom
// 07.06.2023 Universal 2.x
// 30.06.2023 change startup batterie measurement
// 11.07.2023 Universal 2.x
// 04.01.2024 ThingsSpeak Variante


char ID_ID[] = "THSPEAK_M_240104";  //nur Grossbuchstaben,Zahlen, keine Blank


#include "beelogger_config.h" // this one first!
#include "Config_TS.h"        // Konfiguration eintragen
#include "Config_MULTI.h"     // Konfiguration und Kalibrierung eintragen


//----------------------------------------------------------------
// Variablen
//----------------------------------------------------------------
const float No_Val = 99.9f;  // Vorbelegung, Wert nicht gemessen
const float No_Value = -1.0f;  // Vorbelegung, Wert nicht gemessen

//                   DS18B20_5, DHT1,   DHT2,   Si7021, SHT31a, SHT31b, BMEa,     BMEb, DS18B20_1,_2,_3,_4,
float SensorTemp[13] = {No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val};

//                          NotUsed, DHT1,     DHT2,     Si7021,   SHT31a,   SHT31b,   BMEa,     BMEb,     DS18B20_a,_b,_c,_d,
float SensorFeuchte[12] = {No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value};

//              DS3231Temp, Luftdruck, ZählerRegen
float Aux[3] = {No_Value, No_Value, No_Value};  // needs a preset

float Licht = No_Value;
float DS_Temp;

float Gewicht[4] = {No_Value, No_Value, No_Value, No_Value};
float LetztesGewicht[4] = {No_Value, No_Value, No_Value, No_Value};

float Batteriespannung;
float Solarspannung;
float Service = 0.0;  // preset to indicate reset system


// Variablen permanente Daten
uint32_t time_on = 0;
uint8_t WeckIntervallMinuten = WeckIntervall_default;
uint8_t report_info = 0;           // 0 = time-On, 1 = Pegel
uint8_t my_counter = 0;            // Anzahl Messungen
uint8_t nr_to_measure = 1;         // Senden bei Start
uint8_t next_send_hour = 0;        //
uint8_t send_cycle = 1;            // Normaler Sendezyklus
uint8_t snd_dly  = 0;              // Send delay
uint8_t stuck_switch = 0;    // Service Switch permanent on
uint8_t s_alarm = 0;         // Schwarmalarm

// Interrupt Variablen
volatile uint8_t ok_sleep = true;
char DatenString[_Daten_Satz_Len];  // Datenbuffer
//----------------------------------------------------------------

void setup() {

  Serial.begin(Serial_Baudrate);
  Serial.println(ID_ID);
  Serial.flush();

  //----------------------------------------------------------------
  //  System on
  //----------------------------------------------------------------

  stop_DFUe_device();

  digitalWrite(Power_Pin, HIGH);     // Power On
  pinMode(Power_Pin, OUTPUT);
  calldelay(5);

  Spannungen_messen();
  if (Batteriespannung < VAlternativ) {
    Serial.println(F("Bat low"));
  } 
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  // Setup Gewicht
  //----------------------------------------------------------------
  Sensor_Gewicht(true);   // Startwert Gewicht holen
  //----------------------------------------------------------------

  
  //----------------------------------------------------------------
  //  Sleep Mode Interrupt
  //----------------------------------------------------------------
  pinMode(DS3231_Interrupt_Pin, INPUT_PULLUP);
  calldelay(5);
  //----------------------------------------------------------------

  Init_Rain_Int();  // init Interrupt Regensensor

  Serial.flush();
  Serial.end();
  Serial_rxtx_off();
}

//#########################################################
void loop() {
  uint8_t s_alarm;
  uint8_t ureq;

  System_On();
  debugbegin(Serial_Baudrate);
  debugprintlnF("\nLoop");
  display_time();
  debugflush();

  Spannungen_messen();
  if (Batteriespannung > VMinimum) {
    ureq = User_Int();
    if (ureq) {  // 1 = Service Switch not set
      Sensor_Temp_Zelle(0);
      Sensor_DHT();
      Sensor_DS18B20();
      Sensor_Si7021();
      Sensor_SHT31();
      Sensor_BME280();
      Sensor_Licht();
      Sensor_Regen();  //Regenmesser
      Sensor_Temp_Zelle(1);
      s_alarm = Sensor_Gewicht(0);
      sw_alarm(s_alarm);
    }
    else {
      Sensor_Gewicht(1);
    }
    Daten_Senden(ureq);
    sw_alarm_int();
  }
  Alarm_konfigurieren();
  //print_info();
  debugflush();
  debugend();
  Serial_rxtx_off();

  System_Off();
  SleepNow();
}
//#########################################################
