
/****************************************************************/
// Funktion ESP8266 WLAN  ThingSpeak

/****************************************************************/

// 04.01.2024 ThingsSpeak Variante


/****************************************************************/
// Konfiguration ESP-8266-01 WLAN
/****************************************************************/
#define ESP_Baudrate 9600
#include "ESP_beelogger.h"
C_WLAN_ESP01 dfue;

#define SERVER_TM_OUT 10000 // 10000 = 10 sec
/****************************************************************/


/****************************************************************/
// Parameter Datenversand via Http // diese nicht modifizieren
/****************************************************************/
const char Str_Http[]    PROGMEM = " HTTP/1.1\r\n";
const char Str_Con_cls[] PROGMEM = "Connection: close\r\n\r\n";

/****************************************************************/

/**
  @brief Utility functions
  stop_DFUe_device(): ESP8266 Reset aktiv
  dfue_rxtx_off():  Serial TX/RX dfiniert setzen

  @param  none, globale Variablen
  @return  none
*/
void stop_DFUe_device() {
  digitalWrite(ESP_RESET, LOW);    // ESP8266 "off"
  pinMode(ESP_RESET, OUTPUT);
}

void dfue_rxtx_off() {
  digitalWrite (ESP_RX, LOW);
  digitalWrite (ESP_TX, LOW);
}


/**
  @brief Funktion ESP8266 Setup_WLAN()
  initialisere ESP8266,
  Verbinde zum WLAN AP

  @param  none, globale Variablen
  @return  number of Access Point used
*/
uint8_t Setup_WLAN() {
  char parameter[80], data[32];
  uint8_t AP_Nr = 0;

  digitalWrite(ESP_RESET, HIGH);
  calldelay(500);

  debugprintlnF("ESP?");
  debugflush();

  for ( int x = 0; x < Anzahl_AP; x++) {
    if (dfue.init(ESP_Baudrate)) {
      if (x == 1) {
        strcpy_P(parameter, Access_Point2);
        strcpy_P(data, AP_Passwort_2);
      }
      else {
        strcpy_P(parameter, Access_Point1);
        strcpy_P(data, AP_Passwort_1);
      }

      debugprintln(parameter);
      debugflush();

      if (dfue.join(parameter, data, 10000)) { // WLAN verbinden
        //dfue.sleep(0); // 0 = NoSleep, 2 = Modem Sleep

        debugprintlnF("WLAN!");

        AP_Nr = x + 1; // AP_nr merken
        break;
      }
      else {
        calldelay(500);
        dfue.quit();

        debugprintlnF("Fehler");

      }
    }
  }
  return (AP_Nr);
}


/**
  @brief Funktion ESP8266 Send_data()
  verbinde zum Server, lese Daten aus EE-Prom,
  übertrage Daten, Server-Quittung auswerten
  Fehlerbehandlung bei der Übertragung
  Setze aus Serverquittung:
  - Zeit in DS3231
  - Messintervall
  - Sendeintervall

  @param  count:: Anzahl Datensätze zu übertragen, globale Variablen
  @return  senden erfolgreich > 0
*/
boolean Send_Data(uint8_t count) {
  char parameter[80];
  //uint8_t additonal_Data = 0; // erzeuge zusätzlichen Datensatz
  uint8_t i = 0, s_cnt = 0;          // send counter
  uint8_t AP_Nr;

  //uint16_t pos;
  uint8_t data_send;    // send status
  uint8_t retry;        // retry counter

  AP_Nr = Setup_WLAN();
  if (AP_Nr != 0) { // Connect to access point

    strcpy_P(parameter, ESP_STATUS);
    while ( i < 5 ) { // WLAN abfragen
      if (dfue.sendCommand(parameter, 3000, "S:2")) {

        debugprintlnF("WLAN*");
        debugflush();

        dfue.espState = ESP_WLAN_READY;
        break;
      }

      debugxprintF("WLan?");

      calldelay(2000);
      i++;
    }

    if (Service < 90.0) {    // only if not UserService
      // Signalstärke AP, braucht ca. 10 Sekunden mit 150mA Strom
      if (report_info) {
        if (AP_Nr == 2) {
          strcpy_P(parameter, Access_Point2);
        }
        else {
          strcpy_P(parameter, Access_Point1);
        }
        if (dfue.signal(parameter)) {         // hole Signalstärke
          strcpy(parameter, dfue.buffer);
          char cc = ',';
          char *pos = strchr(parameter, cc); // suche ','
          if (pos) {
            int pegel = atoi(pos + 1);
            Service = (float) pegel;
            //additonal_Data = 1;
          }

          debugprintF("WLAN [dBm] ");
          debugprintln(Service);
          //debugprintln(dfue.buffer);
          debugflush();

        }
      }
    }

    //*************************
    data_send = 0;
    retry = 0;
    do {                 // Connect and send loop
      data_send = 0;
      strcpy_P(parameter, serverName);
      debugprintln(parameter);
      debugflush();
      if (dfue.Connect(parameter)) { // Server TCP session verbinden

        debugprintlnF("Con");
        debugflush();

        int send_size = (_Send_Sets + 2) * _Daten_Satz_Len;
        if (dfue.prep_send(send_size)) { // fiktive Länge, senden wird mit \0 gestartet
          strcpy_P(parameter, ThingSpeak_Call); // der GET
          dfue.send(parameter);
          debugprint(parameter); debugflush();
          strcpy_P(parameter, ThingSpeak_Write_Key); // API Write Key
          dfue.send(parameter);
          debugprint(parameter); debugflush();

          // erstelle Daten
          dfue.send("&field1="); dtostrf(Gewicht[0], 3, 2, parameter); dfue.send(parameter);
          debugprint("&field1/G0="); debugprint(parameter); debugflush();
          dfue.send("&field2="); dtostrf(Batteriespannung, 3, 1, parameter); dfue.send(parameter);
          debugprint("&field2/Ub="); debugprint(parameter); debugflush();
          dfue.send("&field3="); dtostrf(SensorTemp[Aussenwerte], 3, 1, parameter); dfue.send(parameter);
          debugprint("&field3/TA="); debugprint(parameter); debugflush();
          dfue.send("&field4="); dtostrf(Service, 3, 1, parameter); dfue.send(parameter);
          debugprint("&field4/Svc="); debugprintln(parameter); debugflush();
          //####################################################################
          //
          //   Hier um weitere Felder erweitern
          //
          //####################################################################

          // ende Daten
          strcpy_P(parameter, Str_Http);
          dfue.send(parameter);
          strcpy_P(parameter, serverName);
          dfue.send("Host: ");
          dfue.send(parameter);
          dfue.send("\r\n");
          strcpy_P(parameter, Str_Con_cls);
          dfue.send(parameter);
          dfue.send(0x00); // Startkommando senden

          debugprintlnF("http");
          debugflush();

          if (dfue.sendCommand(0, SERVER_TM_OUT, "200 OK")) { // hat Server Anfrage quittiert ?
            data_send = 1;               // success
            retry = 0;
            s_cnt = 1;
            char *p_buf = strstr(dfue.buffer, "200");  // search string start
            debugprint("Q: "); debugprintln(p_buf); debugflush();
          }
          // received ok *
        }
        // Prep Send
      }
      // Connect
      if (data_send == 0) {  // failed, terminate http session
        retry++;
        dfue.disConnect();

        debugprintF("Retry: ");
        debugprint(retry);
        if (retry == 2)  report_info = 0;  // may be error on measuring field strength
        calldelay(3000);         // wait
      }
    } while ((retry < 2) && (data_send == 0));         // retry TCP Connect and send
    //*************************

    if (dfue.quit()) {     // Wlan trennen, Restart ESP
      //debugprintln(F("end!"));
      //debugflush();
    }
  }
  debugprintF("send: "); debugprintln(s_cnt);
  debugflush();

  calldelay(200);
  dfue.end();
  calldelay(50);
  dfue_rxtx_off();
  digitalWrite(ESP_RESET, LOW);
  return (s_cnt);  // return Sets send, 0 = failed,
}
