/*
 * (C) 2015 Thorsten Gurzan - beelogger.de
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
 
// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter https://beelogger.de

#include <VirtualWire.h>

int ID, Aussendung; 
char StringReceived[80]; 
float TempIn, TempOut, FeuchteIn, FeuchteOut, Licht;
long Gewicht, BienenIn, BienenOut;


void setup() {
  vw_set_rx_pin(2);
  vw_setup(2000);   
  vw_rx_start();      
  Serial.begin(9600);
  Serial.println(F("Starte Empfaenger ..."));
}


void loop() {
  uint8_t buf[VW_MAX_MESSAGE_LEN];
  uint8_t buflen = VW_MAX_MESSAGE_LEN;
  
  if (vw_get_message(buf, &buflen)) {
    
    for (byte i = 0; i < buflen; i++) {
      StringReceived[i] = char(buf[i]);
    }
    
    Serial.println();
    sscanf(StringReceived, "%d,%d,%ld,%ld, %ld, %ld,%ld,%ld,%ld,%ld", &ID, &Aussendung, &TempIn, &TempOut, &FeuchteIn, &FeuchteOut, &Licht, &Gewicht, &BienenIn, &BienenOut); 
    Serial.print(F("ID: "));
    Serial.println(ID);
    Serial.print(F("Aussendung: "));
    Serial.println(Aussendung);
    Serial.print(F("Stocktemperatur: "));
    Serial.println(TempIn);
    Serial.print(F("Aussentemperatur: "));
    Serial.println(TempOut);
    Serial.print(F("Stockluftfeuchte: "));
    Serial.println(FeuchteIn);
    Serial.print(F("Aussenluftfeuchte: "));
    Serial.println(FeuchteOut);    
    Serial.print(F("Beleuchtungsstaerke: "));
    Serial.println(Licht);
    Serial.print(F("Gewicht: "));
    Serial.println(Gewicht);
    Serial.print(F("Bienen In: "));
    Serial.println(BienenIn);
    Serial.print(F("Bienen Out: "));
    Serial.println(BienenOut);
    memset(StringReceived, 0, sizeof(StringReceived));
    delay(5);
  }
}
