/*
 * (C) 2015 Thorsten Gurzan - beelogger.de
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
 
// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter https://beelogger.de

#include <VirtualWire.h>

int ID;
char msg[80];

// Test-Messdaten (regulär kommen die Messdaten von den Sensoren)
float TempIn = 27.25;
float TempOut = 30.75;
float FeuchteIn = 50.20;
float FeuchteOut = 60.70;
float Licht = 100000.80;
long BienenIn = 3200;
long BienenOut = 500;
long Gewicht = 20000;


void setup() {
  vw_set_tx_pin(2); 
  vw_setup(2000);  
}


void loop() {
  ID = random(1000,9999);
  
  for (int i=0; i < 4; i++) {  // Hier kann die Anzahl der zusätzlichen Aussendungen pro Datensatz eingestellt werden
    sprintf(msg, "%d,%d,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld", ID, i+1, TempIn, TempOut, FeuchteIn, FeuchteOut, Licht, Gewicht, BienenIn, BienenOut);
    delay(5); 
    vw_send((uint8_t *)msg, strlen(msg));
    vw_wait_tx();
    delay(100); 
  }
  delay(3000);
}
