//----------------------------------------------------------------
// Sensorkonfiguration
// 1. Sensor für die Abfrage durch den Sketch aktivieren
// 2. aktive Sensoren für Temperatur/Feuchte in der Sensormatrix zuordnen
//----------------------------------------------------------------
#define Anzahl_Sensoren_DHT     0 // Mögliche Anzahl: '0','1','2'  --- Nr 1,2 ---  (Temperatur + Luftfeuchte)
#define DHTTYPE  DHT22   // DHT 22  (AM2302), AM2321  // DHT 21 (AM2301)

#define Anzahl_Sensoren_Si7021  0 // Mögliche Anzahl: '0','1'      --- Nr 3 -----  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_SHT31   0 // Mögliche Anzahl: '0','1','2'  --- Nr 4,5 ---  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_BME280  0 // Mögliche Anzahl: '0','1','2'  --- Nr 6,7 ---  (Temperatur + Luftfeuchte)

#define Anzahl_Sensoren_DS18B20 1 // Mögliche Anzahl: '0','1','2'  --- Nr 8,9 ---  (Nur Temperatur)
                                  // Mögliche Anzahl:     '3','4'  --- Nr 8,9 ---  (im Messwert Luftfeuchte)


// 2. Sensormatrix, hier kann die Zuordnung der Sensoren geändert werden
// Nr 1 - 9 aus Liste oben auswählen, wenn kein Sensor gewünscht ist einfach "0" angeben
// wenn kein Sensor für die Aussentemperatur gesetzt ist, wird automatisch der Temperatursensor der RTC verwendet
#define Aussenwerte                               8    // 0 oder Nr. 1 - 11; bei Single:  0 oder Nr. 1 - 8; bei DUO: 0 oder Nr. 1 - 9
// Sensor Beute 1
#define             Beute1                        0    // 0 oder Nr. 1 - 11; bei Single:  0 oder Nr. 1 - 8; bei DUO: 0 oder Nr. 1 - 9
// Sensor Beute 2
#define             Beute2                        0    // 0 oder Nr. 1 - 11; bei DUO: 0 oder Nr. 1 - 9


// Temperatur Wägezelle (nur Duo, Tripple, Quad usw.)
// Sensor, der die Temperatur der Wägezelle erfasst;  vorbelegt der erste DS18B20
// für Systeme mit einer Waage identisch zum Sensor Aussenwerte eintragen
#define             Temp_Zelle                    8    // Nr. 0 - 11, nur DUO



//----------------------------------------------------------------
// weitere Sensoren
//----------------------------------------------------------------

#define Anzahl_Sensoren_Bienenzaehler 0 // Mögliche Anzahl: '0','1','2','3','4'
#define Neue_Bienenzaehlfunktion      0 // Mögliche Werte: '0','1'  1 = neues Verfahren


#define Anzahl_Sensoren_Licht   0  // Mögliche Anzahl: '0','1'  


//----------------------------------------------------------------
// Konfiguration Waage
//----------------------------------------------------------------

#define Anzahl_Sensoren_Gewicht 1 // Mögliche Anzahl: '0','1','2'

// Anschluss / Konfiguration Wägezellen-------------------------------------------------------
// mit Anzahl_Sensoren_Gewicht 1    
//   HX711(1) Kanal A = Wägeelement(e) Waage1;   Serverskript: beeloggerY


//--------------------------------------------------------------------------------------------
// Kalibrierwerte für die Wägezellen
const long Taragewicht[2] = { 10, 10 }; // Hier ist der Wert aus der Kalibrierung einzutragen
const float Skalierung[2] = { 1.0, 1.0 }; // Hier ist der Wert aus der Kalibrierung einzutragen

//--------------------------------------------------------------------------------------------
// Kalibrierwerte für die Spannungsmessung Akku
const long Kalib_Spannung = 1000;    // Hier muss der Wert aus der Kalibrierung eingetragen werden, sonst funktioniert der Programmcode nicht
const long Kalib_Bitwert  =  100;    // Hier muss der Wert aus der Kalibrierung eingetragen werden, sonst funktioniert der Programmcode nicht
//----------------------------------------------------------------


//----------------------------------------------------------------
// LAN Parameter
// Hier muss eine eigene IP-Adresse, Gateway und DNS eingetragen werden, 
// wenn die Netzwerkkonfiguration nicht über DHCP bezogen wird.
// Sofern nicht mehrere Ethernet-Apdater gleichzeitig verwendet werden, 
// braucht die MAC-Adresse nicht geändert werden.
// Bitte darauf achten, dass die MAC-/IP-Adressen im Netzwerk nicht doppelt vergeben sind.
#include <Ethernet.h>
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
IPAddress ip {192,168,0,10};
IPAddress gateway {192,168,0,1};
IPAddress dnServer {192,168,0,1};


// Domainname zum Webserver mit beelogger-Skript
const char serverName[] PROGMEM = "community.beelogger.de"; //"meineDomain.de";

// GET mit Verzeichnis auf dem Webserver und PHP-Skript für den jeweiligen beelogger
// Mit Anzahl_Sensoren_Gewicht
// 0/1 - Bsp: "GET /USERX/beelogger1/beelogger_log.php?"

const char beelogger_pfad[] PROGMEM = {"GET /USERX/beeloggerY/beelogger_log.php?"};   // "USERX" und "beeloggerY" ersetzen

// Passwort vom Webserver-Skript
const char Passwort[] PROGMEM = "Log";  // hier dein beelogger-log - Passwort
//----------------------------------------------------------------


//----------------------------------------------------------------
// Allgemeine Konfiguration
//----------------------------------------------------------------
#define WeckIntervall_default 15
#define AlternativIntervallMinuten  120  // Weckinterval, wenn VAlternativ erreicht
// Li-Ion Akku beelogger-Solar
const float VAlternativ = 3.8;       // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
const float VMinimum    = 3.75;      // Minimale Spannung ab der ab der keine Messungen und auch kein Versand von Daten erfolgt

// 6V PB-Akku beelogger-Universal
//const float VAlternativ = 5.9;       // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum    = 5.7;       // Minimale Spannung ab der ab der keine Messungen und auch kein Versand von Daten erfolgt

// 12V PB-Akku beelogger-Universal
//const float VAlternativ = 11.9;     // Minimale Spannung ab der automatisch das alternative Intervall aktiviert wird
//const float VMinimum = 11.5;        // Minimale Spannung ab der keine Messungen und auch kein Versand von Daten erfolgt
//----------------------------------------------------------------


// Wartezeit ohne Messungen wenn Schalter Arbeiten am Bienenvolk dauernd aktiv
// Zeit in Minuten, 5 Minuten Schritte
#define USER_INT_TM    30
