//----------------------------------------------------------------
// Konfiguration Ethernet - Internet
//----------------------------------------------------------------
// 26.03.2020
// 17.07.2020 Checksumme
// 30.06.2024 Zuordnung Aux[]
// 12.01.2025 Send A=1 obsolete


EthernetClient client;


//----------------------------------------------------------------
// Setup Ethernet - Internet
//----------------------------------------------------------------
void setup_Ethernet() {


  // Für Verwendung der Konfiguration über DHCP
  if (Ethernet.begin(mac) == 0) debugprintln("Fehler bei der Konfiguration des Ethernet-Adapters ueber DHCP");
      debugflush();

  // Ethernet.begin(mac, ip, dnServer, gateway);  // Für Verwendung der Werte der allgemeinen Konfiguration

  delay(1000);
  //----------------------------------------------------------------
}



//----------------------------------------------------------------
// Funktion Ethernet - Internet
//----------------------------------------------------------------
void  Daten_Senden() {
  char parameter[80], data[24];
  float Checksum =  SensorTemp[Beute1]  +  SensorTemp[Aussenwerte];
  Checksum +=  SensorFeuchte[Beute1]  +  SensorFeuchte[Aussenwerte];
  Checksum +=  Licht +  Gewicht[0] + Service;

  for (byte i = 0; i < 5; i++) { // Anzahl der Wiederholungen bei Verbindungsproblemen
    // oder korrupten Daten, die vom Webserver empfangen werden
    strcpy_P(parameter, serverName);
    debugprintln(parameter);
    debugflush();
    if (client.connect(parameter, 80)) {

      strcpy_P(parameter, beelogger_pfad); // der GET in einen Stück bis zum '?'
      client.print(parameter);
      debugprint(parameter);
      debugflush();

      client.print ("PW=");
      strcpy_P(parameter, Passwort);
      client.print(parameter);

      debugprint ("PW=");
      debugprint(parameter);
      debugflush();

      // System ID
      client.print ("&ID=");
      strcpy(parameter, ID_ID);
      client.print(parameter);
      debugprint ("&ID=");
      debugprint(parameter);
      debugflush();

      client.print ("&T1=");
      dtostrf(SensorTemp[Beute1], 3, 1, data);
      client.print (data);

      debugprint ("&T1=");
      debugprint(data);
      debugflush();

      client.print ("&TO=");
      dtostrf(SensorTemp[Aussenwerte], 3, 1, data);
      client.print (data);

      debugprint ("&TO=");
      debugprint(data);
      debugflush();

      client.print ("&F1=");
      dtostrf(SensorFeuchte[Beute1], 3, 1, data);
      client.print (data);

      debugprint ("&F1=");
      debugprint(data);
      debugflush();

      client.print ("&FO=");
      dtostrf(SensorFeuchte[Aussenwerte], 3, 1, data);
      client.print (data);

      debugprint ("&FO=");
      debugprint(data);
      debugflush();

      client.print ("&L=");
      dtostrf(Licht, 3, 1, data);
      client.print (data);

      debugprint ("&L=");
      debugprint(data);
      debugflush();

      client.print ("&G1=");
      dtostrf(Gewicht[0], 3, 1, data);
      client.print (data);

      debugprint ("&G1=");
      debugprint(data);
      debugflush();

#if (Anzahl_Sensoren_Gewicht == 2)
      client.print ("&G2=");
      dtostrf(Gewicht[1], 3, 1, data);
      client.print (data);

      debugprint ("&G2=");
      debugprint(data);
      debugflush();

      client.print ("&F2=");
      dtostrf(SensorFeuchte[Beute2], 3, 1, data);
      client.print (data);

      debugprint ("&F1=");
      debugprint(data);
      debugflush();

      client.print ("&T2=");
      dtostrf(SensorTemp[Beute2], 3, 1, data);
      client.print (data);

      debugprint ("&T1=");
      debugprint(data);
      debugflush();

      client.print ("&W=");
      dtostrf(SensorTemp[Temp_Zelle], 3, 1, data);
      client.print (data);

      debugprint ("&W=");
      debugprint(data);
      debugflush();

      Checksum +=  Gewicht[1] + SensorTemp[Temp_Zelle] + SensorTemp[Beute2] + SensorFeuchte[Beute2];
#endif



      //if ((Aux[0] != No_Value) || Neue_Bienenzaehlfunktion) {        client.print("&A=1");}  // Aux-Werte senden, obsolete

      if (Aux[0] != No_Value) {
        Checksum += Aux[0];
        client.print ("&A1=");  // Luftdruck
        dtostrf(Aux[0], 4, 1, data);
        client.print (data);
      }

      long Check = (long)Checksum;

#if Neue_Bienenzaehlfunktion
      Check += BienenInTacho;
      ltoa(BienenInTacho, data, 10);
#else
      Check += BienenIn;
      ltoa(BienenIn, data, 10);
#endif
      client.print ("&I=");
      client.print (data);

      debugprint ("&BienenIn=");
      debugprint(data);
      debugflush();

#if Neue_Bienenzaehlfunktion
      Check += BienenOutTacho;
      ltoa(BienenOutTacho, data, 10);
#else
      Check += BienenOut;
      ltoa(BienenOut, data, 10);
#endif
      client.print ("&O=");
      client.print (data);

      debugprint ("&BienenOut=");
      debugprint(data);
      debugflush();

#if (Neue_Bienenzaehlfunktion)
      Checksum += BienenIn;
      ltoa(BienenIn, data, 10);
      client.print ("&A2=");  // BienenIn
      client.print (data);

      Checksum += BienenOut;
      ltoa(BienenOut, data, 10);
      client.print ("&A3=");  // BienenOut
      client.print (data);
#endif

      client.print ("&S=");
      dtostrf(Service, 3, 1, data);
      client.print (data);

      debugprint ("&S=");
      debugprint(data);
      debugflush();

      client.print ("&C=");
      ltoa(Check, data, 10);
      client.print (data);

      debugprint ("&S=");
      debugprint(data);
      debugflush();

      client.println (" HTTP/1.1");
      client.print("Host: ");
      strcpy_P(parameter, serverName);
      client.println(parameter);

      client.println("Connection: close");
      client.println();

      debugprintln(" ");
      debugflush();

      LogDelay(1000);
    }

    unsigned long start = millis();
    char  c;
    while ((millis() - start < 2000) and (client.connected() )) {
      c = client.read();
      debugprint (c);
      if (c == '*') {
        i = 10;
        if (Anzahl_Sensoren_Bienenzaehler != 0) {
          BienenIntervall = millis();  // Marc: TachoZeit auf Reset
          BienenIn = 0;
          BienenOut = 0;
        }
      }
    }
    Sensor_Bienen();

    client.stop();
    client.flush();

    debugprintln(" ");
    debugflush();
    LogDelay(1000);
  }

}
//----------------------------------------------------------------
