/*
   (C) 2024 R.Schick - beelogger.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// beelogger.de - Arduino Datenlogger für Imker
// Erläuterungen dieses Programmcodes unter http://beelogger.de

// 30.06.2024 Zuordnung Aux[]

char ID_ID[] = "MULTI_LAN_BZ_260126";  //nur Grossbuchstaben,Zahlen, keine Blanks


#include "Multi_LAN_BZ_config.h"     // Konfiguration und Kalibrierung eintragen
#include "beelogger_config_BZ.h"


//----------------------------------------------------------------
// Variablen
//----------------------------------------------------------------
const float No_Val = 99.9;   // Vorbelegung, Wert nicht gemessen
const float No_Value = -1.0; // Vorbelegung, Wert nicht gemessen

//                     KeinSensor DHT1, DHT2,   Si7021, SHT31a, SHT31b, BMEa,   BMEb,  DS18B20a,DS18B20b
float SensorTemp[12] = {No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val, No_Val};

//                        KeinSensor  DHT1,    DHT2,     Si7021,   SHT31a,   SHT31b,   BMEa,     BMEb.   KeinSensor KeinSensor
float SensorFeuchte[10] = {No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value, No_Value};

//              Luftdruck
float Aux[2] = {No_Value, No_Value};

float DS_Temp = No_Val;
float Licht = No_Value;
float Gewicht[2] = {No_Value, No_Value};
float LetztesGewicht[2] = {No_Value, No_Value};

float Service = No_Value;
//DateTime aktuell;

byte report_info = 0; // 0 = time-On, 1 = WLan-Pegel

int WeckIntervallMinuten = WeckIntervall_default;

byte SensorAktuell[16];
byte LetzterSensor[Anzahl_Sensoren_Bienenzaehler][16];
byte TunnelZustand[Anzahl_Sensoren_Bienenzaehler][8];
byte TunnelZuvor = 0;

byte AP_nr = 0;
uint32_t LetztesIntervall = 0;
uint32_t LogDelayZeit;
uint32_t BienenIntervall;

int BienenIn = 0;
int BienenOut = 0;
int BienenInTacho = 0;
int BienenOutTacho = 0;

uint32_t SpeicherIntervall = 300; // Speicherintervall / Versand
uint32_t switch_active = 0;
//----------------------------------------------------------------



void setup() {

  debugbegin(Serial_Baudrate);
  debugprintln(ID_ID);

  //----------------------------------------------------------------
  // System On
  //----------------------------------------------------------------
  digitalWrite(Power_Pin, HIGH);
  pinMode(Power_Pin, OUTPUT);
  delay(5);
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  // Setup Ethernet Adapter
  //----------------------------------------------------------------
  setup_Ethernet();
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  //  Schalter an D2
  //----------------------------------------------------------------
  pinMode(DS3231_Interrupt_Pin, INPUT_PULLUP);
  delay(5);
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  // Setup Sensors
  //----------------------------------------------------------------
  setup_sensors();
  //----------------------------------------------------------------
}


//################################################################
void loop() {
  Sensor_DS18B20();
  Sensor_Bienen();
  Sensor_DHT();
  Sensor_Bienen();
  Sensor_Si7021();
  Sensor_Bienen();
  Sensor_SHT31();
  Sensor_Bienen();
  Sensor_BME280();
  Sensor_Bienen();
  Sensor_Licht();
  Sensor_Bienen();
  Sensor_Gewicht(false);
  Sensor_Bienen();
  BienenTachoCalc();
  Daten_Senden();
  LetztesIntervall = millis();
  while ((millis() - LetztesIntervall) <= (SpeicherIntervall * 1000)) {
    User_Switch_req();
    Sensor_Bienen();
  }
}
//################################################################



//----------------------------------------------------------------
// Funktion LogDelay:
// im idle Bienezähler abfragen
//----------------------------------------------------------------
void LogDelay(unsigned long Zeit) {
  LogDelayZeit = millis();

  while ((millis() - LogDelayZeit) < (Zeit)) {
    Sensor_Bienen();
  }
}
//----------------------------------------------------------------

/**
  @brief Funktion User_Switch_req

  check if User Switch has been set
  wait preconfigured time, just wait
  if still set after that, ignore switch and continue

  @param  #define USER_INT_TM   xx minutes
  @return  none
*/
void User_Switch_req() {  // User switch is set

#if (USER_INT_TM > 150)  // Limit Service switch time, important!
#undef USER_INT_TM
#define USER_INT_TM 150
#warning " USER_INT_TM  set to  150 minutes !"
#endif
  uint8_t break_info = 1;

  if (digitalRead(DS3231_Interrupt_Pin) == true) {      // switch on?

    if (switch_active  < ((USER_INT_TM * 60) / 3)) { // Switch was not on?
      // USER_INT_TM in Minuten, umrechnen in Sekunden, teilen durch delay time
      debugprintln("Arbeitsschalter aktiv: System Stopp!");
      blink_LED(1, 500);  // signal we've noticed

      while ((digitalRead(DS3231_Interrupt_Pin) == true) && break_info) {   // wait for switch off
        delay(3000);                          // wait
        Service += 3.0;                       // increment Service value
        if (switch_active == 0) {             // first time only
          // User Service
          blink_LED(4, 200);                  // signal we've noticed
          switch_active = 1;
        }
        else {
          // "switch is set", when still on and time is not up
          if (switch_active  < ((USER_INT_TM * 60) / 3 )) {
            switch_active++; // only increment within predefined period
          }
          else {  // time exceeded, stop waiting
            break_info = 0; // stopp while
          }
        }
      }  // while
    }    // switch_active ?
    debugprint ("sw:");
    debugprintln (switch_active);
  }
  else {

    switch_active = 0;
  }
}
//----------------------------------------------------------------


/**
  @brief Funktion blink_LED

  on board LED an Pin PC13 blink

  @param  Anzahl, Zeitdauer an/aus
  @return  none
*/
void blink_LED(uint8_t nmr, uint16_t bl_tm) {
  pinMode(13, OUTPUT);
  for (int i = 0; i < nmr; i++) {
    digitalWrite(13, LOW);  delay(bl_tm); // LED an
    digitalWrite(13, HIGH);  delay(bl_tm);
  }
  pinMode(13, INPUT);
}
