//08.04.2020  delay in DS18B20
//13.04.2020  Duo-System
//18.06.2020  var default in DS18B20
//03.07.2020  Korrektur Luftdruck auf Standort
//18.07.2020  ignoriere Waagen ohne Kal-Werte
//02.09.2020  Waagen ohne Kal-Werte
// 25.10.2020  Temperatur Waegezelle
// 30.12.2020  neue HX711 Lib
// 03.01.2021  neue HX711 Lib
// 01.03.2021  DS18B20 Zuordnung
// 04.10.2021 HX711 adresss struct
// 06.05.2022 DHT delay
// 23.06.2022 SI7021 value check
// 28.01.2023 use Adafuit DHT lib
// 18.02.2023 wait for stable HX711
// 15.04.2023 BME-/DHT- beelogger-Libs
// 15.05.2023 BH1750 I2C Adressierung
// 30.06.2024 Zuordnung Aux[]

//----------------------------------------------------------------
// Konfiguration Gewicht
//----------------------------------------------------------------
#include <HX711.h>
//----------------------------------------------------------------
#include <Wire.h>

//----------------------------------------------------------------
//Konfiguration Bienenzähler
//----------------------------------------------------------------
#include <Adafruit_MCP23017.h>
Adafruit_MCP23017 mcp[Anzahl_Sensoren_Bienenzaehler];
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion Temperatur Wägezelle
//----------------------------------------------------------------
void Sensor_Temp_Zelle_BZ(uint8_t set) {
  if (set) {
    DS_Temp = SensorTemp[Temp_Zelle];    // duo, tripple, quad, ...
    if (SensorTemp[Aussenwerte] == No_Val) { // single, force
      SensorTemp[Aussenwerte] = DS_Temp;
    }
  }
  else {
    DS_Temp = No_Val;
    SensorTemp[Aussenwerte] = No_Val;
  }
}
//----------------------------------------------------------------



//----------------------------------------------------------------
// Funktion Gewicht
//----------------------------------------------------------------
void Sensor_Gewicht(uint8_t quick) {

#if ((Anzahl_Sensoren_Gewicht > 0) && (Anzahl_Sensoren_Gewicht < 3))

  const float Diff_Gewicht = 0.5;

  HX711 scale;
  scale.begin(HX711_DT[0], HX711_SCK[0], 128); // Nr.1 Kanal A
  for (int i = 0; i < Anzahl_Sensoren_Gewicht; i++) {
    if (i == 1) {
      scale.set_gain(32);  // Nr.1 Kanal B
    }
    if (Taragewicht[i] != 10) {
      scale.power_up();
      uint8_t count = 0, retries = 5;
      while (count < retries) {
        LogDelay(600);  // wait for HX711
        if (scale.is_ready()) {
          break;
        }
        count++;
      }
      if (count < 5) { // scale found
        scale.read(); // set gain using read
        LogDelay(600);  // wait for stable HX711
        for (byte j = 0 ; j < 2; j++) { // Anzahl der Wiederholungen, wenn Abweichung zum letzten Gewicht zu hoch
          long l_gew = scale.read_average(10) - Taragewicht[i];
          Gewicht[i] = ((float) l_gew) / Skalierung[i];
          if (quick) {
            LetztesGewicht[i] = Gewicht[i];
            break;
          }
          if (fabs(Gewicht[i] - LetztesGewicht[i]) < Diff_Gewicht) break; // Abweichung für Fehlererkennung
          LogDelay(2000); // Wartezeit zwischen Wiederholungen
        }
        LetztesGewicht[i] = Gewicht[i];
      }
      else {
        Gewicht[i] = No_Value; // Fehler
        debugprintF(" W fail");
      }
    }

    if (i == 1) {  // 2 Waagen
      scale.power_down();
    }
    else if ((i == 0) && (Anzahl_Sensoren_Gewicht == 1)) { // nur 1 Waage
      scale.power_down();
    }

    debugprintF(" W ");
    debugprint(i + 1);
    debugprintF(" [kg]: ");
    debugprintln(Gewicht[i]);
    debugflush();

  }
#endif
}

//----------------------------------------------------------------

//----------------------------------------------------------------
// Funktion Bienenzähler
//----------------------------------------------------------------
void BienenTachoCalc() {
#if (Anzahl_Sensoren_Bienenzaehler > 0)
  uint32_t tmptime = ( millis() -  BienenIntervall);
  BienenOutTacho = (int)(( -0.49 + (60000.0 / (float)tmptime) * (float)BienenOut));
  BienenInTacho  = (int)(( 0.49 + (60000.0 / (float)tmptime) * (float)BienenIn));

  debugprint((int)(tmptime / 1000)); debugprintln(" sec");
  debugprint("Bienen in Summe (raus | rein): "); debugprint(BienenOut); debugprint(" | "); debugprintln(BienenIn);
  debugprint("Bienen je min   (raus | rein): "); debugprint(BienenOutTacho); debugprint(" | "); debugprintln(BienenInTacho);
#endif
}
//----------------------------------------------------------------

//----------------------------------------------------------------
// Funktion Bienenzähler
//----------------------------------------------------------------
void Sensor_Bienen() {
#if ((Anzahl_Sensoren_Bienenzaehler > 0) and (Anzahl_Sensoren_Bienenzaehler < 5))
  for (byte j = 0; j < Anzahl_Sensoren_Bienenzaehler; j++) {

    for (byte i = 0; i < 16; i++) {
      SensorAktuell[i] = mcp[j].digitalRead(i);
      /*
              debugprint("Bienensensor Nr.:  ");
              debugprint(i + 1);
              debugprint("  Messwert:  ");
              debugprintln(SensorAktuell[i]);
              debugflush();
      */
    }
#if Neue_Bienenzaehlfunktion  // neue Methode  Bienenzählfunktion
    for (byte i = 0; i < 8; i++) {
      TunnelZuvor = TunnelZustand[j][i];
      if ((SensorAktuell[i] == 0) && ( SensorAktuell[i + 8] == 0 )) {
        if ( TunnelZustand[j][i] == 3) {
          BienenOut--;
#if myDEBUG
          debugprintln("Biene raus !");
          BienenTachoCalc();
#endif
        }
        else if ( TunnelZustand[j][i] == 13) {
          BienenIn++;
#if myDEBUG
          debugprintln("Biene rein !");
          BienenTachoCalc();
#endif
        }
        TunnelZustand[j][i] = 0;
      }
      else if ((SensorAktuell[i] == 0) && ( SensorAktuell[i + 8]) == 1 ) {
        if   (( TunnelZustand[j][i] == 0 ) || (TunnelZustand[j][i] == 2 )) TunnelZustand[j][i] = 1;
        else if ( TunnelZustand[j][i] == 12 ) TunnelZustand[j][i] = 13;
      }
      else if ((SensorAktuell[i] == 1) && ( SensorAktuell[i + 8]) == 1 ) {
        if   (( TunnelZustand[j][i] == 1 ) ||  ( TunnelZustand[j][i] == 3 )) TunnelZustand[j][i] = 2;
        else if (( TunnelZustand[j][i] == 11 ) || ( TunnelZustand[j][i] == 13 )) TunnelZustand[j][i] = 12;
      }
      else if ((SensorAktuell[i] == 1) && ( SensorAktuell[i + 8]) == 0 ) {
        if   ( TunnelZustand[j][i] == 2 ) TunnelZustand[j][i] = 3;
        else if (( TunnelZustand[j][i] == 0 ) || (TunnelZustand[j][i] == 12 ))  TunnelZustand[j][i] = 11;
      }
#if myDEBUG
      if (TunnelZustand[j][i] != TunnelZuvor) {
        debugprint(TunnelZuvor); debugprint("->"); debugprintln(TunnelZustand[j][i]);
      }
#endif
    }

#else  // alte Bienenzählfunktion
    for (byte i = 0; i < 8; i++) {
      if (SensorAktuell[i] != LetzterSensor[j][i]) {
        if (SensorAktuell[i] > SensorAktuell[i + 8]) {
          if (BienenIn == -1) BienenIn = 1;
          else  BienenIn++;
        }
      }
      if (SensorAktuell[i + 8] != LetzterSensor[j][i + 8]) {
        if (SensorAktuell[i + 8] > SensorAktuell[i]) {
          if (BienenOut == -1) BienenOut = 1;
          else BienenOut++;
        }
      }
      LetzterSensor[j][i] = SensorAktuell[i];
      LetzterSensor[j][i + 8] = SensorAktuell[i + 8];
    }
#endif
  }
  delay(10);
#endif
}
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion DS18B20 - Temperatur
//----------------------------------------------------------------
# if ((Anzahl_Sensoren_DS18B20 > 0) and (Anzahl_Sensoren_DS18B20 < 5))

#include <OneWire.h>


void Sensor_DS18B20() {  // search sensors and read out data

#define STARTCONVERSION  0x44  // Tells device to take a temperature reading and put it on the scratchpad
#define READSCRATCH      0xBE  // Read DS18B20
#define CRC_SCRATCH       8
  // #define Sensor_Aufloesung 12//  default is 12 bit

  uint8_t DS18B20_Adresse[8];  // DS18B20 ID
  float Temperatur_DS;
  int16_t temp_ds;
  uint8_t parasite = 0;  // need 5V on the sensor
  uint8_t scratchPad[9];
  uint8_t devices = 0;

  debugprintlnF("DS18B20");

  OneWire my_O_Wire(ONE_WIRE_BUS);

  //  my_O_Wire.reset_search();

  while (my_O_Wire.search(DS18B20_Adresse)) { // search devices
    if (my_O_Wire.crc8(DS18B20_Adresse, 7) == DS18B20_Adresse[7]) {
      devices++;
    }
  }

  // send command for all devices on the bus to perform a temperature conversion
  my_O_Wire.reset();
  my_O_Wire.skip();
  my_O_Wire.write(STARTCONVERSION, parasite);

  LogDelay(1000); // wait for conversion, 12 bit resolution needs at least 750ms

  if (devices >= Anzahl_Sensoren_DS18B20) {
    devices = Anzahl_Sensoren_DS18B20;
  }

  for (uint8_t i = 0; i < devices; i++) {
    Temperatur_DS = No_Val;
    if (my_O_Wire.search(DS18B20_Adresse)) { // search next
      if (my_O_Wire.crc8(DS18B20_Adresse, 7) == DS18B20_Adresse[7]) { // valid?
        //print_DS_adress(DS18B20_Adresse);

        my_O_Wire.reset();
        my_O_Wire.select(DS18B20_Adresse);
        my_O_Wire.write(READSCRATCH);        // read scratchpad
        // Read all registers in a simple loop
        // byte 0: temperature LSB
        // byte 1: temperature MSB
        // byte 2: high alarm temp
        // byte 3: low alarm temp
        // byte 4: DS18S20: store for crc
        //         DS18B20 & DS1822: configuration register
        // byte 5: internal use & crc
        // byte 6: DS18S20: COUNT_REMAIN
        //         DS18B20 & DS1822: store for crc
        // byte 7: DS18S20: COUNT_PER_C
        //         DS18B20 & DS1822: store for crc
        // byte 8: SCRATCHPAD_CRC
        for (uint8_t k = 0; k < 9; k++) {
          scratchPad[k] = my_O_Wire.read();
        }
        my_O_Wire.reset();

        if (my_O_Wire.crc8(scratchPad, CRC_SCRATCH) == scratchPad[CRC_SCRATCH]) {  // if CRC o.k.
          temp_ds = (((int16_t)scratchPad[1]) << 8) | ((int16_t)scratchPad[0]);    // MSB + LSB
          Temperatur_DS = (float)temp_ds;         
          Temperatur_DS = (Temperatur_DS / 16.0);                                  // 12Bit = 0,0625 C per Bit (-> divide by 16)
        }
        else {
          debugprintln("Fehler");
        }
      } // crc
    } // search

    // Zuordnung Sensorwerte
    if (i == 4) { // der fünfte DS18B20
      SensorTemp[0] = Temperatur_DS;  // 5. DS18B20 in Temp [0]
    }
    else {
      SensorTemp[8 + i] = Temperatur_DS; // 8,9,10,11
    }

#if (Anzahl_Sensoren_Gewicht < 3) // Single/Double System
#if (Anzahl_Sensoren_DS18B20 == 2) // 2 DS18B20
    SensorFeuchte[8] = Temperatur_DS;  // 2. DS18B20 in Feuchte[]
#else
    if (i == 2) { // 3. DS18B20
      SensorFeuchte[8] = Temperatur_DS;  // 3. DS18B20 in Feuchte[]
    }
    if (i == 3) { // 4. DS18B20
      SensorFeuchte[9] = Temperatur_DS;  // 4. DS18B20 in Feuchte[]
    }
#endif
#endif

  } // for
}
#else
void Sensor_DS18B20() {};
#endif
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion DHT21 / DHT22 - Temperatur und Luftfeuchte
//----------------------------------------------------------------
#if ((Anzahl_Sensoren_DHT == 1) || (Anzahl_Sensoren_DHT == 2))

#include <beelogger_DHT.h>

void Sensor_DHT() {

  debugprintF(" DHT:  ");
  debugprintln(Anzahl_Sensoren_DHT);
  debugflush();

  float Temperatur_DHT = No_Val;
  float Luftfeuchte_DHT = No_Value;

  for (byte i = 0 ; i < Anzahl_Sensoren_DHT; i++) {
    beelogger_DHT dht(DHT_Sensor_Pin[i], DHTTYPE);
    dht.begin();
    uint8_t x = 0;
    do {
      LogDelay(2000);     // Wait a few seconds between measurements.
      Temperatur_DHT = dht.readTemperature();    // Read temperature as Celsius (the default)
      Luftfeuchte_DHT = dht.readHumidity();

      x--;
      if (x == 0) break;
      debugprintF("*");
    } while (((Temperatur_DHT == 1.0) && (Luftfeuchte_DHT == 1.0)) ||
             (Temperatur_DHT < -30.0) || (Luftfeuchte_DHT == 0.0));

    // Check if any reads failed
    if (isnan(Temperatur_DHT) || (Temperatur_DHT < -30.0) || (Temperatur_DHT > 60.0)) Temperatur_DHT = No_Val;
    if (isnan(Luftfeuchte_DHT) || (Luftfeuchte_DHT < 2.0) || (Luftfeuchte_DHT >= 99.9)) Luftfeuchte_DHT = No_Value;

    if (i == 0) { // der erste DHT
      SensorTemp[1] =    Temperatur_DHT;
      SensorFeuchte[1] = Luftfeuchte_DHT;
    }
    if (i == 1) { // der zweite DHT
      SensorTemp[2] =    Temperatur_DHT;
      SensorFeuchte[2] = Luftfeuchte_DHT;
    }

    debugprintF(" Temperatur  ");
    debugprint(i + 1);
    debugprintF(" [C]: ");
    debugprintln(Temperatur_DHT);
    debugprintF(" Feuchte   ");
    debugprint(i + 1);
    debugprintF(" [%RH]: ");
    debugprintln(Luftfeuchte_DHT);
    debugflush();

  }
}
#else
void Sensor_DHT() {};
#endif
//----------------------------------------------------------------


//----------------------------------------------------------------
// Funktion Beleuchtungsstärke
//----------------------------------------------------------------
#if (Anzahl_Sensoren_Licht == 1)
#include <AS_BH1750.h>

void Sensor_Licht() {


  debugprintF(" BH1750 ");
  debugflush();
  Licht = No_Value;

  Wire.beginTransmission(BH1750_ADRESS); //BH1750
  uint8_t error = Wire.endTransmission();
  if (error == 0) {
    AS_BH1750 sensor(BH1750_ADRESS);
    uint8_t check = sensor.begin();
    if (check) {
      Licht = sensor.readLightLevel();

      debugprintF(" Licht [lux]: ");
      debugprintln(Licht);
    }
  }
  else {
    debugprintln(F("Fehler"));
  }
  debugflush();
}
#else
void Sensor_Licht() {};
#endif
//----------------------------------------------------------------


/**
  @brief Funktion Si7021 - Temperatur und Luftfeuchte
  @param  globale #define
  @return  none, setzt globale Variablen
*/
// Auswahl der Library
#define SI7021_Type 0  // 0 = Adafruit Lib, 1 = SI7021 Lib Marcus Sorensen


#if (Anzahl_Sensoren_Si7021 == 1)

#if SI7021_Type == 1
#include "SI7021.h"
#else
#include "Adafruit_Si7021.h"
#endif

void Sensor_Si7021() {

  debugprintlnF("Si7021");
  debugflush();

#if SI7021_Type
  SI7021 sensor7021;
  int check = sensor7021.begin();
  if (check) {
    int temp = sensor7021.getCelsiusHundredths();
    delay(30);
    unsigned int hum = sensor7021.getHumidityPercent();
    SensorTemp[3] = ((float) temp) / 100.0;
    SensorFeuchte[3]  = ((float) hum );
  }
#else
  Adafruit_Si7021 mySI7021 = Adafruit_Si7021();
  mySI7021.reset(); // not needed?
  SensorTemp[3] = mySI7021.readTemperature();
  if (isnan(SensorTemp[3]))  SensorTemp[3] = No_Val;
  SensorFeuchte[3] = mySI7021.readHumidity();
  if (isnan(SensorFeuchte[3])) SensorFeuchte[3]  = No_Value;
#endif

  debugprintF(" [C]: ");
  debugprintln(SensorTemp[3]);
  debugprintF(" [%RH]: ");
  debugprintln(SensorFeuchte[3]);
  debugflush();
}
#else
void Sensor_Si7021() {};
#endif


//----------------------------------------------------------------
// Funktion SHT31 - Temperatur und Luftfeuchte
//----------------------------------------------------------------
#if ((Anzahl_Sensoren_SHT31 == 1) || (Anzahl_Sensoren_SHT31 == 2))

#include "Adafruit_SHT31.h"

void Sensor_SHT31() {

  debugprintF(" SHT31: ");
  debugprintln(Anzahl_Sensoren_SHT31);
  debugflush();

  float Temperatur_SHT31 = No_Val;
  float Luftfeuchte_SHT31 = No_Value;
  uint8_t check;

  Adafruit_SHT31 my_sht;
  for (byte i = 0 ; i < Anzahl_Sensoren_SHT31; i++) {
    check = my_sht.begin((uint8_t)SHT31_adresse[i]); // I2C Adresse
    LogDelay (500); // time to get system ready
    if (check) { // if SHT ok
      Temperatur_SHT31 = my_sht.readTemperature();
      if (isnan(Temperatur_SHT31)) {
        Temperatur_SHT31 = No_Val;
      }
      else {
        Luftfeuchte_SHT31 = my_sht.readHumidity();
        if (isnan(Luftfeuchte_SHT31)) {
          Luftfeuchte_SHT31 = No_Value;
        }
      }
    }
    else {
      Temperatur_SHT31 = No_Val;
      Luftfeuchte_SHT31 = No_Value;
    }
    if (i == 0) { // erster SHT31
      SensorTemp[4] = Temperatur_SHT31;
      SensorFeuchte[4] = Luftfeuchte_SHT31;
    }
    if (i == 1) { // zweiter SHT31
      SensorTemp[5] = Temperatur_SHT31;
      SensorFeuchte[5] = Luftfeuchte_SHT31;
    }

    debugprintF(" Temperatur  ");
    debugprint(i + 1);
    debugprintF(" [C]: ");
    debugprintln(Temperatur_SHT31);
    debugprintF(" Feuchte   ");
    debugprint(i + 1);
    debugprintF(" [%RH]: ");
    debugprintln(Luftfeuchte_SHT31);
    debugflush();

  }
}
#else
void Sensor_SHT31() {};
#endif
//----------------------------------------------------------------



//----------------------------------------------------------------
// Funktion BME280 - Temperatur und Luftfeuchte
//----------------------------------------------------------------
#if ((Anzahl_Sensoren_BME280 == 1) || (Anzahl_Sensoren_BME280 == 2))

#include "beelogger_Adafruit_BME280.h"
#define SEALEVELPRESSURE_HPA (1013.25f)

void Sensor_BME280() {

  debugprintF(" BME 280: ");
  debugprintln(Anzahl_Sensoren_BME280);
  debugflush();

  float Temperatur_BME = No_Val;
  float Luftfeuchte_BME = No_Value;
  float Luftdruck_BME = No_Value;
  uint8_t check;

  beelogger_Adafruit_BME280 my_bme;
  for (byte i = 0 ; i < Anzahl_Sensoren_BME280; i++) {
    check = my_bme.begin(BME280_adresse[i]); // I2C Adresse
    LogDelay (500); // time to get system ready
    if (check) { // if bme ok
      Temperatur_BME = my_bme.readTemperature();
      if (isnan(Temperatur_BME)) {
        Temperatur_BME = No_Val;
      }
      else {
        Luftfeuchte_BME = my_bme.readHumidity();
        if (isnan(Luftfeuchte_BME)) {
          Luftfeuchte_BME = No_Value;
        }
        Luftdruck_BME = my_bme.readPressure();
        if (isnan(Luftdruck_BME)) {
          Luftdruck_BME = No_Value;
        }
        else {
          Luftdruck_BME = Luftdruck_BME / 100.0;
        }
      }
    }
    else {
      Temperatur_BME = No_Val;
      Luftfeuchte_BME = No_Value;
      Luftdruck_BME = No_Value;
    }
    if (i == 0) { // erster BME
      SensorTemp[6] = Temperatur_BME;
      SensorFeuchte[6] = Luftfeuchte_BME;
      Aux[0] = Luftdruck_BME;   // Hier kann die Zuordnung der Sensoren geändert werden
    }
    if (i == 1) { // zweiter BME
      SensorTemp[7] = Temperatur_BME;
      SensorFeuchte[7] = Luftfeuchte_BME;
      //Aux[0] = Luftdruck_BME;   // Hier kann die Zuordnung der Sensoren geändert werden
    }
    debugprintF(" Temperatur  ");
    debugprint(i + 1);
    debugprintF(" [C]: ");
    debugprintln(Temperatur_BME);
    debugprintF(" Feuchte [%RH]: ");
    debugprintln(Luftfeuchte_BME);
    debugprintF(" [hPa]: ");
    debugprintln(Luftdruck_BME);
    debugflush();

  }
}
#else
void Sensor_BME280() {};
#endif

//----------------------------------------------------------------

//----------------------------------------------------------------
// Setup the sensors and their instances
//----------------------------------------------------------------
void setup_sensors() {

  //----------------------------------------------------------------
  // Setup Gewicht
  //----------------------------------------------------------------
#if (Anzahl_Sensoren_Gewicht == 1)
  Sensor_Gewicht(true);   // Startwert Gewicht holen
#endif
  //----------------------------------------------------------------


  //----------------------------------------------------------------
  // Setup Bienenzähler
  //----------------------------------------------------------------
#if ((Anzahl_Sensoren_Bienenzaehler > 0) and (Anzahl_Sensoren_Bienenzaehler < 6))

  debugprint(F("Setup: Bienenzaehler konfiguriert: "));
  debugprintln(Anzahl_Sensoren_Bienenzaehler);
  debugflush();

  for (byte j = 0; j < Anzahl_Sensoren_Bienenzaehler; j++) {
    mcp[j].begin(j + 4);
    for (byte i = 0; i < 16; i++) {
      mcp[j].pinMode(i, INPUT);
      mcp[j].pullUp(i, LOW);
      LetzterSensor[j][i] = 0;
    }
  }
  BienenIntervall = millis();
  Sensor_Bienen();
#endif
  //--------------------------------------------------------------
}
//----------------------------------------------------------------
